C*********************************************************************
C*********************************************************************
C
      SUBROUTINE VBASIC
     I   ( ZGRID, PSFC,
     O     PRES0, DENS0, TEMP0, TPOT0, PPAI0,
     O     QVAP0, RVAP0,
     C     GRAV , RDRY , CPDRY, PSD,  RMVAP,
     D     NZ, NZB                              )
C
C*********************************************************************
      IMPLICIT REAL*8 ( A-H, O-Z )
C*********************************************************************
C
      parameter ( nzmaxm = 25000 )

      DIMENSION
     \   ZPROF(0:nzmaxm),
     \   TPROF(0:nzmaxm),
     \   PPROF(0:nzmaxm),
     \   PPLOG(0:nzmaxm),
     \   DPROF(0:nzmaxm)
C
C
      DIMENSION
     \   PRES0(-2:NZB), TEMP0(-2:NZB), TPOT0(-2:NZB),
     \   PPAI0(-2:NZB), DENS0(-2:NZB), ZGRID(-2:NZB),
     \   RVAP0(-2:NZB), QVAP0(-2:NZB)
C
C====================================================================
C
      NZMAX = nzmaxm
      DZZ = 1.00D1
C
      DO 101 IZ = 0, NZMAX
         ZPROF(IZ) = DZZ * IZ
  101 CONTINUE
C
      DO 102 IZ = 0, NZMAX
         TPROF(IZ) = TEMPZ( ZPROF(IZ) )
  102 CONTINUE
C
      pprof(0) = psfc
      dprof(0) = psfc / ( rdry * tprof(0) )
C
      pplog(0) = log(psfc)

      do 201 iz = 1, nzmax
         tmid = ( tprof(iz) + tprof(iz-1) ) / 2.0d0
         pplog(iz) = pplog(iz-1) - grav / rdry / tmid * dzz
         pprof(iz) = exp( pplog(iz) )
         dprof(iz) = pprof(iz)  / ( rdry * tprof(iz) )
 201  continue
C
C *** INTERPOLATION TO GRID POINTS. ***
C
      DO 301 IZ = 0, NZ
         IZZ = INT( ZGRID(IZ) / DZZ )
         FZZ = ( ZGRID(IZ) - DZZ*FLOAT(IZZ) ) / DZZ
         PRES0(IZ) =   ( 1.0D0 - FZZ ) * PPROF(IZZ  )
     \               +           FZZ   * PPROF(IZZ+1)
         DENS0(IZ) =   ( 1.0D0 - FZZ ) * DPROF(IZZ  )
     \               +           FZZ   * DPROF(IZZ+1)
  301 CONTINUE
C
C *** TEMPERATURE, WATER VAPOR ABUNDANCE ***
C
      DO 401 IZ = 0, NZ
C
         TEMP0(IZ) = TEMPZ( ZGRID(IZ) )
         PPAI0(IZ) = ( PRES0(IZ) / PSD ) ** ( RDRY / CPDRY )
         TPOT0(IZ) = TEMP0(IZ) / PPAI0(IZ)
C
         RVAP0(IZ) = 0.0D0
         QVAP0(IZ) = 0.0D0
c         QVAP0(IZ) = RVAP0(IZ) * EVSAT( TEMP0(IZ) ) / PRES0(IZ)
c     \                         * RMVAP
C
  401 CONTINUE
C
C *** BOUNDARY CONDITION ***
C
      ZGRID (  -1) = ZGRID( 0 )
      ZGRID (  -2) = ZGRID( 1 )
      ZGRID (NZ  ) = ZGRID( NZ-1 )
      ZGRID (NZ+1) = ZGRID( NZ-2 )
      ZGRID (NZ+2) = ZGRID( NZ-3 )
C
      PRES0 (  -1) = PRES0( 0 )
      PRES0 (  -2) = PRES0( 1 )
      PRES0 (NZ  ) = PRES0( NZ-1 )
      PRES0 (NZ+1) = PRES0( NZ-2 )
      PRES0 (NZ+2) = PRES0( NZ-3 )
C
      PPAI0 (  -1) = PPAI0( 0 )
      PPAI0 (  -2) = PPAI0( 1 )
      PPAI0 (NZ  ) = PPAI0( NZ-1 )
      PPAI0 (NZ+1) = PPAI0( NZ-2 )
      PPAI0 (NZ+2) = PPAI0( NZ-3 )
C
      DENS0 (  -1) = DENS0( 0 )
      DENS0 (  -2) = DENS0( 1 )
      DENS0 (NZ  ) = DENS0( NZ-1 )
      DENS0 (NZ+1) = DENS0( NZ-2 )
      DENS0 (NZ+2) = DENS0( NZ-3 )
C
      TEMP0 (  -1) = TEMP0( 0 )
      TEMP0 (  -2) = TEMP0( 1 )
      TEMP0 (NZ  ) = TEMP0( NZ-1 )
      TEMP0 (NZ+1) = TEMP0( NZ-2 )
      TEMP0 (NZ+2) = TEMP0( NZ-3 )
C
      TPOT0 (  -1) = TPOT0( 0 )
      TPOT0 (  -2) = TPOT0( 1 )
      TPOT0 (NZ  ) = TPOT0( NZ-1 )
      TPOT0 (NZ+1) = TPOT0( NZ-2 )
      TPOT0 (NZ+2) = TPOT0( NZ-3 )
C
      RVAP0 (  -1) = RVAP0( 0 )
      RVAP0 (  -2) = RVAP0( 1 )
      RVAP0 (NZ  ) = RVAP0( NZ-1 )
      RVAP0 (NZ+1) = RVAP0( NZ-2 )
      RVAP0 (NZ+2) = RVAP0( NZ-3 )
C
      QVAP0 (  -1) = QVAP0( 0 )
      QVAP0 (  -2) = QVAP0( 1 )
      QVAP0 (NZ  ) = QVAP0( NZ-1 )
      QVAP0 (NZ+1) = QVAP0( NZ-2 )
      QVAP0 (NZ+2) = QVAP0( NZ-3 )
C
C---------------------------------------------------------------------
c      WRITE(6,*) '**DENS0 OBTAINED IN SUBROUTINE VBASIC'
c      WRITE(6,*) DENS0
C
C
      RETURN
      E N D
