C*********************************************************************
C
C     PROGRAM xzcont_uwtq_cl
C
C     x-zʿ޺ץ(, , 顼)
C
C      1997/07/24 
C          1997/07/25 
C          1997/07/26 
C          1997/07/26 
C          1998/09/15 
C          1998/10/02 
C          1999/01/17 
C          1999/01/18 
C          1999/01/25 
C          1999/02/04 
C
C*********************************************************************
      program xzcont_uwtq_cl
*-----------------------------------------------------
      implicit real*8 ( a-h, o-z )
*-----------------------------------------------------

#include "grid_size_M.f"

      parameter ( nbr3 = 3*((nx+6)*(nz+6)/16+1) )
*-----------------------------------------------------
      integer ibr(nbr3)
*-----------------------------------------------------
      real cdp_uw,cdp_pt,cdp_qv,cdp_ptd ! 顼ȡ
      real tlev1,tlev2          ! 顼٥
      integer ipat              ! ȡֹ
      integer cmax
      parameter ( cmax = 56 )   ! 顼

      real wmax, wmin, umax, umin, ptmax, ptmin, qvmax, qvmin
      real ptdmax, ptdmin
      parameter ( wmax = 30., wmin = -30., umax = 30., umin = -30. )
      parameter ( ptmax = 280., ptmin = 220. )
      parameter ( ptdmax = 3.0, ptdmin = -3.0 )
      parameter ( qvmax = 10.e-6, qvmin = 1.e-6 )

      real*4 pti_u(2,cmax), pti_w(2,cmax)
      real*4 pti_pt(2,cmax), pti_ptd(2,cmax)
      real*4 pti_qv(2,cmax)
*-----------------------------------------------------
      real*8
     \   zgrid ( -2:nzb ),
     \   temp0 ( -2:nzb ),
     \   tpot0 ( -2:nzb ),
     \   dens0 ( -2:nzb ),
     \   ppai0 ( -2:nzb ),
     \   pres0 ( -2:nzb ),
     \   rvap0 ( -2:nzb ),
     \   qvap0 ( -2:nzb )

      real*8
     \     u ( -2:nxb, -2:nzb ),
     \     w ( -2:nxb, -2:nzb ),
     \     tpot ( -2:nxb, -2:nzb ),
     \     qvap ( -2:nxb, -2:nzb )

      real*4
     \    z0p ( 0:nz ), 
     \    p0p ( 0:nz ),
     \    d0p ( 0:nz ),
     \ temp0p ( 0:nz ),
     \ tpot0p ( 0:nz ),
     \  pai0p ( 0:nz ),
     \ rvap0p ( 0:nz ),
     \ qvap0p ( 0:nz )

      real*4 
     \      up ( nx+1,nz+1 ),
     \      wp ( nx+1,nz+1 ),
     \      tpotp ( nx+1, nz+1 ),
     \      tpall ( nx+1, nz+1 ),
     \      tpave ( nz+1 ),
     \      tpdev ( nx+1, nz+1 ),
     \      qvapp ( nx+1, nz+1 )


      character*6 stime
      character*11 ttime
      character*100 dumy

*-----------------------------------------------------
      
      open (11,file='exparam')
      read (11,*) irun
      read (11,*) time0, nloop1, nloop2, dtime, ntmoni, ntkubu

      call FOPEN ( irun+1 )

      do iz = 1,9
         read(16,'(a100)') dumy
      end do

      do iz = -2, nzb
         read(16,*) ii, zgrid(iz), pres0(iz), dens0(iz), temp0(iz),
     \                     tpot0(iz), ppai0(iz), qvap0(iz), rvap0(iz)
      end do

      do iz = 0, nz
         z0p(iz)   = zgrid(iz)
         p0p(iz)   = pres0(iz)
         d0p(iz)   = dens0(iz)
         temp0p(iz)= temp0(iz)
         tpot0p(iz)= tpot0(iz)
         pai0p(iz) = ppai0(iz)
         rvap0p(iz)= rvap0(iz)
         qvap0p(iz)= qvap0(iz)
      end do

      write(6,*) 'data number = ', nloop1
      write(6,*) 'INPUT DATA BEGINING, END, & INTERVAL' 
      write(6,*) 'itb ite interval ?'
      read (*,*) itb, ite, interv
      write(6,*) 'SELECT TEMP. MODE (I)' 
      write(6,*) '1; RAW PTEMP 2; DEVIATION ?' 
      read (5,*) IDN

      call sgpwsn
      read(*,*) iws

      call gropn(-iws)
      call sldiv( 'T', 1, 4 )
      call swlset( 'LALT',  .TRUE. )
      call sglset( 'LFULL', .TRUE. )
      call sglset( 'LCORNER', .FALSE. )
      call uzfact(0.6)

      cdp_uw = (wmax - wmin)/cmax
      cdp_pt = (ptmax - ptmin)/cmax
      cdp_qv = (qvmax - qvmin)/cmax
      cdp_ptd = (ptdmax - ptdmin)/cmax
      do k=1,cmax+1
        pti_w(1,k) = wmin + (k-1)*cdp_uw
        pti_w(2,k) = wmin + (k-1)*cdp_uw
        pti_pt(1,k) = ptmin + (k-1)*cdp_pt
        pti_pt(2,k) = ptmin + (k-1)*cdp_pt
        pti_qv(1,k) = qvmin + (k-1)*cdp_qv
        pti_qv(2,k) = qvmin + (k-1)*cdp_qv
        pti_ptd(1,k) = ptdmin + (k-1)*cdp_ptd
        pti_ptd(2,k) = ptdmin + (k-1)*cdp_ptd
      end do

      do it = 1, ite

      read(31) time, ((u(ix,iz),ix=-2,nxb), iz=-2,nzb)
      read(33) time, ((w(ix,iz),ix=-2,nxb), iz=-2,nzb)
      read(34) time, ((tpot(ix,iz),ix=-2,nxb), iz=-2,nzb)
      read(35) time, ((qvap(ix,iz),ix=-2,nxb), iz=-2,nzb)

      write(0,*) 'reading time = ', time

      if ( it .ge. itb   .and.  it .le. ite ) then
         if ( mod( (it-itb), interv ) .eq. 0 ) then

            write(0,*) 'writing time = ', time
            
            write(stime,100) INT(time)
 100        format(I6.6)
            ttime = 't=' // stime // 'sec'

            do iz = 1,nz+1            
               do ix = 1, nx+1
                  up(ix,iz)    = u(ix-1,iz-1)
                  wp(ix,iz)    = w(ix-1,iz-1)
                  qvapp(ix,iz) = qvap(ix-1,iz-1)
                  tpotp(ix,iz) = tpot(ix-1,iz-1)
                  tpall(ix,iz) = tpot(ix-1,iz-1) + tpot0(iz-1)
               end do
            end do

            do iz = 1, nz+1
               tpave(iz) = 0.
               do ix = 1,nx+1
                  tpave(iz) = tpave(iz) + tpall(ix,iz) /(nx+1)
               end do
            end do

            do iz = 1,nz+1
               do ix = 1, nx+1
                  tpdev(ix,iz) = tpall(ix,iz) - tpave(iz) 
               end do
            end do

*
*
C*********************************************************************
C w
C*********************************************************************
            do i = 1,cmax
               TLEV2 =  wmin + i*cdp_uw
               TLEV1 =  TLEV2 - cdp_uw
               ipat  = (30+(i-1))*1000 + 999
               call uestlv(TLEV1, TLEV2, IPAT)
            end do

            call grfrm
            call grfig
            call grswnd ( 0.0, 51.2, 0.0, 10.0 )
            call grsvpt ( 0.1, 0.9, 0.15, 0.306 )
            call grstrn (1)
            call uspfit
            call grstrf
            call udpset ( 'rsizet', 0.01 )
            call ussttl ( 'W[m/s]', 'X[km]', '', 'Z[km]' )
            call uetonf ( wp, nx+1, nx+1, nz+1 )
            call usdaxs
            call uxsttl ( 'T', ttime, 1. )
C*********************************************************************
C ȡС
C*********************************************************************
            call grfig
            call grswnd( 0.0, 1.0,  wmin, wmax )
            call grsvpt( 0.95, 0.98,  0.15,  0.306 )
            call grstrn( 1 )
            call grstrf
            call uetone( pti_w, 2, 2, cmax+1 )
            call slpvpr( 3 )
            call uyaxdv( 'L', 5., 10. )
            call uzinit

C*********************************************************************
C u
C*********************************************************************

            call grfrm
            call grfig
            call grswnd ( 0.0, 51.2, 0.0, 10.0 )
            call grsvpt ( 0.1, 0.9, 0.15, 0.306 )
            call grstrn (1)
            call uspfit
            call grstrf
            call udpset ( 'rsizet', 0.01 )
            call ussttl ( 'U[m/s]', 'X[km]', '', 'Z[km]' )
            call uetonf ( up, nx+1, nx+1, nz+1 )
            call usdaxs
            call uxsttl ( 'T', ttime, 1. )
C*********************************************************************
C ȡС
C*********************************************************************
            call grfig
            call grswnd( 0.0, 1.0,  umin, umax )
            call grsvpt( 0.95, 0.98,  0.15,  0.306 )
            call grstrn( 1 )
            call grstrf
            call uetone( pti_w, 2, 2, cmax+1 )
            call slpvpr( 3 )
            call uyaxdv( 'L', 5., 10. )
            call uzinit

            call ueitlv
*
*

            if ( IDN .eq. 1 ) then 

C*********************************************************************
C pt
C*********************************************************************

            do i = 1,cmax
               TLEV2 =  ptmin + i*cdp_pt 
               TLEV1 =  TLEV2 - cdp_pt
               ipat  = (30+(i-1))*1000 + 999
               call uestlv(TLEV1, TLEV2, IPAT)
            end do

            call grfrm
            call grfig
            call grswnd ( 0.0, 51.2, 0.0, 10.0 )
            call grsvpt ( 0.1, 0.9, 0.15, 0.306 )
            call grstrn (1)
            call uspfit
            call grstrf
            call udpset ( 'rsizet', 0.01 )
            call ussttl ( 'THETA[K]', 'X[km]', '', 'Z[km]' )
            call uetonf ( tpall, nx+1, nx+1, nz+1 )
            call usdaxs
            call uxsttl ( 'T', ttime, 1. )
C*********************************************************************
C ȡС
C*********************************************************************
            call grfig
            call grswnd( 0.0, 1.0,  ptmin, ptmax )
            call grsvpt( 0.95, 0.98,  0.15,  0.306 )
            call grstrn( 1 )
            call grstrf
            call uetone( pti_pt, 2, 2, cmax+1 )
            call slpvpr( 3 )
            call uyaxdv( 'L', 2., 10. )
            call uzinit
            call ueitlv

            else 
C*********************************************************************
C ptemp_dev
C*********************************************************************
            do i = 1,cmax
               TLEV2 =  ptdmin + i*cdp_ptd 
               TLEV1 =  TLEV2 - cdp_ptd
               ipat  = (30+(i-1))*1000 + 999
               call uestlv(TLEV1, TLEV2, IPAT)
            end do

            call grfrm
            call grfig
            call grswnd ( 0.0, 51.2, 0.0, 10.0 )
            call grsvpt ( 0.1, 0.9, 0.15, 0.306 )
            call grstrn (1)
            call uspfit
            call grstrf
            call udpset ( 'rsizet', 0.01 )
            call ussttl ( 'anomaly THETA[K]', 'X[km]', '', 'Z[km]' )
            call uetonf ( tpdev, nx+1, nx+1, nz+1 )
            call usdaxs
            call uxsttl ( 'T', ttime, 1. )
C*********************************************************************
C ȡС
C*********************************************************************
            call grfig
            call grswnd( 0.0, 1.0,  ptdmin, ptdmax )
            call grsvpt( 0.95, 0.98,  0.15,  0.306 )
            call grstrn( 1 )
            call grstrf
            call uetone( pti_ptd, 2, 2, cmax+1 )
            call slpvpr( 3 )
            call uyaxdv( 'L', 0.2, 1.0 )
            call uzinit
            call ueitlv

            end if

C*********************************************************************
C qv
C*********************************************************************
*
            do i = 1,cmax
               TLEV2 =  qvmin + i*cdp_qv 
               TLEV1 =  TLEV2 - cdp_qv
               ipat  = (30+(i-1))*1000 + 999
               call uestlv(TLEV1, TLEV2, IPAT)
            end do

            call grfrm
            call grfig
            call grswnd( 0.0, 51.2, 0.0, 10.0 )
            call grsvpt( 0.1, 0.9, 0.15, 0.306 )
            call grstrn(1)
            call uspfit
            call grstrf
            call udpset ( 'rsizet', 0.01 )
            call ussttl ( 'Q[kg/kg]', 'X[km]', '', 'Z[km]' )
            call uetonf ( qvapp, nx+1, nx+1, nz+1 )
            call usdaxs
            call uxsttl ( 'T', ttime, 1. )
C*********************************************************************
C ȡС
C*********************************************************************
            call grfig
            call grswnd( 0.0, 1.0,  0.0, qvmax )
            call grsvpt( 0.95, 0.98,  0.15,  0.306 )
            call grstrn( 1 )
            call grstrf
            call uetone( pti_qv, 2, 2, cmax+1 )
            call slpvpr( 3 )
            call uyaxdv( 'L', 1.e-6, 5.e-6 )
            call ueitlv

         end if
      end if

      end do

      call grcls

      call FCLOSE

      end
