C*********************************************************************
C
C     PROGRAM fxsurf
C
C     ɽեåʿʬۿ()
C
C      1999/02/08 
C      2000/04/17 
C
C*********************************************************************
      program fxsurf
*-----------------------------------------------------
      implicit real*8 ( a-h, o-z )
*-----------------------------------------------------

#include "grid_size_M.f"

      parameter ( nbr3 = 3*((nx+6)*(nz+6)/16+1) )
*-----------------------------------------------------
      integer ibr(nbr3)
*-----------------------------------------------------
      dimension
     \   zgrid ( -2:nzb ),
     \   temp0 ( -2:nzb ),
     \   tpot0 ( -2:nzb ),
     \   dens0 ( -2:nzb ),
     \   ppai0 ( -2:nzb ),
     \   pres0 ( -2:nzb ),
     \   rvap0 ( -2:nzb ),
     \   qvap0 ( -2:nzb )

      dimension
     \     u ( -2:nxb, -2:nzb ),
     \     v ( -2:nxb, -2:nzb ),
     \     w ( -2:nxb, -2:nzb ),
     \     tpot ( -2:nxb, -2:nzb )

      dimension
     \     uu   ( -2:NXB, -2:NZB, NROT ),
     \     vv   ( -2:NXB, -2:NZB, NROT ),
     \     ttpot( -2:NXB, -2:NZB, NROT )

      DIMENSION
     \     CDRAGV( -2:NXB ),
     \     RICHD( -2:NXB ),
     \     TSFC ( -2:NXB )

      real*4
     \    z0p ( 0:nz ), 
     \    p0p ( 0:nz ),
     \    d0p ( 0:nz ),
     \ temp0p ( 0:nz ),
     \ tpot0p ( 0:nz ),
     \  pai0p ( 0:nz ),
     \ rvap0p ( 0:nz ),
     \ qvap0p ( 0:nz )

      real*4 
     \      up ( nx+1,nz+1 ),
     \      vp ( nx+1,nz+1 ),
     \      wp ( nx+1,nz+1 ),
     \      tpotp ( nx+1, nz+1 ),
     \      tpall ( nx+1, nz+1 ),
     \      cdragvp( nx+1 ),
     \      richdp( nx+1 ),
     \      tsfcp ( nx+1 ),
     \      fheat( nx+1 ),
     \      xplot( nx+1 )

      real*4 fheatgg( nx+1 ),cdragn( nx+1 ),stress( nx+1 )

      character*6 stime
      character*11 ttime
      character*100 dumy

      character*2 hour
      character*2 day
      character*14 header
*-----------------------------------------------------
      
      open (11,file='exparam')
      read (11,*) irun
      read (11,*) time0, nloop1, nloop2, dtime, ntmoni, ntkubu

      call SETCST( grav, psd, amdry, rdry, cpdry, rmvap, alatent )

      call FOPEN ( irun+1 )

      write(day,'(I2.2)') irun-1

      do iz = 1,9
         read(16,'(a100)') dumy
      end do

      do iz = -2, nzb
         read(16,*) ii, zgrid(iz), pres0(iz), dens0(iz), temp0(iz),
     \                     tpot0(iz), ppai0(iz), qvap0(iz), rvap0(iz)
      end do

      do iz = 0, nz
         z0p(iz)   = zgrid(iz)
         p0p(iz)   = pres0(iz)
         d0p(iz)   = dens0(iz)
         temp0p(iz)= temp0(iz)
         tpot0p(iz)= tpot0(iz)
         pai0p(iz) = ppai0(iz)
         rvap0p(iz)= rvap0(iz)
         qvap0p(iz)= qvap0(iz)
      end do

      do ix = 1, nx+1
         xplot(ix) = 0.1 * (ix - 1)
         cdragn(ix) = ( 0.35 / ( LOG ( z0p(0) / 1.0E-2 ) ) ) **2
      end do

      write(6,*) 'data number = ', nloop1
      write(6,*) 'INPUT DATA BEGINING, END, & INTERVAL' 
      write(6,*) 'itb ite interval ?'
      read (*,*) itb, ite, interv

      call sgpwsn
      read(*,*) iws

      call gropn(iws)
      call sldiv( 'T', 1, 3 )
c      call sldiv( 'T', 1, 2 )
      call swlset( 'LALT',  .TRUE. )
      call sglset( 'LFULL', .TRUE. )
      call sglset( 'LCORNER', .FALSE. )
      call uzfact(0.6)

      do it = 1, ite

      read(31) time, ((u(ix,iz),ix=-2,nxb), iz=-2,nzb)
      read(32) time, ((v(ix,iz),ix=-2,nxb), iz=-2,nzb)
      read(33) time, ((w(ix,iz),ix=-2,nxb), iz=-2,nzb)
      read(34) time, ((tpot(ix,iz),ix=-2,nxb), iz=-2,nzb)

      write(0,*) 'reading time = ', time

      if ( it .ge. itb   .and.  it .le. ite ) then
         if ( mod( (it-itb), interv ) .eq. 0 ) then

            write(0,*) 'writing time = ', time
            
c            write(stime,100) INT(time)
c 100        format(I6.6)
c            ttime = 't=' // stime // 'sec'

            PI = 3.141592D0
            DO 110 IX = -2, NX+2
c               TSFC(IX) = 180.0D0 + 0.7D+2 * 
               TSFC(IX) = 180.0D0 + 1.0D+2 * 
     \      MAX( sin( 2.0d0 * PI * (TIME+2.88D+4) / 8.64D+4 ), 0.0D0 )
c     \              MAX( sin( 2.0d0 * PI * TIME / 8.64D+4 ), 0.0D0 )
c               TSFC(IX) = 270.0D0
 110        CONTINUE


c*** Ѵ: ä LT ************************************
            time = time - 86400.* ( irun - 2 )
            time = time / 3600. + 6

            if ( INT(time) .ge. 24 ) then
               time = time - 24
            end if

            write(hour, '(I2.2)') INT(time)
            header = 'day' // day // ' LT=' // hour // ':00'
c**************************************************************

            do iz = -2,nzb            
               do ix = -2, nxb
                  uu   (ix,iz,1) = u(ix,iz)
                  vv   (ix,iz,1) = v(ix,iz)
                  ttpot(ix,iz,1) = tpot(ix,iz)
               end do
            end do
      
            call CLDRAG
     I      ( uu    , vv    , ttpot, 
     I        1, 
     I        TPOT0, 
     O        RICHD, CDRAGV, 
     G        ZGRID, 
     C        GRAV , TSFC ,
     D        NX, NXB, NZB, NROT )

            do iz = 1,nz+1            
               do ix = 1, nx+1
                  up(ix,iz)    = u(ix-1,iz-1)
                  vp(ix,iz)    = v(ix-1,iz-1)
                  wp(ix,iz)    = w(ix-1,iz-1)
                  tpotp(ix,iz) = tpot(ix-1,iz-1)
                  tpall(ix,iz) = tpot(ix-1,iz-1) + tpot0(iz-1)
               end do
            end do

            do ix = 1,nx+1
               cdragvp( ix )= cdragv(ix-1)
               richdp( ix ) = MIN(richd(ix-1),0.25)
               tsfcp ( ix ) = tsfc(ix-1)
            end do
*
*
            do ix = 1,nx+1
               vsfc = SQRT( up(ix,1)**2 + vp(ix,1)**2 )
               fheat(ix) = - cdragvp(ix) * VSFC * CPDRY *dens0(0)
     \              * ( tpall(ix,1)*PPAI0(0) - tsfcp(ix) )
               stress(ix) = d0p(0) * cdragvp(ix) * VSFC **2
               delt = tpall(ix,1)*PPAI0(0) - tsfcp(ix)
            end do

            do ix = 1, nx+1
               fheatgg(ix) =  0.089 * dens0(0) * CPDRY * 2.0 *8.0E-4
     \  * ( MAX ( tsfcp(ix) - tpall(ix,1)*PPAI0(0), 0.0 ) ) ** 1.3
     \  * ( GRAV / (tpall(ix,1)*PPAI0(0)) / 8.0E-4 / 10.0E-4 ) ** 0.3
            end do

            call grfrm
c            call grswnd ( 0.0, 51.2, -5.0E+3, 0.25 )
            call grswnd ( 0.0, 51.2, 0.0, 0.05 )
            call grsvpt ( 0.15, 0.95, 0.1, 0.2 )
c            call grsvpt ( 0.15, 0.95, 0.15, 0.306 )
            call grstrn (1)
            call uspfit
            call grstrf
            call udpset ( 'rsizet', 0.01 )
            call ussttl ( '', 'X[km]', 'Cd', '' )
c            call ussttl ( '', 'X[km]', 'Ri', '' )
            call usdaxs
c            call uxsttl ( 'T', ttime, 1. )
            call uxsttl ( 'T', header, 1. )
c            call uulinz ( nx+1, xplot, richdp, 1, 1 )
            call uulinz ( nx+1, xplot, cdragvp, 1, 1 )
            call uulinz ( nx+1, xplot, cdragn, 3, 1 )
*
*
            call grfrm
c            call grswnd ( 0.0, 51.2, -5.0, 10. )
            call grswnd ( 0.0, 51.2, -5.0, 30. )
c            call grsvpt ( 0.15, 0.95, 0.15, 0.306 )
            call grsvpt ( 0.15, 0.95, 0.1, 0.2 )
            call grstrn (1)
            call uspfit
            call grstrf
            call udpset ( 'rsizet', 0.01 )
            call ussttl ( '', 'X[km]', 'Fheat', '[W/m2]' )
            call usdaxs
c            call uxsttl ( 'T', ttime, 1. )
            call uxsttl ( 'T', header, 1. )
            call uulinz ( nx+1, xplot, fheat, 1, 1 )
            call uulinz ( nx+1, xplot, fheatgg, 2, 1 )

            call grfrm
            call grswnd ( 0.0, 51.2, 0.0, 0.05 )
c            call grsvpt ( 0.15, 0.95, 0.15, 0.306 )
            call grsvpt ( 0.15, 0.95, 0.1, 0.2 )
            call grstrn (1)
            call uspfit
            call grstrf
            call udpset ( 'rsizet', 0.01 )
            call ussttl ( '', 'X[km]', 'Stress', '[N/m^2]' )
            call usdaxs
            call uxsttl ( 'T', header, 1. )
            call uulinz ( nx+1, xplot, stress, 1, 2 )

         end if
      end if

      end do

      call grcls

      call FCLOSE

      end
