C*********************************************************************
C
C     PROGRAM fxsurf_h
C     
C     ʿʿɽǮեåץ
C
C     1998/09/22  
C     1998/10/02  
C     1999/02/04  
C     1999/02/04  
C
C*********************************************************************
      program fxsurf_h
      implicit real*8 ( a-h, o-z )
C---------------------------------------------------------------------  
#include "grid_size_M.f"
      parameter ( nzprof = nz )
      parameter ( nzp = nz+1, ntp = 120 )
C---------------------------------------------------------------------  
C                                                                       
      CHARACTER*10 NMZPRF( NZPROF )                                     
      character*5  nmrun
      character*4  from
      character*1  chara
      character*1  pz
      character*6  t_end
      character*6  t_begin

      character*5  header
      character*2  day

      real*4  dtpad0,dqvad0
      real*4  zgrid(nzp),tptend(nzp),tpmean(nzp),
     &        dtpadv(nzp),dtpdif(nzp),dtpdnl(nzp),
     &        dtpdi0(nzp),dtprad(nzp),tperror(nzp)

      real*4 time(30)
      real*4 heat1(30)
      real*4 heat2(30)
      real*4 heat3(30)
      real*4 sflux_h1(30)
      real*4 sflux_h2(30)
      real*4 sflux_h3(30)
      real*4 LT(30)

      real*4 time_p(24)
      real*4 sflux_hp(24)
      real*4 ltime(24)

      integer begin,end,interv
      integer nloop1
*-----------------------------------------------------

      real*4 z0(-2:nzb), p0(-2:nzb), d0(-2:nzb), 
     \       temp0(-2:nzb), tpot0(-2:nzb), ppai0(-2:nzb)

*-----------------------------------------------------

      call SETCST( grav, psd, amdry, rdry, cpdry, rmvap, alatent )

      open (11,file='exparam')
      read (11,*) irun
      read (11,*) time0, nloop1, nloop2, dtime, ntmoni, ntkubu
      close (11)
      
      tinterv = nloop2 

      write(day,'(I2.2)') irun-1
      header = 'day' // day 

      call FOPEN ( irun+1 )

      do iz = 1,9
         read(16,'(a100)') dumy
      end do

      do iz = -2, nzb
         read(16,*) ii, z0(iz), p0(iz), d0(iz), temp0(iz),
     \                     tpot0(iz), ppai0(iz), dum1, dum2
      end do

      read(12,*) (time(j),j=1,nloop1),(heat1(j),j=1,nloop1)
c      read(13,*) (time(j),j=1,nloop1),(heat2(j),j=1,nloop1)
c      read(14,*) (time(j),j=1,nloop1),(heat3(j),j=1,nloop1)


      do i = 1, nloop1
c         time(i) = time(i) / tinterv
         time(i) = ( time(i) - (irun -2)*86400 ) / tinterv - 0.5 + 6 
         sflux_h1(i) = heat1(i) / tinterv / 51200.0 

         if ( INT(time(i)) .ge. 24. ) then
            time(i) = time(i) - 24
         end if

      end do

      do i = 1, 6
         heat1(i) = sflux_h1(i+18)
         LT(i)    = time(i+18)
      end do

      do i = 1, 18
         heat1(i+6) = sflux_h1(i)
         LT(i+6)    = time(i)
      end do
      LT(24) = 24
  
      call sgpwsn
      read(*,*) iws

      call gropn(iws)
      call sglset( 'LCORNER', .FALSE. )
      
      call grfrm
      call grswnd( 0., 24., -5., 20. )
      call grsvpt( 0.2, 0.8, 0.2, 0.8 )
      call grstrn(1)
      call grstrf
      call uxaxdv ( 'B', 1., 6. )
      call uxaxdv ( 'T', 1., 6. )
      call uyaxdv ( 'L', 1., 5. )
      call uyaxdv ( 'R', 1., 5. )
      call uxsttl ( 'T', header, 1. )
      call uxsttl( 'B', 'LT [hour]', 0. )
      call uysttl( 'L', 'Heat flux [W/m^2]', 0. )
      call sglset( 'LCHAR', .TRUE. )
      call uulinz(nloop1, LT, heat1,  1, 2)
      call grcls

      call FCLOSE ( irun+1 )

      end



