C*********************************************************************
C
C     PROGRAM fxsurf
C
C     ʿѿʿ®
C
C      1999/11/10 
C
C*********************************************************************
      program vsurf
*-----------------------------------------------------
      implicit real*8 ( a-h, o-z )
*-----------------------------------------------------

#include "grid_size_M.f"

      parameter ( nbr3 = 3*((nx+6)*(nz+6)/16+1) )
*-----------------------------------------------------
      integer ibr(nbr3)
*-----------------------------------------------------
      dimension
     \     u ( -2:nxb, -2:nzb ),
     \     v ( -2:nxb, -2:nzb )

      real*4 
     \     up ( nx+1,nz+1 ),
     \     vp ( nx+1,nz+1 ),
     \     vsfc ( nx+1 ),
     \     time_p( nx+1 )

      real*4
     \     vsfc_id( nx+1 )


      real*4 time_max, time_min

      character*2 day
      character*6 header

*-----------------------------------------------------
      
      open (11,file='exparam')
      read (11,*) irun
      read (11,*) time0, nloop1, nloop2, dtime, ntmoni, ntkubu

      call SETCST( grav, psd, amdry, rdry, cpdry, rmvap, alatent )

      call FOPEN ( irun+1 )

      write(6,*) 'data number = ', nloop1
      write(day, '(I2.2)') INT(irun)
      header = 'day=' // day 

      time_max = 6.
      time_min = 6.

      do it = 1, nloop1

         read(31) time, ((u(ix,iz),ix=-2,nxb), iz=-2,nzb)
         read(32) time, ((v(ix,iz),ix=-2,nxb), iz=-2,nzb)

         write(0,*) 'reading time = ', time
           
c*** Ѵ: ä LT ************************************
         time = time - 86400.* ( irun -1 )
         time = time / 3600. + 6

c         if ( INT(time) .ge. 24 ) then
c            time = time - 24
c         end if

c**************************************************************

         do iz = 1,nz+1            
            do ix = 1, nx+1
               up( ix, iz ) = u( ix-1, iz-1 )
               vp( ix, iz ) = v( ix-1, iz-1 )
            end do
         end do

         vsfc(it) = 0.0
         time_p(it) = time

         do ix = 1,nx+1
            vsfc( it ) = vsfc( it ) + SQRT( up(ix,3)**2 + vp(ix,3)**2 )
         end do

         vsfc( it ) = vsfc( it ) / ( nx+1 )
         time_max = MAX( time_max, time_p(it) )
         time_min = MIN( time_min, time_p(it) )
     
      end do

      do it = 1, nloop1
         vsfc_id( it ) = 0.5 + 
     \        15.0 * exp ( - ( ( time_p(it) - 15. ) / 3.0 )**2 )
      end do

      call sgpwsn
      read(*,*) iws

      call gropn(iws)
      call sglset( 'LCORNER', .FALSE. )

      call grfrm
      call grswnd ( time_min, time_max, 0., 20. )
      call grsvpt ( 0.2, 0.8, 0.2, 0.8 )
      call grstrn (1)
      call grstrf
      call ussttl ( 'LT', '[hour]', 'Vsfc', '[m/sec]' )
      call usdaxs
      call uxsttl ( 'T', header, 1. )
      call uulinz ( nloop1, time_p, vsfc, 1, 2 )
      call uulinz ( nloop1, time_p, vsfc_id, 3, 2 )

      call grcls

      call FCLOSE

      end
