!=================================================================
!  ̣ͥեåѲ
!
!  1999/05/31  
!  1999/06/04  
!  2000/03/20  
!  2000/04/19  
!  2000/05/25  
!=================================================================
      program rad
!-----------------------------------------------------------------      
      implicit real*8 ( a-h,o-z )
!-----------------------------------------------------------------      
#include "grid_size_M.f"
!-----------------------------------------------------------------      
      parameter ( NBND = 16 )
      parameter ( SIGMA = 5.67D-8 )

      dimension
     \   ZGRID ( -2:NZB ),
     \   TEMP0 ( -2:NZB ),
     \   TPOT0 ( -2:NZB ),
     \   DENS0 ( -2:NZB ),
     \   PPAI0 ( -2:NZB ),
     \   PRES0 ( -2:NZB ),
     \   RVAP0 ( -2:NZB ),
     \   QVAP0 ( -2:NZB )

      dimension
     \  TPOT ( -2:NXB, -2:NZB )

      dimension
     \  TEMP ( -2:NXB, -2:NZRB ) 

      DIMENSION
     \   FDZ  ( -2:NZB ), FDZM ( -2:NZB )

      dimension 
     \   OPL   (-2:NZRB),
     \   RGRID (-2:NZRB),
     \   RDZ   (-2:NZRB), 
     \   RDZM  (-2:NZRB)

      dimension
     \   TAUN( 0:NZR+1, 0:NZR+1, NBND ),
     \   WNU(NBND), SNU(NBND), RNU(NBND)

      dimension
     \   BBRAD ( -2:NXB, -2:NZRB ),
     \   FXRADU( -2:NXB, -2:NZRB ),
     \   FXRADD( -2:NXB, -2:NZRB ),
     \   FXRADN( -2:NXB, -2:NZRB ),
     \   BBRAD_S( -2:NXB )

      DIMENSION
     \   FXRADU_NU(-2:NXB,-2:NZRB,NBND), 
     \   FXRADD_NU(-2:NXB,-2:NZRB,NBND)

      dimension
     \  FXRADN_mean(-2:NZRB)

      dimension TSFC( -2:NXB ), QVSFC( -2:NXB ), FCOLI( -2:NXB )

      real*4 sflux_h1(30)
      real*4 heat1(30)

      real*4 time_p(30)
      real*4 LT(30)
      real*4 rflux(30)
      real*4 heat2(30)

      character*5 header
      character*2 day

      character*100 dumy

      NAMELIST /CONST1/ GRAV, PSD, AMDRY, RDRY, CPDRY, RMVAP, ALATNT
      NAMELIST /CONST2/ CDRAG, VSFC0, PSFC

!-----------------------------------------------------------------      
! ʪ
!-----------------------------------------------------------------      

      call SETCST
     O   ( GRAV, PSD, AMDRY, RDRY, CPDRY, RMVAP, ALATNT )

      call SETCS2
     O   ( CDRAG, VSFC0, TSFC, QVSFC,
     O     FCOLI,
     O     PSFC,
     C     RMVAP,
     C     FXSOL,
     D     NX, NXB                      )

!-----------------------------------------------------------------      

      open(10,file='exparam')
      read(10,*) IRUN
      read(10,*) TIME0, NLOOP1, NLOOP2, DTIME

      tinterv = nloop2 

      write(day,'(I2.2)') irun-1
      header = 'day' // day 

      call FOPEN ( irun+1 )

      do iz = 1,9
         read(16,'(a100)') dumy
      end do

      do iz = -2, nzb
         read(16,*) ii, zgrid(iz), pres0(iz), dens0(iz), temp0(iz),
     \                     tpot0(iz), ppai0(iz), qvap0(iz), rvap0(iz)
      end do

!-----------------------------------------------------------------      
! 

      do iz = -2, NZRB
      do ix = -2, NXB
         FXRADU(ix,iz) = 0.0D0
         FXRADD(ix,iz) = 0.0D0
         FXRADN(ix,iz) = 0.0D0
         BBRAD (ix,iz) = 0.0D0
      end do
      end do

      do inb = 1, NBND
      do iz = -2, NZRB
      do ix = -2, NXB 
         FXRADU_NU(ix,iz,inb) = 0.0D0
         FXRADD_NU(ix,iz,inb) = 0.0D0
      end do
      end do
      end do

      do ix = -2, NXB
         BBRAD_S(ix) = 0.0D0
      end do

!-----------------------------------------------------------------      
! ;ν; Хɥѥ᥿
! (Houghton, 1986;The physics of atmosphere, 2nd ed., 
!  Cambridge Univ. Press)

      DATA ( WNU(I), I=1,NBND )
     1     /  512.5D0,  537.5D0,  562.5D0,  587.5D0,
     2        612.5D0,  637.5D0,  662.5D0,  687.5D0,  
     3        712.5D0,  737.5D0,  762.5D0,  787.5D0,
     4        812.5D0,  837.5D0,  862.5D0,  887.5D0  / 

      DATA ( SNU(I), I=1,NBND )
     1     /  1.952D-2,  2.785D-1,  5.495D-1,  5.331D0, 
     2        5.196D+2,  7.778D+3,  8.746D+4,  2.600D+4,
     3        1.232D+3,  2.042D+2,  7.278D0 ,  1.337D0,
     4        3.974D-1,  1.280D-2,  2.501D-3,  3.937D-3  /

      DATA ( RNU(I), I=1,NBND )
     1     /  2.870D-1,  1.215D0 ,  2.404D0 ,  1.958D+1, 
     2        5.804D+1,  2.084D+2,  7.594D+2,  2.635D+2,
     3        8.387D+1,  2.852D+1,  6.239D0 ,  2.765D0 ,
     4        8.897D-1,  3.198D-1,  1.506D-1,  1.446D-1  /

!-----------------------------------------------------------------      

      call SETGRD
     O   ( ZGRID, FDZ, FDZM, DX,
     O     RGRID, RDZ, RDZM,
     D     NZ, NZB, NZR, NZRB             )

      call RBASIC
     I   ( PRES0, PSFC , SNU  , RNU  , 
     O     OPL  , TAUN ,
     C     GRAV , DELNU ,
     D     NZ   , NZB  , NZR  , NZRB  , NBND  )

!-----------------------------------------------------------------      

      write(6,*) 'data number = ', nloop1

      itb = 1
      ite = 24
      interv = 1

      CALL sgpwsn
      read(*,*) iws
      CALL gropn(iws)
      CALL sglset( 'LCORNER', .FALSE. )

      CALL grfrm
      CALL grswnd( 0., 24., -25.0, 35.0 )   
      CALL grsvpt( 0.2, 0.8, 0.2, 0.8)                     
      CALL grstrn( 1 )
      CALL grstrf
      call uxaxdv ( 'B', 1., 6. )
      call uxaxdv ( 'T', 1., 6. )
      call uyaxdv ( 'L', 2., 10. )
      call uyaxdv ( 'R', 2., 10. )
      call uxsttl( 'B', 'LT [hour]', 0. )
      call uysttl( 'L', 'Heat flux [W/m^2]', 0. )
      CALL uxsttl( 'T', header, 1. )      

      do it = 1, ite

         read(34) TIME, ((TPOT(IX,IZ),IX=-2,nxb), IZ=-2,NZB )
         write(0,*) 'reading time = ', time
              
         do IX = -2, NXB
            TSFC (IX) = 180.0D0 + MAX( 0.0D0, 
     \           100.0D0 * sin( 2.0D0 * 3.14D0 * TIME / 86400.0D0 ) )
         end do

!-----------------------------------------------------------------      
! پη׻

         do iz = 0, NZ
            do ix = -2, NXB
               TEMP( ix, iz ) = ( TPOT( ix, iz ) + TPOT0( iz ) )  
     \              * ( PRES0( iz ) / PSFC ) ** ( RDRY / CPDRY )
            end do
         end do

         do ix = -2, NXB
            TEMP( ix, -1 )    = TEMP( ix, 0 )
            TEMP( ix, -2 )    = TEMP( ix, 0 )
            TEMP( ix, NZR+1 ) = TEMP( ix, NZ )
            TEMP( ix, NZR+2 ) = TEMP( ix, NZ )
         end do

!-----------------------------------------------------------------      
! ХɤȤδͿ׻

         do inb = 1, NBND

            call CLBBRAD 
     I         ( TEMP , WNU(inb),
     O           BBRAD, BBRAD_S,
     C           TSFC , 
     D           NX   , NXB,  
     D           NZR  , NZRB  )

            call CLFXRDU
     I         ( BBRAD , BBRAD_S, TAUN, inb, 
     O           FXRADU,
     D           NZR   , NZRB   , NX  , NXB , NBND )


            call CLFXRDD
     I         ( BBRAD , TAUN , inb ,  
     O           FXRADD,
     D           NZR   , NZRB , NX  , NXB , NBND )

            do iz = 0, NZRB
            do ix = -2,NXB
               FXRADU_NU(ix,iz,inb) = FXRADU(ix,iz)
               FXRADD_NU(ix,iz,inb) = FXRADD(ix,iz)
            end do
            end do

            do iz = -2, NZRB
            do ix = -2, NXB
               FXRADU(ix,iz) = 0.0D0
               FXRADD(ix,iz) = 0.0D0
            end do
            end do

         end do

!-----------------------------------------------------------------      
! Ĺʬ

         do iz = -2, NZRB
         do ix = -2, NXB
         do inb = 1, NBND/2
            FXRADU(ix,iz) = FXRADU(ix,iz) + DELNU * 
     \           ( FXRADU_NU(ix,iz,inb) + FXRADU_NU(ix,iz,NBND+1-inb) )
            FXRADD(ix,iz) = FXRADD(ix,iz) + DELNU * 
     \           ( FXRADD_NU(ix,iz,inb) + FXRADD_NU(ix,iz,NBND+1-inb) )
         end do
         end do
         end do


! ɽ̤δͿ

         do iz = -2, NZRB
         do ix = -2, NXB
            FXRADU(ix,iz) = sigma * TSFC(ix)**4 + FXRADU(ix,iz)
         end do
         end do

!-----------------------------------------------------------------      
! ;η׻; ̣«̩

         call CLFXRDN
     I      ( FXRADU, FXRADD,
     O        FXRADN,
     D        NX    , NXB   , 
     D        NZ    , NZB     )


c*** Ѵ: ä LT ************************************
         time = time - 86400.* ( irun - 2 )
         time_p(it) = time / 3600. + 6

         if ( time_p(it) .gt. 24 ) then
            time_p(it) = time_p(it) - 24
         end if
c**************************************************************

         do iz = -2, NZB
            FXRADN_mean(iz) = 0.0D0
         end do

         do iz = 0, NZB
            do ix = 0, NX-1
               FXRADN_mean(iz) = FXRADN_mean(iz) + FXRADN(ix,iz)/NX
            end do
         end do

         rflux(it) = FXRADN_mean(0) - FXRADN_mean(NZB) 
      end do

      do i = 1, 6
         heat2(i+1) = rflux(i+18)
         LT(i+1)    = time_p(i+18)
      end do

      do i = 1, 18
         heat2(i+7) = rflux(i)
         LT(i+7)    = time_p(i)
      end do
      LT(1) = 0
      heat2(1) = rflux(18)
   
      CALL uulinz( 25, LT, heat2, 3, 2  )
c      CALL uulinz( nloop1, LT, heat2, 1, 2  )

!
! ɽեå
!

      read(12,*) (time_p(j),j=1,nloop1),(heat1(j),j=1,nloop1)

      do i = 1, nloop1
         time_p(i) = ( time_p(i) - (irun -2 )*86400 ) 
     \        / tinterv - 0.5 + 6 
         sflux_h1(i) = heat1(i) / tinterv / 51200.0 
      end do

      do i = 1, 6
         heat1(i) = sflux_h1(i+18)
      end do

      do i = 1, 18
         heat1(i+6) = sflux_h1(i)
      end do
      heat1(1) = sflux_h1(18)

      call uulinz(25, LT, heat1,  1, 2)

      CALL grcls                                                        


      stop
      end

