C*********************************************************************
C
C     PROGRAM hfluxprf
C
C     ʿʿѱľʬۿ޺ץ(Ǯեå)
C
C      1997/07/24 
C          1997/07/25 
C          1997/07/26 
C          1998/01/30 
C          1999/04/15 
C
C*********************************************************************
      program hfluxprf
      implicit real*8 ( a-h, o-z )
*-----------------------------------------------------
#include "grid_size_M.f"
c      parameter ( nx = 512, nz = 100 )
      parameter ( nbr3 = 3*((nx+6)*(nz+6)/16+1) )
*-----------------------------------------------------
      integer ibr(nbr3)
      parameter ( num = 1 )     ! ʿѥǡ
*-----------------------------------------------------
      real*8 time

      real*8 wread(-2:nx+2,-2:nz+2)
      real*8 uread(-2:nx+2,-2:nz+2)
      real*8 vread(-2:nx+2,-2:nz+2)
      real*8 tread(-2:nx+2,-2:nz+2)
      real*8 qread(-2:nx+2,-2:nz+2)
      real*8 kturbread(-2:nx+2,-2:nz+2)

      real*4 w(nx+1,nz+1)
      real*4 u(nx+1,nz+1)
      real*4 v(nx+1,nz+1)
      real*4 t(nx+1,nz+1)
      real*4 q(nx+1,nz+1)
      real*4 kturb(nx+1,nz+1)

      real*4 tt(nx+1,nz+1)
      real*4 tt_grad_z(nx+1,nz+1)

      real*4 ave_w(nz+1)
      real*4 ave_t(nz+1)
      real*4 ave_wt(nz+1)

      real*4 wd(nx+1,nz+1)
      real*4 td(nx+1,nz+1)
      real*4 wt(nx+1,nz+1)

      real*4 wdtd(nx+1,nz+1)
      real*4 ave_wdtd(nz+1)
      real*4 wt_all(nz+1)

      real*4 ave_t_wdtd(nz+1)
      real*4 ave_t_kflux(nz+1)

      real*4 kflux(nx+1,nz+1)
      real*4 ave_kflux(nz+1)

      real*8 CDRAGV( -2:NXB ), RICHD( -2:NXB ), TSFC ( -2:NXB )
      real*4 cdragvp(nx+1), richdp(nx+1), tsfcp(nx+1)

      character*2  end
      character*100 dum1

      real*4 para1, para2, para3, para4
      
*-----------------------------------------------------
      real*8 z0(-2:nzb), p0(-2:nzb), d0(-2:nzb), 
     &       temp0(-2:nzb), tpot0(-2:nzb), ppai0(-2:nzb)
      real*4 zgrid(nz+1)
*-----------------------------------------------------
      do iz = 1, nz+1
         ave_t_wdtd(iz) = 0.0
         ave_t_kflux(iz) = 0.0
      end do

      do ix = -2, nx+2
         TSFC(ix) = 270.0D0
      end do

      call SETCST( grav, psd, amdry, rdry, cpdry, rmvap, alatent )

      open (11,file='exparam')
      read (11,*) irun
      read (11,*) time0, nloop1, nloop2, dtime, ntmoni, ntkubu
      close(11)

      call FOPEN ( irun+1 )

      do iz = 1,9
         read(16,'(a100)') dumy
      end do

      do iz = -2, nzb
         read(16,*) ii, z0(iz), p0(iz), d0(iz),
     &              temp0(iz), tpot0(iz), ppai0(iz), dum1, dum2
      end do

      do iz = 1, nz+1
         zgrid(iz) = z0(iz-1)/1000.
      end do

      write(6,*) 'data number = ', nloop1
      write(0,*) 'ibegin(2-', nloop1, 
     &           ') iend(2-', nloop1,  
     &           ') inter(1-', nloop1, ')'
      read (5,*) itb, ite, interv
      
      call sgpwsn
      read(*,*) iws

      call gropn(iws)
c      call sldiv( 'Y', 2, 1 )
      call sglset( 'LCORNER', .FALSE. )

      call grfrm
      call grswnd( -20., 20., 0., 10. )
c      call grswnd( -5., 5., 0., 10. )
      call grsvpt( 0.2, 0.8, 0.2, 0.8 )
      call grstrn(1)
      call grstrf
      call ussttl ( 'HEAT FLUX ', '[W/m^2]', '', 'Z[km]' )
      call usdaxs

      para1 = 0.35
      para2 = 1
      para3 = 1
      para4 = 1

      do it = 1, ite

      read(31) time, ((uread(ix,iz),ix=-2,nx+2), iz=-2,nz+2)
      read(32) time, ((vread(ix,iz),ix=-2,nx+2), iz=-2,nz+2)
      read(33) time, ((wread(ix,iz),ix=-2,nx+2), iz=-2,nz+2)
      read(34) time, ((tread(ix,iz),ix=-2,nx+2), iz=-2,nz+2)
      read(35) time, ((qread(ix,iz),ix=-2,nx+2), iz=-2,nz+2)
      read(38) time, ((kturbread(ix,iz),ix=-2,nx+2), iz=-2,nz+2)

      write(0,*) 'reading time = ', time

      if ( it .ge. itb   .and.  it .le. ite ) then
         if ( mod( (it-itb), interv ) .eq. 0 ) then

      write(0,*) 'writing time = ', time

      write(end,300) INT(time / 3600.)
 300  format(I2)

      do ix = 1, nx+1
         do iz = 1,nz+1
            w(ix,iz) = wread(ix-1,iz-1)
            u(ix,iz) = uread(ix-1,iz-1)
            v(ix,iz) = vread(ix-1,iz-1)
            t(ix,iz) = tread(ix-1,iz-1)
            q(ix,iz) = qread(ix-1,iz-1)
            kturb(ix,iz) = kturbread(ix,iz)
            tt(ix,iz) = tread(ix-1,iz-1) + tpot0(iz-1)
         end do
      end do

      do ix = 1, nx+1
         do iz = 2,nz
            tt_grad_z(ix,iz) = ( tt(ix,iz) - tt(ix,iz-1) ) /
     &                         ( z0(iz-1)  - z0(iz-2) )
         end do
         tt_grad_z(ix,nz+1) = 0.0
      end do

      do ix = 1, nx+1
         do iz = 2,nz+1
            kflux(ix,iz) = - cpdry * ( d0(iz-1) * kturb(ix,iz-1) + 
     &                                 d0(iz-2) * kturb(ix,iz-2) ) / 2.0 
     &                     * tt_grad_z(ix,iz) 
         end do
      end do
           
      call CLDRAG
     I      ( uread    , vread    , tread, 
     I        1, 
     I        temp0, 
     O        RICHD, CDRAGV, 
     G        Z0, 
     C        grav , tsfc ,
     D        nx, nxb, nx, nxb, nzb, nrot )

      do ix = 1,nx+1
         cdragvp( ix )= cdragv(ix-1)
         richdp( ix ) = MIN(richd(ix-1),0.25)
         tsfcp ( ix ) = tsfc(ix-1)
      end do

      do ix = 1,nx+1
         vsfc = SQRT( u(ix,1)**2 + v(ix,1)**2 )

         kflux(ix,1) = - cdragvp(ix) * VSFC * CPDRY *d0(0)
     \               * ( tt(ix,1)*PPAI0(0) - tsfcp(ix) )

         delt = tt(ix,1)*PPAI0(0) - tsfcp(ix)

         write(*,*) 'hflux=', kflux(ix,1)
      end do
   
      do iz = 1,nz+1
         ave_w(iz) = 0.0
         ave_t(iz) = 0.0
         do ix = 1, nx+1
            ave_w(iz) = ave_w(iz) + w(ix,iz) / (nx+1)
            ave_t(iz) = ave_t(iz) + tt(ix,iz) / (nx+1)
         end do
      end do

      do iz = 1,nz+1
         do ix = 1, nx+1
            wd(ix,iz) = w(ix,iz) - ave_w(iz)
            td(ix,iz) = tt(ix,iz) - ave_t(iz)
         end do
      end do

      do iz = 1,nz+1
         ave_wt(iz) = ave_w(iz)*ave_t(iz)
         do ix = 1, nx+1
            wdtd(ix,iz) = wd(ix,iz)*td(ix,iz)
         end do
      end do

      do iz = 1,nz+1
         ave_wdtd(iz) = 0.0
         ave_kflux(iz) = 0.0
         do ix = 1, nx
            ave_wdtd(iz) = ave_wdtd(iz) + wdtd(ix,iz) / nx
            ave_kflux(iz) = ave_kflux(iz) + kflux(ix,iz) / nx
         end do
         ave_wdtd(iz)     = cpdry * d0(iz) * ave_wdtd(iz)
         ave_t_wdtd(iz) = ave_t_wdtd(iz) + ave_wdtd(iz)/num
         ave_t_kflux(iz) = ave_t_kflux(iz) + ave_kflux(iz)/num

      end do

      do iz = 1,nz+1
         wt_all(iz) = ave_wdtd(iz) + ave_wt(iz)
      end do
*
      if ( MOD(it,num) .eq. 1. .or. num .eq. 1. ) then

      call sglset( 'LCHAR', .TRUE. )
      call sgsplc( end ) 
      call sglset ( 'LROT', .TRUE. )
      call sgiset ( 'IROT', 90 )
      call sgrset ( 'FFCT', 0.5 )
      
      call uulinz(nz+1, ave_t_wdtd, zgrid, 1, 1)
      call uulinz(nz+1, ave_t_kflux, zgrid, 2, 1)

      call sglset( 'LCHAR', .FALSE. )
      call sglset ( 'LROT', .FALSE. )
c      para1 = para1 + 0.1
c      para2 = para2 + 1
c      para3 = para2 - INT((para2-1)/4.)*4
c      para4 = para4 + INT((para2-1)/4.)

      do iz = 1, nz+1
         ave_t_wdtd(iz) = 0.0
         ave_t_kflux(iz) = 0.0
      end do
      
      end if

      end if
      end if

      end do

      call grcls
      call FCLOSE ( irun+1 )

      end



