C********************************************************************
C
C     PROGRAM PTTEND
C     
C     ʿʿǮٱľʬۿ޺ץ
C
C     1998/09/22  
C     1998/10/02  
C     1999/02/04  
C     1999/06/15  
C
C*********************************************************************
      program pttend
      implicit real*8 ( a-h, o-z )
C---------------------------------------------------------------------  
#include "grid_size_M.f"
      parameter ( nzprof = 100 )
      parameter ( nzp = nz+1, ntp = 120 )
C---------------------------------------------------------------------  
C                                                                       
      character*5  nmrun
      character*4  from
      character*1  chara
      character*1  pz
c      character*7  t_end
c      character*7  t_begin
      character*2  start
      character*2  finish
      
      character*3  qrad
      character*20  header

      character*2 day

      real*4  dtpad0,dqvad0
      real*4  zgrid(nzp),tptend(nzp),tpmean(nzp),
     &        dtpadv(nzp),dtpdif(nzp),dtpdnl(nzp),
     &        dtpdi0(nzp),dtprad(nzp),tperror(nzp)

      real*4 time(100)
      real*4 heat(100)
      real*4 sflux_h

      real*4 timeh(264)
      real*4 heath(264)

      integer begin,end,interv
      integer nloop1
*-----------------------------------------------------

      real*4 z0(-2:nzb), p0(-2:nzb), d0(-2:nzb), 
     \       temp0(-2:nzb), tpot0(-2:nzb), ppai0(-2:nzb)

*-----------------------------------------------------

      call SETCST( grav, psd, amdry, rdry, cpdry, rmvap, alatent )

      open (11,file='exparam')
      read (11,*) irun
      read (11,*) time0, nloop1, nloop2, dtime, ntmoni, ntkubu
      close (11)
      
      tinterv = nloop2 * ( dtime / 2. )

      call FOPEN ( irun+1 )

      write(day, '(I2.2)') irun

      do iz = 1,9
         read(16,'(a100)') dumy
      end do

      do iz = -2, nzb
         read(16,*) ii, z0(iz), p0(iz), d0(iz), temp0(iz),
     \                     tpot0(iz), ppai0(iz), dum1, dum2
      end do

c      read(12,'(a2,a17,a8,a13,a8,a4)') 
      read(12,'(a2,a15,g15.7,a6,g15.7,a4)') 
     &     chara, nmrun, t_begin, from, t_end,
     &     pz

!********************************************************************
      end = INT( t_end -  ( irun - 1 )*86400 )
      begin = INT( t_begin -  ( irun - 1 )*86400 )

      t_end   = (t_end -  ( irun - 1 )*86400.)/3600. + 6
      t_begin = (t_begin -  ( irun - 1 )*86400.)/3600. + 6

      if ( INT(t_begin) .ge. 24 ) then
         t_begin = t_begin - 24
      end if

      if ( INT(t_end) .ge. 24 ) then
         t_end = t_end - 24
      end if

      write(start,100) INT(t_begin)
      write(finish,100) INT(t_end)
 100  format(I2.2) 

!********************************************************************

c      header = 't=' // t_begin // '-' // t_end // 'sec'
      header = 'day' // day // 
     \     ' LT=' // start // ':00-' // finish // ':00'


      do iz = 1, nzp
         read(12,*) zgrid(iz), 
     &                        tptend(iz),
     &                        tpmean(iz),
     &                        dtpadv(iz),
     &                        dtpdif(iz),
     &                        dtpdnl(iz),
     &                        dtpad0,
     &                        dtpdi0(iz),
     &                        dtprad(iz),
     &                        tperror(iz)
      end do

      close(12)

      read(13,*) (time(j),j=1,nloop1),(heat(j),j=1,nloop1)

!      write(*,*) 't_begin,t_end'
!      read(*,*) begin,end

      begin = begin / tinterv
      end = end / tinterv

      do i = 1, nloop1
         heat(i) = heat(i)/tinterv
      end do

      interv = end - begin + 1

      sflux_h = 0.
      do i = begin, end
         sflux_h = sflux_h + heat(i) / interv  
      end do

      sflux_h = sflux_h / ( cpdry * d0(0) * z0(0)*2 * 51200.)
      dtpdif(1) = dtpdif(1) + sflux_h

      do iz = 1, nzp
         zgrid(iz) = zgrid(iz) / 1000.
         dtpdif(iz) = ( dtpdif(iz) + dtpdi0(iz) )* 86400.
         tptend(iz) = tptend(iz) * 86400.
         dtpadv(iz) = ( dtpadv(iz) + dtpdnl(iz) )* 86400.
         dtprad(iz) = dtprad(iz) * 86400.
      end do

      call sgpwsn
      read(*,*) iws

      call gropn(iws)
c      call sldiv( 'Y', 2, 1 )
      call sglset( 'LCORNER', .FALSE. )
      
      call grfrm
      call grswnd( -10., 10., 0., 20. )
c      call grswnd( -200., 200., 0., 10. )
c      call grswnd( -200., 200., 0., 20. )
      call grsvpt( 0.2, 0.8, 0.35, 0.85 )
      call grstrn(1)
      call grstrf
      call ussttl ( '', '', '', 'Z[km]' )
      call usdaxs
      call uxsttl ( 'T', header, 1. )
      call sglset( 'LCHAR', .TRUE. )

c      call sgsplc( 'tend' ) 
c      call uulinz(nzp, tptend, zgrid, 1, 2)
c      call uulinz(nzp, tptend, zgrid, 1, 1)
c      call sgrset( 'FFCT', 0.8 ) 
      call sgsplc( 'adv' ) 
      call uulinz(nzp, dtpadv, zgrid, 1, 0.45)
c      call uulinz(nzp, dtpadv, zgrid, 2, 1)

      call sgsplc( 'dif' ) 
      call sgrset( 'FFCT', 0.65 ) 
      call uulinz(nzp, dtpdif, zgrid, 1, 0.95)
c      call uulinz(nzp, dtpdif, zgrid, 3, 1)

      call sgsplc( 'rad' ) 
c      call sgrset( 'FFCT', 0.9 ) 
      call uulinz(nzp, dtprad, zgrid, 1, 0.4)
c      call uulinz(nzp, dtprad, zgrid, 4, 1)

      call sglset( 'LCHAR', .FALSE. )
      call sgrset( 'FFCT', 0.8 ) 
      call sgsplc( 'tend' ) 
      call uulinz(nzp, tptend, zgrid, 1, 2)
c      call uulinz(nzp, tptend, zgrid, 1, 1)

      call grfig
      call grswnd( -1200., 1200., 0., 1. )
      call grsvpt( 0.2, 0.8, 0.2, 0.3 )
      call grstrn(1)
      call grstrf
      call uxaxdv ( 'B', 100., 500. )
      call uxaxdv ( 'T', 100., 500. )
      call uyaxdv ( 'L', 0.2, 1. )
      call uyaxdv ( 'R', 0.2, 1. )
      call uzfact(0.8)
      call uxsttl( 'B', '([K/day])', 1.2 )
      call uzfact(1.25)
      call uxsttl( 'B', 'THETA TENDENCY', 0. )
      call sglset( 'LCHAR', .TRUE. )
      call sgsplc( 'adv' ) 
c      call uulinz(10, dtpadv, zgrid, 2, 1)
      call uulinz(10, dtpadv, zgrid, 1, 0.45)
      call sgsplc( 'dif' ) 
c      call uulinz(10, dtpdif, zgrid, 3, 1)
      call uulinz(10, dtpdif, zgrid, 1, 0.95)
      call sgsplc( 'rad' ) 
c      call uulinz(10, dtprad, zgrid, 4, 1)
      call uulinz(10, dtprad, zgrid, 1, 0.4)
      call sgsplc( 'tend' ) 
c      call uulinz(10, tptend, zgrid, 1, 1)
      call uulinz(10, tptend, zgrid, 1, 2)
      call sglset( 'LCHAR', .FALSE. )

      call grcls

      call FCLOSE ( irun+1 )

      end



