C*********************************************************************
C
C     PROGRAM TPPROF
C
C     ̱ľʬۺץ(¬)
C
C     2000/04/24  
C
C*********************************************************************
      program tpprof
C---------------------------------------------------------------------  
      IMPLICIT REAL*8 ( A-H, O-Z )                                      
C---------------------------------------------------------------------  
#include "grid_size_M.f"
      parameter ( nzprof = 100 )                              
      parameter ( nzp = nz+1, ntp = 120 )
C---------------------------------------------------------------------  
C                                                                       
      real*8
     \   zgrid ( -2:nzb ),
     \   temp0 ( -2:nzb ),
     \   tpot0 ( -2:nzb ),
     \   dens0 ( -2:nzb ),
     \   ppai0 ( -2:nzb ),
     \   pres0 ( -2:nzb ),
     \   rvap0 ( -2:nzb ),
     \   qvap0 ( -2:nzb )

      real*8
     \     tpot ( -2:nxb, -2:nzb )

      real*4
     \    z0p ( 0:nz ), 
     \    p0p ( 0:nz ),
     \    d0p ( 0:nz ),
     \ temp0p ( 0:nz ),
     \ tpot0p ( 0:nz ),
     \  pai0p ( 0:nz ),
     \ rvap0p ( 0:nz ),
     \ qvap0p ( 0:nz )

      real*4 
     \      tpotp ( nx+1, nz+1 ),
     \      tpall ( nx+1, nz+1 ),
     \      tpave ( nz+1 ),
     \      tpdev ( nx+1, nz+1 )

      real*4
     \      tprof_1(nz+1),
     \      tprof_2(nz+1),
     \      tsprof(nz+1)

      character*100 dumy
      character*2 hour
      character*2 day
      character*14 header

      integer p1, p2
C
C=====================================================================  

      open (11,file='exparam')
      read (11,*) irun
      read (11,*) time0, nloop1, nloop2, dtime, ntmoni, ntkubu
      close(11)

      write(day,'(I2.2)') irun-1

      call FOPEN ( irun+1 )

      do iz = 1,9
         read(16,'(a100)') dumy
      end do

      do iz = -2, nzb
         read(16,*) ii, zgrid(iz), pres0(iz), dens0(iz), temp0(iz),
     \                     tpot0(iz), ppai0(iz), qvap0(iz), rvap0(iz)
      end do

      do iz = 0, nz
         z0p(iz)   = zgrid(iz)
         p0p(iz)   = pres0(iz)
         d0p(iz)   = dens0(iz)
         temp0p(iz)= temp0(iz)
         tpot0p(iz)= tpot0(iz)
         pai0p(iz) = ppai0(iz)
         rvap0p(iz)= rvap0(iz)
         qvap0p(iz)= qvap0(iz)
      end do

      do iz = 0, nz
         z0p(iz) = z0p(iz) / 1000.
      end do

      write(6,*) 'data number = ', nloop1
      write(6,*) 'INPUT DATA BEGINING, END, & INTERVAL' 
      write(6,*) 'itb ite interval ?'
      read (*,*) itb, ite, interv

      write(6,*) 'INPUT DATA 1 X POSITION(1-',NX,')'
      read (*,*) p1

      write(6,*) 'INPUT DATA 2 X POSITION(1-',NX,')'
      read (*,*) p2

      call sgpwsn
      read(*,*) iws

      call gropn(iws)
      call sglset( 'LCORNER', .FALSE. )


      do it = 1, ite

      read(34) time, ((tpot(ix,iz),ix=-2,nxb), iz=-2,nzb)

      write(0,*) 'reading time = ', time

      if ( it .ge. itb   .and.  it .le. ite ) then
         if ( mod( (it-itb), interv ) .eq. 0 ) then

            write(0,*) 'writing time = ', time

            PI = 3.141592D0
            TSFC = 180.0D0 + 1.0D+2 * 
     \           MAX( sin( 2.0d0 * PI * TIME / 8.64D+4 ), 0.0D0 )


c*** Ѵ: ä LT ************************************
            time = time - 86400.* ( irun - 2 )
            time = time / 3600. + 6

            if ( INT(time) .ge. 24 ) then
               time = time - 24
            end if

            write(hour, '(I2.2)') INT(time)
            header = 'day' // day // ' LT=' // hour // ':00'
c**************************************************************

            do iz = 1,nz+1
               do ix = 1, nx+1
                  tpotp(ix,iz) = tpot(ix-1,iz-1)
                  tpall(ix,iz) = tpot(ix-1,iz-1) + tpot0(iz-1)
               end do
            end do
*
            do iz = 1,nz+1
               tprof_1(iz) = tpall(p1,iz)
               tprof_2(iz) = tpall(p2,iz)
               tsprof(iz) = TSFC
            end do

            call grfrm
            call grswnd( 180., 270., 0., 20. )
            call grsvpt( 0.2, 0.8, 0.2, 0.8 )
            call grstrn(1)
            call grstrf
            call ussttl ( 'THETA', '[K]', '', 'Z[km]' )
            call usdaxs
         
            call uulinz(nzp, tprof_1, z0p, 1, 2)
            call uulinz(nzp, tprof_2, z0p, 3, 2)
            call uulinz(nzp, tsprof, z0p, 4, 2)
            call uxsttl ( 'T', header, 1. )


         end if
      end if

      end do

      call grcls

      end
