C*********************************************************************
C
C     PROGRAM TQTEND
C
C     ʿʿǮٱľʬۿ޺ץ
C
C     1998/09/22  
C     1998/10/02  
C     1999/01/17  
C     1999/02/04  
C     1999/06/15  
C
C*********************************************************************
      program tqtend
      implicit real*8 ( a-h, o-z )                                      
C---------------------------------------------------------------------  
C
#include "grid_size_M.f"
      parameter ( nzprof = 100 )                              
      parameter ( nzp = nz+1, ntp = 120 )
C
C---------------------------------------------------------------------  
C                                                                       
      character*5  nmrun
      character*4  from
      character*1  chara
      character*1  pz
      character*6  t_end
      character*6  t_begin

      character*18  header

      real*4  dtpad0,dqvad0
      real*4  zgrid(nzp)
      real*4  tptend(nzp),tpmean(nzp),dtpadv(nzp),
     &        dtpdif(nzp),dtpdnl(nzp),
     &        dtpdi0(nzp),dtprad(nzp),tperror(nzp)
      real*4  qvtend(nzp),qvmean(nzp),dqvadv(nzp),
     &        dqvdif(nzp),dqvdnl(nzp),
     &        dqvdi0(nzp),dqvnfl(nzp),qverror(nzp)

      integer fnum
C
C=====================================================================  

      read(10,'(a2,a15,a8,a13,a8,a4)') 
     &     chara, nmrun, t_begin, from, t_end,
     &     pz

      header = 't=' // t_begin // '-' // t_end // 'sec'

      do iz = 1, nzp
         read(10,'(10g15.7)') zgrid(iz), 
     &                        tptend(iz),
     &                        tpmean(iz),
     &                        dtpadv(iz),
     &                        dtpdif(iz),
     &                        dtpdnl(iz),
     &                        dtpad0,
     &                        dtpdi0(iz),
     &                        dtprad(iz),
     &                        tperror(iz)
      end do

      read(10,'(a2,a15,a8,a13,a8,a4,9a15)') 
     &     chara, nmrun, t_begin, from, t_end,
     &     pz

      do iz = 1, nzp
         read(10,'(10g15.7)') zgrid(iz),
     &                        qvtend(iz),
     &                        qvmean(iz),
     &                        dqvadv(iz),
     &                        dqvdif(iz),
     &                        dqvdnl(iz),
     &                        dqvad0,
     &                        dqvdi0(iz),
     &                        dqvnfl(iz),
     &                        qverror(iz)
      end do

      close(10)

      do iz = 1, nzp
         zgrid(iz) = zgrid(iz) / 1000.
         dtpdif(iz) = ( dtpdif(iz) + dtpdi0(iz) )* 86400.
         tptend(iz) = tptend(iz) * 86400.
         dtpadv(iz) = ( dtpadv(iz) + dtpdnl(iz) )* 86400.
         dtprad(iz) = dtprad(iz) * 86400.

         qvtend(iz)=REAL( qvtend(iz) )
         qvmean(iz)=REAL( qvmean(iz) )
         dqvadv(iz)=REAL( dqvadv(iz) )
         dqvdif(iz)=REAL( dqvdif(iz) + dqvdi0(iz) )
         dqvnfl(iz)=REAL( dqvnfl(iz) )

      end do

      call sgpwsn
      read(*,*) iws

      call gropn(iws)
      call sldiv( 'Y', 2, 1 )
      call sglset( 'LCORNER', .FALSE. )
      
      call grfrm
      call grswnd( -100., 100., 0., 10. )
      call grsvpt( 0.2, 0.8, 0.2, 0.8 )
      call grstrn(1)
      call grstrf
      call ussttl ( 'THETA TENDENCY', '[K/day]', '', 'Z[km]' )
      call usdaxs
      call sglset( 'LCHAR', .TRUE. )
      call sgsplc( 'tend' ) 
      call uulinz(nzp, tptend, zgrid, 1, 1)
      call sgsplc( 'adv' ) 
      call uulinz(nzp, dtpadv, zgrid, 2, 1)
      call sgsplc( 'dif' ) 
      call uulinz(nzp, dtpdif, zgrid, 3, 1)
      call sgsplc( 'rad' ) 
      call uulinz(nzp, dtprad, zgrid, 4, 1)
      call uxsttl ( 'T', header, 1. )
      call sglset( 'LCHAR', .FALSE. )

      call grfrm
c      call grswnd( -1.e-19, 1.e-19, 0., 10. )
c      call grsvpt( 0.2, 0.8, 0.2, 0.8 )
c      call grstrn(1)
      call usspnt(nzp, qvtend, zgrid)
      call uspfit
      call grstrf
      call ussttl ( 'Q TENDENCY', '[kg/kg/sec]', '', 'Z[km]' )
      call usdaxs
      call sglset( 'LCHAR', .TRUE. )
      call sgsplc( 'tend' ) 
      call uulinz(nzp, qvtend, zgrid, 1, 1)
      call sgsplc( 'adv' ) 
      call uulinz(nzp, dqvadv, zgrid, 2, 1)
      call sgsplc( 'dif' ) 
      call uulinz(nzp, dqvdif, zgrid, 3, 1)
      call sgsplc( 'nfl' ) 
      call uulinz(nzp, dqvnfl, zgrid, 4, 1)
      call uxsttl ( 'T', header, 1. )
      call sglset( 'LCHAR', .FALSE. )

      call grcls


      end
