C*********************************************************************  
C                                                                       
C     PROGRAM PLBGT
C
C     ʿʿѥǡץ
C
C      1997/07/24 
C          1997/07/25 
C          1998/09/21 
C          1998/10/02 
C          1999/06/15 
C
C*********************************************************************  
      program plbgt
*---------------------------------------------------------------------
      implicit real*8 ( a-h, o-z )                                      
*---------------------------------------------------------------------
#include "grid_size_M.f" 
      parameter ( nzprof = 100 )                              
      parameter ( nzp = nz+1, ntp = 120 )
*---------------------------------------------------------------------  
                                                                       
      character*10 nmrun
      character*24 title
      character*10 glab                                                 
      character*80 fname
      character*50 outfilename
      character*100 dumy

      dimension ZPROF     ( -2:nzb, nzprof )                             
      real*8    ZPROF_ave ( -2:nzb, nzprof )                             
C
      real*8  tp_begin (-2:nzb)
      real*8  tp_end   (-2:nzb)
      real*8  qv_begin (-2:nzb)
      real*8  qv_end   (-2:nzb)

      real*8  zgrid(-2:nzb), pres0(-2:nzb), dens0(-2:nzb),
     &          temp0(-2:nzb), tpot0(-2:nzb), ppai0(-2:nzb),
     &          rvap0 ( -2:nzb ), qvap0 ( -2:nzb )
C
C=====================================================================  
C

      read (5,*) nmrun, ibegin, iend, tinter

      do iz = -2, nzb
         do ii = 1, nzprof
            zprof_ave(iz,ii) = 0.0
         end do
      end do

      open (10,file='exparam')
      read (10,*) irun
      read (10,*) time0, nloop1, nloop2, dtime, ntmoni, ntkubu

      call FOPEN ( irun+1 )

      open (11,file='exout')

      do iz = 1,24
         read(11,'(a100)') dumy
      end do

      do iz0 = -2, nzb
         read(11,*) idum, zgrid(iz0), pres0(iz0), dens0(iz0), 
     &              temp0(iz0), tpot0(iz0), ppai0(iz0), dum1, dum2
      end do
                                                                       
c      write(6,*) 'data number = ', nloop1
c      write(6,*) 'name_run(char*5) ibegin(>2) iend(<data number) tinter'
c      read (5,*) nmrun, ibegin, iend, tinter
c      write(6,*) 'output file name ?'
c      read (5,*) outfilename

c      open(99,file=outfilename)

      ndata = iend - ibegin + 1

      t_int = ndata * tinter

      DO  it = 1, iend

         read(61) time, ((zprof(i,j),i=-2,nzb),j=1,nzprof)

         if ( it .eq. ibegin-1 ) then
            do iz = 0, nz
               t_begin = time
               tp_begin(iz) = zprof(iz,41)
               qv_begin(iz) = zprof(iz,51)
            end do
         end if
            
         if ( it .eq. iend ) then
            do iz = 0, nz
               t_end = time 
               tp_end(iz) = zprof(iz,41)
               qv_end(iz) = zprof(iz,51)
            end do
         end if
            
         if ( it .ge. ibegin ) then
            do iz = 0, nz
               do ii = 1, nzprof

                  if ( ii .eq. 41  .or. ii .eq. 51 ) then
                     zprof_ave(iz,ii) = zprof_ave(iz,ii) 
     &                    + zprof(iz,ii) / ndata
                  else
                     zprof_ave(iz,ii) = zprof_ave(iz,ii) 
     &                    + zprof(iz,ii) / t_int
                  end if

               end do
            end do
            
         end if

      end do

      do iz = 0, nz
         zprof_ave(iz,40) = ( tp_end(iz) - tp_begin(iz) ) / t_int
         zprof_ave(iz,50) = ( qv_end(iz) - qv_begin(iz) ) / t_int
         zprof_ave(iz,41) = zprof_ave(iz,41) + tpot0(iz)

         zprof_ave(iz,48) =  zprof_ave(iz,40) 
     &                     - zprof_ave(iz,42) 
     &                     - zprof_ave(iz,43) 
     &                     - zprof_ave(iz,44) 
     &                     - zprof_ave(iz,45) 
     &                     - zprof_ave(iz,46) 
     &                     - zprof_ave(iz,47) 
  
         zprof_ave(iz,58) =  zprof_ave(iz,50) 
     &                     - zprof_ave(iz,52) 
     &                     - zprof_ave(iz,53) 
     &                     - zprof_ave(iz,54) 
     &                     - zprof_ave(iz,55) 
     &                     - zprof_ave(iz,56) 
     &                     - zprof_ave(iz,57) 

      end do

      write(*,'(a2,a15,g15.7,a6,g15.7,a4)') 
c      write(99,'(a2,a15,g15.7,a6,g15.7,a4)') 
     &         '#', nmrun, t_begin, 'from', t_end,
     &         ' z '

      do iz = 0, nz
         write(*,'(10g15.7)') zgrid(iz), (zprof_ave(iz,ii),ii=40,48 )
c         write(99,'(10g15.7)') zgrid(iz), (zprof_ave(iz,ii),ii=40,48 )
      end do

      write(*,'(a2,a15,g15.7,a6,g15.7,a4)') 
c      write(99,'(a2,a15,g15.7,a6,g15.7,a4)') 
     &         '#', nmrun, t_begin, 'from', t_end,
     &         ' z '

      do iz = 0, nz
         write(*,'(10g15.7)') zgrid(iz), (zprof_ave(iz,ii),ii=50,58 )
c         write(99,'(10g15.7)') zgrid(iz), (zprof_ave(iz,ii),ii=50,58 )
      end do

      call FCLOSE
c      close(99)
c
      STOP                                                              
      END                                                               
