C*********************************************************************  
C                                                                       
C     PROGRAM PLBGT_KE
C
C     ʿʿѥǡץ: ɸкȱưͥ륮
C
C      97/07/24 
C          98/09/21 
C          98/10/02 
C
C*********************************************************************  
      program plbgt_ke
C---------------------------------------------------------------------  
      implicit real*8 ( a-h, o-z )                                      
C---------------------------------------------------------------------  
#include "grid_size_M.f" 
C---------------------------------------------------------------------  
C                                                                       
      character*10  nmrun

      real*8  u(-2:nxb,-2:nzb)
      real*8  w(-2:nxb,-2:nzb)
      real*8  tp(-2:nxb,-2:nzb)

      real*8  zgrid(-2:nzb), pres0(-2:nzb), dens0(-2:nzb),
     &          temp0(-2:nzb), tpot0(-2:nzb), ppai0(-2:nzb)

      real*8 e_kin(-2:nzb)
      real*8 ave_tp(-2:nzb), ave_tp2(-2:nzb), sd_tp(-2:nzb)
C
C=====================================================================  
C
      do iz = -2, nzb
         e_kin(iz) = 0.0d0
      end do

      open (11,file='exparam')
      read (11,*) irun
      read (11,*) time0, nloop1, nloop2, dtime, ntmoni, ntkubu

      call FOPEN ( irun+1 )

      do iz0 = -2, nzb
         read(31,*) idum, zgrid(iz0), pres0(iz0), dens0(iz0), 
     &              temp0(iz0), tpot0(iz0), ppai0(iz0), dum1, dum2
      end do

      write(6,*) 'data number = ', nloop1
      write(6,*) 'name_run(char*5) ibegin(>2) iend(<data number)'
      read (5,*) nmrun, ibegin, iend

      ndata = iend - ibegin + 1

      DO  it = 1, iend

         read(31) TIME, ((U   (IX,IZ), IX=-2,NXB),IZ=-2,NZB)
         read(33) TIME, ((w   (IX,IZ), IX=-2,NXB),IZ=-2,NZB)
         read(34) TIME, ((tp  (IX,IZ), IX=-2,NXB),IZ=-2,NZB)

         if ( it .ge. ibegin ) then

            do iz = 0, nz

               ave_tp(iz) = 0.0d0
               ave_tp2(iz) = 0.0d0

               do ix = 1, nx
                  ave_tp(iz) = ave_tp(iz) + tp(ix,iz)    / nx
                  ave_tp2(iz) = ave_tp2(iz) + tp(ix,iz)**2 / nx
               end do

               sd_tp(iz) = sd_tp(iz) + 
     &              sqrt( ave_tp2(iz) - ave_tp(iz)**2 ) / ndata

               e_kinetic = 0.0d0

               do ix = 1, nx
                  e_kinetic = e_kinetic
     &               + 0.5d0 * dens0(iz) / nx
     &                       * (   u(ix,iz)**2
     &                           + w(ix,iz)**2 + w(ix,iz+1)**2 )
               end do

               e_kin(iz) = e_kin(iz) + e_kinetic / ndata

            end do
            
         end if

      end do

      write(6,'(4a15)') 'zgrid', 'sd_tp', 'rms_v', 'e_kin' 

      do iz = 0, nz
         write(6,'(4g15.7)') zgrid(iz), sd_tp(iz), 
     &                       sqrt(2.0*e_kin(iz)/dens0(iz)), e_kin(iz)
      end do

      call FCLOSE

      STOP                                                              
      END                                                               

