--- src/cgges.f	Thu Dec  5 20:18:06 2002
+++ debian/updates/src/cgges.f	Wed Dec  4 15:23:42 2002
@@ -6,6 +6,7 @@
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
 *     June 30, 1999
+*     8-15-00:  Improve consistency of WS calculations (eca)
 *
 *     .. Scalar Arguments ..
       CHARACTER          JOBVSL, JOBVSR, SORT
@@ -145,10 +146,9 @@
 *          The dimension of the array WORK.  LWORK >= max(1,2*N).
 *          For good performance, LWORK must generally be larger.
 *
-*          If LWORK = -1, then a workspace query is assumed; the routine
-*          only calculates the optimal size of the WORK array, returns
-*          this value as the first entry of the WORK array, and no error
-*          message related to LWORK is issued by XERBLA.
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
 *
 *  RWORK   (workspace) REAL array, dimension (8*N)
 *
@@ -173,6 +173,8 @@
 *  =====================================================================
 *
 *     .. Parameters ..
+      INTEGER            LQUERV
+      PARAMETER          ( LQUERV = -1 )
       REAL               ZERO, ONE
       PARAMETER          ( ZERO = 0.0E0, ONE = 1.0E0 )
       COMPLEX            CZERO, CONE
@@ -181,7 +183,7 @@
 *     ..
 *     .. Local Scalars ..
       LOGICAL            CURSL, ILASCL, ILBSCL, ILVSL, ILVSR, LASTSL,
-     $                   LQUERY, WANTST
+     $                   WANTST
       INTEGER            I, ICOLS, IERR, IHI, IJOBVL, IJOBVR, ILEFT,
      $                   ILO, IRIGHT, IROWS, IRWRK, ITAU, IWRK, LWKMIN,
      $                   LWKOPT
@@ -237,7 +239,6 @@
 *     Test the input arguments
 *
       INFO = 0
-      LQUERY = ( LWORK.EQ.-1 )
       IF( IJOBVL.LE.0 ) THEN
          INFO = -1
       ELSE IF( IJOBVR.LE.0 ) THEN
@@ -264,7 +265,7 @@
 *       following subroutine, as returned by ILAENV.)
 *
       LWKMIN = 1
-      IF( INFO.EQ.0 .AND. ( LWORK.GE.1 .OR. LQUERY ) ) THEN
+      IF( INFO.EQ.0 ) THEN
          LWKMIN = MAX( 1, 2*N )
          LWKOPT = N + N*ILAENV( 1, 'CGEQRF', ' ', N, 1, N, 0 )
          IF( ILVSL ) THEN
@@ -272,21 +273,17 @@
      $               -1 ) )
          END IF
          WORK( 1 ) = LWKOPT
+         IF( LWORK.LT.LWKMIN .AND. LWORK.NE.LQUERV )
+     $      INFO = -18
       END IF
 *
-      IF( LWORK.LT.LWKMIN .AND. .NOT.LQUERY )
-     $   INFO = -18
+*     Quick return if possible
 *
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'CGGES ', -INFO )
          RETURN
-      ELSE IF( LQUERY ) THEN
-         RETURN
       END IF
-*
-*     Quick return if possible
-*
-      WORK( 1 ) = LWKOPT
+      IF( LWORK.EQ.LQUERV ) RETURN
       IF( N.EQ.0 ) THEN
          SDIM = 0
          RETURN
