--- timing/eig/eigsrc/zgghrd.f	Thu Dec  5 19:45:17 2002
+++ debian/updates/timing/eig/eigsrc/zgghrd.f	Wed Dec  4 15:23:42 2002
@@ -4,7 +4,7 @@
 *  -- LAPACK routine (instrumented to count operations, version 3.0) --
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
-*     September 30, 1994
+*     April 26, 2001
 *
 *     .. Scalar Arguments ..
       CHARACTER          COMPQ, COMPZ
@@ -33,16 +33,29 @@
 *
 *  ZGGHRD reduces a pair of complex matrices (A,B) to generalized upper
 *  Hessenberg form using unitary transformations, where A is a
-*  general matrix and B is upper triangular:  Q' * A * Z = H and
-*  Q' * B * Z = T, where H is upper Hessenberg, T is upper triangular,
-*  and Q and Z are unitary, and ' means conjugate transpose.
+*  general matrix and B is upper triangular.  The form of the
+*  generalized eigenvalue problem is
+*     A*x = lambda*B*x,
+*  and B is typically made upper triangular by computing its QR
+*  factorization and moving the unitary matrix Q to the left side
+*  of the equation.
+*
+*  This subroutine simultaneously reduces A to a Hessenberg matrix H:
+*     Q**H*A*Z = H
+*  and transforms B to another upper triangular matrix T:
+*     Q**H*B*Z = T
+*  in order to reduce the problem to its standard form
+*     H*y = lambda*T*y
+*  where y = Z**H*x.
 *
 *  The unitary matrices Q and Z are determined as products of Givens
 *  rotations.  They may either be formed explicitly, or they may be
 *  postmultiplied into input matrices Q1 and Z1, so that
-*
-*       Q1 * A * Z1' = (Q1*Q) * H * (Z1*Z)'
-*       Q1 * B * Z1' = (Q1*Q) * T * (Z1*Z)'
+*       Q1 * A * Z1**H = (Q1*Q) * H * (Z1*Z)**H
+*       Q1 * B * Z1**H = (Q1*Q) * T * (Z1*Z)**H
+*  If Q1 is the unitary matrix from the QR factorization of B in the
+*  original equation A*x = lambda*B*x, then ZGGHRD reduces the original
+*  problem to generalized Hessenberg form.
 *
 *  Arguments
 *  =========
@@ -66,10 +79,11 @@
 *
 *  ILO     (input) INTEGER
 *  IHI     (input) INTEGER
-*          It is assumed that A is already upper triangular in rows and
-*          columns 1:ILO-1 and IHI+1:N.  ILO and IHI are normally set
-*          by a previous call to ZGGBAL; otherwise they should be set
-*          to 1 and N respectively.
+*          ILO and IHI mark the rows and columns of A which are to be
+*          reduced.  It is assumed that A is already upper triangular
+*          in rows and columns 1:ILO-1 and IHI+1:N.  ILO and IHI are
+*          normally set by a previous call to ZGGBAL; otherwise they
+*          should be set to 1 and N respectively.
 *          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.
 *
 *  A       (input/output) COMPLEX*16 array, dimension (LDA, N)
@@ -83,33 +97,28 @@
 *
 *  B       (input/output) COMPLEX*16 array, dimension (LDB, N)
 *          On entry, the N-by-N upper triangular matrix B.
-*          On exit, the upper triangular matrix T = Q' B Z.  The
+*          On exit, the upper triangular matrix T = Q**H B Z.  The
 *          elements below the diagonal are set to zero.
 *
 *  LDB     (input) INTEGER
 *          The leading dimension of the array B.  LDB >= max(1,N).
 *
 *  Q       (input/output) COMPLEX*16 array, dimension (LDQ, N)
-*          If COMPQ='N':  Q is not referenced.
-*          If COMPQ='I':  on entry, Q need not be set, and on exit it
-*                         contains the unitary matrix Q, where Q'
-*                         is the product of the Givens transformations
-*                         which are applied to A and B on the left.
-*          If COMPQ='V':  on entry, Q must contain a unitary matrix
-*                         Q1, and on exit this is overwritten by Q1*Q.
+*          On entry, if COMPQ = 'V', the unitary matrix Q1, typically
+*          from the QR factorization of B.
+*          On exit, if COMPQ='I', the unitary matrix Q, and if
+*          COMPQ = 'V', the product Q1*Q.
+*          Not referenced if COMPQ='N'.
 *
 *  LDQ     (input) INTEGER
 *          The leading dimension of the array Q.
 *          LDQ >= N if COMPQ='V' or 'I'; LDQ >= 1 otherwise.
 *
 *  Z       (input/output) COMPLEX*16 array, dimension (LDZ, N)
-*          If COMPZ='N':  Z is not referenced.
-*          If COMPZ='I':  on entry, Z need not be set, and on exit it
-*                         contains the unitary matrix Z, which is
-*                         the product of the Givens transformations
-*                         which are applied to A and B on the right.
-*          If COMPZ='V':  on entry, Z must contain a unitary matrix
-*                         Z1, and on exit this is overwritten by Z1*Z.
+*          On entry, if COMPZ = 'V', the unitary matrix Z1.
+*          On exit, if COMPZ='I', the unitary matrix Z, and if
+*          COMPZ = 'V', the product Z1*Z.
+*          Not referenced if COMPZ='N'.
 *
 *  LDZ     (input) INTEGER
 *          The leading dimension of the array Z.
