--- src/sgeesx.f	Thu Dec  5 20:18:10 2002
+++ debian/updates/src/sgeesx.f	Wed Dec  4 15:23:42 2002
@@ -6,6 +6,7 @@
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
 *     June 30, 1999 
+*     8-15-00:  Do WS calculations if LWORK = -1 (eca)
 *
 *     .. Scalar Arguments ..
       CHARACTER          JOBVS, SENSE, SORT
@@ -140,6 +141,10 @@
 *          N+2*SDIM*(N-SDIM) <= N+N*N/2.
 *          For good performance, LWORK must generally be larger.
 *
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
+*
 *  IWORK   (workspace/output) INTEGER array, dimension (LIWORK)
 *          Not referenced if SENSE = 'N' or 'E'.
 *          On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK.
@@ -171,6 +176,8 @@
 *  =====================================================================
 *
 *     .. Parameters ..
+      INTEGER            LQUERV
+      PARAMETER          ( LQUERV = -1 )
       REAL               ZERO, ONE
       PARAMETER          ( ZERO = 0.0E0, ONE = 1.0E0 )
 *     ..
@@ -239,7 +246,7 @@
 *       in the code.)
 *
       MINWRK = 1
-      IF( INFO.EQ.0 .AND. LWORK.GE.1 ) THEN
+      IF( INFO.EQ.0 ) THEN
          MAXWRK = 2*N + N*ILAENV( 1, 'SGEHRD', ' ', N, 1, N, 0 )
          MINWRK = MAX( 1, 3*N )
          IF( .NOT.WANTVS ) THEN
@@ -257,21 +264,24 @@
             HSWORK = MAX( K*( K+2 ), 2*N )
             MAXWRK = MAX( MAXWRK, N+HSWORK, 1 )
          END IF
+*
+*        Estimate the workspace needed by STRSEN.
+*
+         IF( WANTST ) THEN
+            MAXWRK = MAX( MAXWRK, N+(N*N+1)/2 )
+         END IF
          WORK( 1 ) = MAXWRK
+         IF( LWORK.LT.MINWRK .AND. LWORK.NE.LQUERV )
+     $      INFO = -16
       END IF
-      IF( LWORK.LT.MINWRK ) THEN
-         INFO = -16
-      END IF
-      IF( LIWORK.LT.1 ) THEN
-         INFO = -18
-      END IF
+*
+*     Quick returns
+*
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'SGEESX', -INFO )
          RETURN
       END IF
-*
-*     Quick return if possible
-*
+      IF( LWORK.EQ.LQUERV ) RETURN
       IF( N.EQ.0 ) THEN
          SDIM = 0
          RETURN
