!= Module HistoryFileIO
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: historyfileio.f90,v 1.14 2006/11/20 00:27:14 sugiyama Exp $ 
! Tag Name::  $Name: arare4-20061224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ե. Ĺ֥ƥåפͤ.
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module HistoryFileIO
  !
  !ե. Ĺ֥ƥåפͤ.
  !

  !⥸塼ɤ߹
  use gt4_history, only: HistoryCreate, HistoryPut, HistoryAddVariable, &
    &                    HistoryClose, gt_history

  use gridset,  only: s_X,               &!X ɸ(顼ʻ)
    &                 s_Z,               &!Z ɸ(顼ʻ)
    &                 FileNX,            &!X γʻ(ե)
    &                 FileNZ,            &!Z γʻ(ե)
    &                 FileXMin,          &!X β(ե)
    &                 FileXMax,          &!X ξ(ե)
    &                 FileZMin,          &!Z β(ե)
    &                 FileZMax,          &!Z ξ(ե)
    &                 DimXMin,           &!X β
    &                 DimXMax,           &!X ξ
    &                 DimZMin,           &!Z β
    &                 DimZMax,           &!Z ξ
    &                 SpcNum              !Žʬο
  use basicset, only: xz_ExnerBasicZ,    &!ܾΥʡؿ
    &                 xz_DensBasicZ,     &!ܾ̩
    &                 xz_PotTempBasicZ,  &!ܾβ
    &                 xz_VelSoundBasicZ, &!ܾβ®
    &                 xz_PressBasicZ,    &!ܾΰ
    &                 xz_TempBasicZ,     &!ܾβ
    &                 xza_MixRtBasicZ,   &!ܾκ
    &                 xz_EffMolWtBasicZ, &!ܾʬ̸
    &                 SpcWetSymbol        !ʬβؼ̾
  use fileset,  only: HistoryFile,       &!ҥȥե̾
    &                 exptitle,          &!ǡɽ
    &                 expsrc,            &!ǡ
    &                 expinst,           &!ǽѹԡȿ
    &                 FileNum,           &!ҥȥեο
    &                 gt_hist             !gt_history ¤ѿ
  use StoreSet, only: StoreMeanX,        &!
    &                 z_Stab,            &!
    &                 z_StabTemp,        &!
    &                 z_StabMolWt,       &!
    &                 za_MixRt,          &!
    &                 z_Adv,             &!
    &                 z_Turb,            &!
    &                 z_Disp,            &!
    &                 z_Diff,            &!
    &                 z_Rad,             &!
    &                 z_Cond,            &!
    &                 z_Flux,            &!
    &                 z_Damp              !
  use StoreSet2

  !ۤηػ
  implicit none
  
  !°λ
  private

  !ؿ public ˻
  public HistoryFile_Open
  public HistoryFile_OutPut
  public HistoryFile_Close

contains 

!!!------------------------------------------------------------------------
  subroutine HistoryFile_Open( )
    !
    !ҥȥե
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    integer :: s ! 롼ź

    !-----------------------------------------------------------
    ! ҥȥ꡼
    !-----------------------------------------------------------
    do s = 1, FileNum
      call HistoryCreate(                              &
        & file = HistoryFile(s),                       &
        & title = exptitle,                            &
        & source = expsrc,                             &
        & institution = expinst,                       &
        & dims=(/'x','z','t'/),                        &
        & dimsizes=(/FileNX, FileNZ, 0/),              &
        & longnames=(/'X-coordinate',                  &
        &             'Z-coordinate',                  &
        &             'Time        '/),                &
        & units=(/'m','m','s'/), origin=0.0,           &
        & interval=0.0,                                &
        & history=gt_hist(s) )

      call HistoryPut('x', s_X( FileXMin: FileXMax ), gt_hist(s) )
      call HistoryPut('z', s_Z( FileZMin: FileZMax ), gt_hist(s) )
!      call HistoryPut('z', xz_PressBasicZ( 1, FileZMin: FileZMax ), gt_hist(s) )

    end do

    !-----------------------------------------------------------  
    ! ͽѿν
    !-----------------------------------------------------------  
    !̵Ϥξ
    call HistoryAddVariable(  &
      & varname='Exner',      &  
      & dims=(/'x','z','t'/), &
      & longname='disturbunce of nondimensional pressure', &
      & units=' ',            &        
      & xtype='double',       &
      & history=gt_hist(1) )
    
    !̤ξ
    call HistoryAddVariable(  &
      & varname='PotTemp',    &
      & dims=(/'x','z','t'/), &
      & longname='disturbunce of potential temperature',  &
      & units='K',            &
      & xtype='double',       &
      & history=gt_hist(2) )

    !ʿ®
    call HistoryAddVariable(  &
      & varname='VelX',       &
      & dims=(/'x','z','t'/), &
      & longname='zonal velocity', &
      & units='m s|-1"',      &
      & xtype='double',       &
      & history=gt_hist(3) )

    !ľ®
    call HistoryAddVariable(  &
      & varname='VelZ',       &
      & dims=(/'x','z','t'/), &
      & longname='vertical velocity', &
      & units='m s|-1"',      &
      & xtype='double',       &
      & history=gt_hist(4) )

    !Ǵ(ư)
    call HistoryAddVariable(  &
      & varname='Km',         &
      & dims=(/'x','z','t'/), &
      & longname='turbulet diffusion coefficient', &
      & units='1',            &
      & xtype='double',       &
      & history=gt_hist(5) )
  
    !Ǵ(Ǯ)
    call HistoryAddVariable(  &
      & varname='Kh',         &
      & dims=(/'x','z','t'/), &
      & longname='turbulet diffusion coefficient for heat', &
      & units='1',            &
      & xtype='double',       &
      & history=gt_hist(6) )
  
    !
    do s = 1, SpcNum
      call HistoryAddVariable(                               &
        & varname=trim(SpcWetSymbol(s)),                     &
        & dims=(/'x','z','t'/),                              &
        & longname=trim(SpcWetSymbol(s))//' Mixing Ratio',   &
        & units='kg kg|-1"',                                 &
        & xtype='double',                                    &
        & history=gt_hist(8+s))
    end do
    
    !----------------------------------------------------------------
    ! Stored Mixing Ratio
    !----------------------------------------------------------------
    do s = 1, SpcNum
      call HistoryAddVariable(                               &
        & varname=trim(SpcWetSymbol(s))//'_Mean',            &
        & dims=(/'z','t'/),                                  &
        & longname='Horiizontal Mean of '                    &
        &          //trim(SpcWetSymbol(s))//' Mixing Ratio', &
        & units='kg kg|-1"',                                 &
        & xtype='double',                                    &
        & history=gt_hist(8+s) ) 
    end do

    !----------------------------------------------------------------
    ! Ū
    !----------------------------------------------------------------
    call HistoryAddVariable(  &
      & varname='Stab',       &
      & dims=(/'z','t'/),     &
      & longname='Static Stability', &
      & units='s|-2"',        &
      & xtype='double',       &
      & history=gt_hist(8) ) 

    call HistoryAddVariable(  &
      & varname='StabTemp',   &
      & dims=(/'z','t'/),     &
      & longname='Static Stability contributed by temperature', &
      & units='s|-2"',        &
      & xtype='double',       &
      & history=gt_hist(8) ) 

    call HistoryAddVariable(  &
      & varname='StabMolWt',  &
      & dims=(/'z','t'/),     &
      & longname='Static Stability contributed by Molecular Weight',&
      & units='s|-2"',        &
      & xtype='double',       &
      & history=gt_hist(8) ) 

    !----------------------------------------------------------------
    ! ̤λѲ
    !----------------------------------------------------------------
    call HistoryAddVariable(  &
      & varname='PotTempAdv', &
      & dims=(/'z','t'/),     &
      & longname='Advection term of potential temperature',  &
      & units='K day|-1"',    &
      & xtype='double',       &
      & history=gt_hist(8) ) 

    call HistoryAddVariable(  &
      & varname='PotTempTurb',&
      & dims=(/'z','t'/),     &
      & longname='Turbulence term of potential temperature', &
      & units='K day|-1"',    &
      & xtype='double',       &
      & history=gt_hist(8) ) 

    call HistoryAddVariable(  &
      & varname='PotTempDisp',&
      & dims=(/'z','t'/),     &
      & longname='Dissipation term of potential temperature', &
      & units='K day|-1"',    &
      & xtype='double',       &
      & history=gt_hist(8) ) 

    call HistoryAddVariable(  &
      & varname='PotTempRad', &
      & dims=(/'z','t'/),     &
      & longname='Radiation term of potential temperature', &
      & units='K day|-1"',    &
      & xtype='double',       &
      & history=gt_hist(8) ) 
    
    call HistoryAddVariable(  &
      & varname='PotTempDiff',&
      & dims=(/'z','t'/),     &
      & longname='Numerical diffusion term of potential temperature',&
      & units='K day|-1"',    &
      & xtype='double',       &
      & history=gt_hist(8) ) 
    
    call HistoryAddVariable(  &
      & varname='PotTempCond',&
      & dims=(/'z','t'/),     &
      & longname='Latent heat term of potential temperature', &
      & units='K day|-1"',    &
      & xtype='double',       &
      & history=gt_hist(8) ) 

    call HistoryAddVariable(  &
      & varname='PotTempFlux',&
      & dims=(/'z','t'/),     &
      & longname='Surface Flux term of potential temperature', &
      & units='K day|-1"',    &
      & xtype='double',       &
      & history=gt_hist(8) ) 

    call HistoryAddVariable(  &
      & varname='PotTempDamp',&
      & dims=(/'z','t'/),     &
      & longname='Newtonian Cooling term of potential temperature',  &
      & units='K day|-1"',    &
      & xtype='double',       &
      & history=gt_hist(8) ) 

    !----------------------------------------------------------------
    ! Mixing Ratio time change
    !----------------------------------------------------------------
    do s = 1, SpcNum
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Adv', &
        & dims=(/'z','t'/),     &
        & longname='Advection term of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg kg|-1" s|-1"',    &
        & xtype='double',       &
        & history=gt_hist(8) ) 
      
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Turb', & 
        & dims=(/'z','t'/),     &
        & longname='Turbulence term of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg kg|-1" s|-1"',    &
        & xtype='double',       &
        & history=gt_hist(8) ) 
      
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Diff', & 
        & dims=(/'z','t'/),     &
        & longname='Diffusion term of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg kg|-1" s|-1"',    &
        & xtype='double',       &
        & history=gt_hist(8) ) 
      
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Flux', & 
        & dims=(/'z','t'/),     &
        & longname='Surface Flux term of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg kg|-1" s|-1"',    &
        & xtype='double',       &
        & history=gt_hist(8) ) 
    
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Rain', & 
        & dims=(/'z','t'/),     &
        & longname='Fall Rain term of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg kg|-1" s|-1"',    &
        & xtype='double',       &
        & history=gt_hist(8) ) 
    
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Fill1', & 
        & dims=(/'z','t'/),     &
        & longname='Filling Negative term 1 of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg kg|-1" s|-1"',    &
        & xtype='double',       &
        & history=gt_hist(8) ) 
    
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Fill2', & 
        & dims=(/'z','t'/),     &
        & longname='Filling Negative term 2 of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg kg|-1" s|-1"',    &
        & xtype='double',       &
        & history=gt_hist(8) ) 
    
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Cond', & 
        & dims=(/'z','t'/),     &
        & longname='Condensation term of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg kg|-1" s|-1"',    &
        & xtype='double',       &
        & history=gt_hist(8) ) 
    
!      call HistoryAddVariable(  &
!        & varname=trim(SpcWetSymbol(s))//'_Asln', & 
!        & dims=(/'z','t'/),     &
!        & longname='Asselin time filter term of '          &
!        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
!        & units='kg kg|-1" s|-1"',    &
!        & xtype='double',       &
!        & history=gt_hist(8) ) 
    
    end do

    !-----------------------------------------------------------  
    ! ܾν
    !-----------------------------------------------------------  
    !̵Ϥδܾ
    call HistoryAddVariable(  &
      & varname='ExnerBasicZ',&
      & dims=(/'x','z'/),     &
      & longname='nondimensional pressure', units='1',&
      & xtype='double',       &
      & history=gt_hist(7) ) 
    
    !̤δܾ
    call HistoryAddVariable(  &
      & varname='PotTempBasicZ',&
      & dims=(/'x','z'/),     &
      & longname='potential temperature', &
      & units='K',            &
      & xtype='double',       &
      & history=gt_hist(7) ) 
    
    !̤δܾ
    call HistoryAddVariable(  &
      & varname='VPotTempBasicZ',&
      & dims=(/'x','z'/),     &
      & longname='vertial potential temperature', &
      & units='K',            &
      & xtype='double',       &
      & history=gt_hist(7) ) 
    
    !̩٤δܾ
    call HistoryAddVariable(  &
      & varname='DensBasicZ', &
      & dims=(/'x','z'/),     &
      & longname='density',   &
      & units='Kg/m^3',       &
      & xtype='double',       &
      & history=gt_hist(7) ) 
    
    !®٤δܾ
    call HistoryAddVariable(  &
      & varname='VelSoundBasicZ',&
      & dims=(/'x','z'/),     &
      & longname='sound velocity',&
      & units='m/s|2',        &
      & xtype='double',       &
      & history=gt_hist(7) ) 
    
    !٤δܾ
    call HistoryAddVariable(  &
      & varname='TempBasicZ', &
      & dims=(/'x','z'/),     &
      & longname='Temperature of basic state', &
      & units='K',            &
      & xtype='double',       &
      & history=gt_hist(7) ) 
    
    !Ϥδܾ
    call HistoryAddVariable(  &
      & varname='PressBasicZ',&
      & dims=(/'x','z'/),     &
      & longname='Pressure of basic state', &
      & units='Pa',           &
      & xtype='double',       &
      & history=gt_hist(7) ) 
    
    !δܾ
    do s = 1, SpcNum
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'BasicZ',&
        & dims=(/'x','z'/), &
        & longname=trim(SpcWetSymbol(s))//' Mixing Ratio of basic state', &
        & units='kg/kg',        &
        & xtype='double',       &
        & history=gt_hist(7) ) 
    end do

    !ʬ̸
    call HistoryAddVariable(  &
      & varname='EffMolWtBasicZ', &
      & dims=(/'x','z'/),     &
      & longname='Effect of Mole Weight', &
      & units='1',            &
      & xtype='double',       &
      & history=gt_hist(7) ) 

    !-------------------------------------------------------------
    ! ܾΥե
    !-------------------------------------------------------------
    call HistoryPut(   &
      & 'DensBasicZ',  &
      & xz_DensBasicZ(FileXMin:FileXMax, FileZMin:FileZMax), &
      & gt_hist(7) )

    call HistoryPut(   &
      & 'ExnerBasicZ', &
      & xz_ExnerBasicZ(FileXMin:FileXMax, FileZMin:FileZMax), &
      & gt_hist(7) )

    call HistoryPut(   &
      & 'PotTempBasicZ',&
      & xz_PotTempBasicZ(FileXMin:FileXMax, FileZMin:FileZMax), &
      & gt_hist(7) )

    call HistoryPut(   &
      & 'VPotTempBasicZ',&
      & xz_PotTempBasicZ(FileXMin:FileXMax, FileZMin:FileZMax)    &
      & / xz_EffMolWtBasicZ(FileXMin:FileXMax, FileZMin:FileZMax),&
      & gt_hist(7) )

    call HistoryPut(   &
      & 'VelSoundBasicZ', &
      & xz_VelSoundBasicZ(FileXMin:FileXMax, FileZMin:FileZMax), &
      & gt_hist(7) )

    call HistoryPut(   &
      & 'TempBasicZ',  &
      & xz_TempBasicZ(FileXMin:FileXMax, FileZMin:FileZMax), &
      & gt_hist(7) )

    call HistoryPut(   &
      & 'PressBasicZ', &
      & xz_PressBasicZ(FileXMin:FileXMax, FileZMin:FileZMax), &
      & gt_hist(7) )

    do s = 1, SpcNum
      call HistoryPut( &
        & trim(SpcWetSymbol(s))//'BasicZ',    &
        & xza_MixRtBasicZ(FileXMin:FileXMax, FileZMin:FileZMax, s), &
        & gt_hist(7) )
    end do

    call HistoryPut(   &
      & 'EffMolWtBasicZ', &
      & xz_EffMolWtBasicZ(FileXMin:FileXMax, FileZMin:FileZMax), &
      & gt_hist(7) )
    
  end subroutine HistoryFile_Open


!!!---------------------------------------------------------------------------
  subroutine HistoryFile_OutPut(   &
    & Time,                        &
    & xz_PotTemp,                  &
    & xz_Exner,                    &   
    & pz_VelX,                     &
    & xr_VelZ,                     &
    & xza_MixRt,                   &
    & xz_Km,                       &
    & xz_Kh                        &
    )
    !
    !ͽѿΥҥȥեؤν. ϻˤȾʻΰ֤ǥץå. 
    !
    
    !⥸塼ɤ߹
    use average,   only: xz_avr_pz, xz_avr_xr

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: Time
    real(8), intent(in) :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xz_Km(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xz_Kh(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)

    real(8)             :: xz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)             :: xz_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
    integer             :: s

    !----------------------------------------------------------------
    ! ʻ֤Ѵ
    !----------------------------------------------------------------
    xz_VelX = xz_avr_pz( pz_VelX )
    xz_VelZ = xz_avr_xr( xr_VelZ )

    !----------------------------------------------------------------
    ! ͤ
    !----------------------------------------------------------------

    do s = 1, 8 + SpcNum
      call HistoryPut( 't', Time, gt_hist(s) )
    end do
    
    call HistoryPut(  &
      & 'Exner',      &
      & xz_Exner(FileXMin:FileXMax, FileZMin:FileZMax),   &
      & gt_hist(1) )

    call HistoryPut(  &
      & 'PotTemp',    &
      & xz_PotTemp(FileXMin:FileXMax, FileZMin:FileZMax), &
      & gt_hist(2) )

    call HistoryPut(  &
      & 'VelX',       &
      & xz_VelX(FileXMin:FileXMax, FileZMin:FileZMax),    &
      & gt_hist(3) )
    
    call HistoryPut(  &
      & 'VelZ',       &
      & xz_VelZ(FileXMin:FileXMax, FileZMin:FileZMax),    &
      & gt_hist(4) )

    call HistoryPut(  &
      & 'Km',         &
      & xz_Km(FileXMin:FileXMax, FileZMin:FileZMax),      &
      & gt_hist(5) )
    
    call HistoryPut(  &
      & 'Kh',         &
      & xz_Kh(FileXMin:FileXMax, FileZMin:FileZMax),      &
      & gt_hist(6) )
    
    do s = 1, SpcNum
      call HistoryPut(     &
        & trim(SpcWetSymbol(s)), &
        & xza_MixRt(FileXMin:FileXMax, FileZMin:FileZMax, s), &
        & gt_hist(8+s) )
    end do

    !----------------------------------------------------------------
    ! ͤ
    !----------------------------------------------------------------
    call StoreMeanX()
    call Store2MeanX()

    do s = 1, SpcNum
      call HistoryPut(                       &
        & trim(SpcWetSymbol(s))//'_Mean',    &
        & za_MixRt(FileZMin:FileZMax, s),    &
        & gt_hist(8+s) )
    end do

    call HistoryPut(   &
      & 'PotTempAdv',  &
      & z_Adv(FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'PotTempTurb', &
      & z_Turb(FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'PotTempDisp', &
      & z_Disp(FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'PotTempDiff', &
      & z_Diff(FileZMin:FileZMax),&
      & gt_hist(8) )

    call HistoryPut(   &
      & 'PotTempRad',  &
      & z_Rad(FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'PotTempCond', &
      & z_Cond(FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'PotTempFlux', &
      & z_Flux(FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'PotTempDamp', &
      & z_Damp(FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'Stab',        &
      & z_Stab(FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'StabTemp',    &
      & z_StabTemp(FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'StabMolWt',   &
      & z_StabMolWt(FileZMin:FileZMax), &
      & gt_hist(8) )

    do s = 1, SpcNum
      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Adv',    &
        & za_Adv(FileZMin:FileZMax, s),   &
        & gt_hist(8) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Turb',    &
        & za_Turb(FileZMin:FileZMax, s),   &
        & gt_hist(8) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Diff',    &
        & za_Diff(FileZMin:FileZMax, s),   &
        & gt_hist(8) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Flux',    &
        & za_Flux(FileZMin:FileZMax, s),   &
        & gt_hist(8) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Rain',    &
        & za_Rain(FileZMin:FileZMax, s),   &
        & gt_hist(8) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Fill1',    &
        & za_Fill1(FileZMin:FileZMax, s),   &
        & gt_hist(8) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Fill2',    &
        & za_Fill2(FileZMin:FileZMax, s),   &
        & gt_hist(8) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Cond',    &
        & za_cond(FileZMin:FileZMax, s),   &
        & gt_hist(8) )

!      call HistoryPut(                      &
!        & trim(SpcWetSymbol(s))//'_Asln',    &
!        & za_Asln(FileZMin:FileZMax, s),   &
!        & gt_hist(8) )

    end do

  end subroutine HistoryFile_OutPut


!!!--------------------------------------------------------------------------
  subroutine HistoryFile_Close
    !
    !ҥȥեΥ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    integer :: s ! 롼ź

    !եĤ
    do s = 1, FileNum
      call HistoryClose(gt_hist(s))
    end do

  end subroutine HistoryFile_Close


end module HistoryFileIO
