!= Module MoistFunc
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: moistfunc.f90,v 1.12 2006/09/21 03:01:00 odakker Exp $
! Tag Name::  $Name: arare4-20061224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ʷ׻ġ뷲
!   * 麮Ѵ
!   * 椫麮Ѵ
!   * 椫Ѵ
!   * 椫Ѵ
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

module MoistFunc
  !
  !ñ̤δԤΥѥå⥸塼
  !   * 麮Ѵ
  !   * 椫麮Ѵ
  !   * 椫Ѵ
  !   * 椫Ѵ
  ! 

  !⥸塼ɤ߹
  use gridset, only:  DimXMin,            & ! x β
    &                 DimXMax,            & ! x ξ
    &                 DimZMin,            & ! z β
    &                 DimZMax               ! z ξ
  use basicset, only: PressBasis,         & !̤ɸవ         [Pa]
    &                 CpDry,              & !ʬʿ갵Ǯ [J/K kg]
    &                 MolWtDry,           & !ʬʿʬ   [kg/mol]
    &                 GasRDry               !ʬε     [J/K kg]
  use ChemCalc, only: xz_SvapPress,        &!˰¾
    &                 xz_DSvapPressDTemp    !˰¾βʬ

  !ۤηػ
  implicit none 
  
  !°λ
  private

  !ؿ public ˻
  public xz_DMixRtSatDPotTemp
  public xz_DelMixRtNH4SH
  public DelMolFrNH4SH

contains

!!!
!!!ܴؿ
!!!

!!!-----------------------------------------------------------------------!!!
  function xz_DMixRtSatDPotTemp(SpcID, MolWt, xz_TempAll, xz_ExnerAll)
    !
    !˰¾  ʬԤ
    !ºݤˤ, dq/dp * dp/dT * dT/d ¹. (â p ˰¾)
    !

    !ۤηػ
    implicit none 
    
    !ѿ
    integer, intent(in) :: SpcID
    real(8), intent(in) :: MolWt
    real(8), intent(in) :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                            !( + ܾ)
    real(8), intent(in) :: xz_ExnerAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                            !ʡؿ( + ܾ)
    real(8)             :: xz_PressAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                            !( + ܾ)
    real(8)             :: xz_DMixRtSatDPotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
                           
    xz_DMixRtSatDPotTemp   = 0.0d0
    xz_PressAll = PressBasis * (xz_ExnerAll ** (CpDry / GasRDry))
    
    xz_DMixRtSatDPotTemp =                            &
      &   MolWt / ( MolWtDry * xz_PressAll )          &
      & * xz_DSvapPressDTemp(SpcID, xz_TempAll)       &
      & * xz_ExnerAll
    
  end function xz_DMixRtSatDPotTemp


!!!-----------------------------------------------------------------------!!!
  function xz_DelMixRtNH4SH(xz_TempAll, xz_PressAll, xz_MixRtNH3, xz_MixRtH2S, &
    &                    MolWtNH3, MolWtH2S)
    !
    ! NH4SH ȿȼ, NH4SH ()
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                         !
    real(8), intent(in) :: xz_PressAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                         !
    real(8), intent(in) :: xz_MixRtNH3(DimXMin:DimXMax, DimZMin:DimZMax)
                                         !NH3 κ
    real(8), intent(in) :: xz_MixRtH2S(DimXMin:DimXMax, DimZMin:DimZMax)
                                         !H2S κ
    real(8), intent(in) :: MolWtNH3      !NH3 ʬ
    real(8), intent(in) :: MolWtH2S      !H2S ʬ
    real(8)             :: xz_DelMixRtNH4SH(DimXMin:DimXMax, DimZMin:DimZMax)
                                         !NH4SH κ
    real(8)             :: xz_EquivConst(DimXMin:DimXMax, DimZMin:DimZMax)
                                         !ʿ
    real(8)             :: xza_PartialPress(DimXMin:DimXMax, DimZMin:DimZMax,2)
                                         !(ʬ)
    real(8)             :: xz_Solution(DimXMin:DimXMax, DimZMin:DimZMax)
                                         !(β)

    !
    xz_DelMixRtNH4SH = 0.0d0

    !˥βǤʬ. 
    xza_PartialPress(:,:,1) = xz_MixRtNH3 * xz_PressAll * MolWtDry / MolWtNH3 
    xza_PartialPress(:,:,2) = xz_MixRtH2S * xz_PressAll * MolWtDry / MolWtH2S      
    
    !ʿ
    xz_EquivConst = 61.781d0 - 10834.0d0 / xz_TempAll - dlog(1.0d2)
    
    !Ѳ. 
    !  (P_NH3 - X) * (P_H2S - X) = exp(Kp)
    !  DelX^2 - (P_NH3 + P_H2S) * DelX + P_NH3 * P_H2S * exp( Kp ) = 0
    !  Ȥɬפ뤬, P_NH3 > P_H2S  X < P_H2S 
    !  θ, θΤ򤵤.
    xz_Solution  =                                                   &
      & (                                                            &
      &     sum(xza_PartialPress, 3)                                        &
      &   - dsqrt( (xza_PartialPress(:,:,1) - xza_PartialPress(:,:,2)) ** 2.0d0 &
      &            + 4.0d0 * dexp( min( 700.0d0, xz_EquivConst ) ) ) &
      &  ) * 5.0d-1

    !̤
    xz_DelMixRtNH4SH = xz_Solution * ( MolWtNH3 + MolWtH2S ) / ( xz_PressAll * MolWtDry )

  end function xz_DelMixRtNH4SH
  

!!!-----------------------------------------------------------------------!!!
  function DelMolFrNH4SH(TempAll, PressAll, MolFrNH3, MolFrH2S, Humidity)
    !
    ! NH4SH ȿȼ H2S  NH3 Υθʬ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: TempAll       !
    real(8), intent(in) :: PressAll      !
    real(8), intent(in) :: MolFrNH3      !NH3 Υ
    real(8), intent(in) :: MolFrH2S      !H2S Υ
    real(8), intent(in) :: Humidity      !˰
    real(8)             :: DelMolFrNH4SH !NH4SH ȼѲ
    real(8)             :: EquivConst    !ʿ
    real(8)             :: PPress(2)     !(ʬ)
    real(8)             :: Solution      !(β)

    !------------------------------------------------------------
    !NH4SH ʿվ
    !------------------------------------------------------------
    !˥βǤʬ
    PPress(1) = MolFrNH3 * PressAll
    PPress(2) = MolFrH2S * PressAll

    !ʿ
    EquivConst = 61.781d0 - 10834.0d0 / TempAll - dlog(1.0d2) - 2.0d0 * dlog( Humidity )
    
    !ѲβȤƵ. 
    Solution = 5.0d-1 * (sum(PPress) &
      &        - dsqrt( (PPress(1) - PPress(2))**2.0d0 &
      &                    + 4.0d0 * dexp( min( 700.0d0, EquivConst ))) )
    
    !NH4SH . 
    DelMolFrNH4SH = Solution / PressAll

  end function DelMolFrNH4SH

end module MoistFunc
