!= Module GridSet
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: gridset.f90,v 1.4 2006/09/30 05:53:59 odakker Exp $ 
! Tag Name::  $Name: arare4-20061224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϳ줿 NAMELIST ե뤫, ʻ, 
!ݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module gridset
  !
  !Ϳ줿 NAMELIST ե뤫, ʻ, 
  !ݴɤ뤿ѿ⥸塼
  !

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  !ۤηػ
  implicit none

  !save °
  save

  !ѿ
  real(8)               :: Xmin, Xmax    ! x ɸλ
  real(8)               :: Zmin, Zmax    ! z ɸλ
  real(8)               :: DelX, DelZ    !ʻҴֳ
  integer               :: NX, NZ        !ʻ
  integer, parameter    :: MarginX = 5    !Υåɿ
  integer, parameter    :: MarginZ = 5    !Υåɿ
  integer               :: SpcNum        !ؼο
  integer               :: DimXMin       ! x β
  integer               :: DimXMax       ! x ξ
  integer               :: DimZMin       ! z β
  integer               :: DimZMax       ! z ξ
  integer               :: RegXMin       ! x ʪΰβ
  integer               :: RegXMax       ! x ʪΰξ
  integer               :: RegZMin       ! z ʪΰβ
  integer               :: RegZMax       ! z ʪΰξ
  integer               :: FileNX        !ե
  integer               :: FileNZ        !ե
  integer               :: FileXMin      !ե
  integer               :: FileXMax      !ե
  integer               :: FileZMin      !ե
  integer               :: FileZMax      !ե
  real(8), allocatable  :: s_X(:)        !X ɸ(顼ʻ)
  real(8), allocatable  :: f_X(:)        !X ɸ(٥ȥʻ)
  real(8), allocatable  :: s_Z(:)        !Z ɸ(顼ʻ)
  real(8), allocatable  :: f_Z(:)        !Z ɸ(٥ȥʻ)

contains

  subroutine gridset_init(cfgfile)
    !
    !NAMELIST , ʻ׻
    !

    !⥸塼ɤ߹
    use DebugSet, only: DebugOn
    use chemcalc, only: ChemCalcDim_init !礭ν
    
    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile

    !ѿ
    integer            :: i, k
    integer, parameter :: kind = 8      !٤ɽ

    !-----------------------------------------------------------------
    ! NAMELIST 
    !-----------------------------------------------------------------
    NAMELIST /gridset/ NX, NZ, Xmin, Xmax, Zmin, Zmax, SpcNum

    open (10, FILE=cfgfile)
    read(10, NML=gridset)
    close(10)

    !-----------------------------------------------------------------
    ! ʻֳַ׻
    !-----------------------------------------------------------------
    DelX = (Xmax - Xmin) / real(NX, kind)
    DelZ = (Zmax - Zmin) / real(NZ, kind)

    !-----------------------------------------------------------------
    ! ʪŪ˰̣Τΰξ¡¤
    !-----------------------------------------------------------------;
    RegXMin = 0
    RegXMax = NX
    RegZMin = 0
    RegZMax = NZ

    !-----------------------------------------------------------------
    ! ξ¡¤
    !-----------------------------------------------------------------
    DimXMin = RegXMin - MarginX
    DimXMax = RegXMax + MarginX
    DimZMin = RegZMin - MarginZ
    DimZMax = RegZMax + MarginZ

    !-----------------------------------------------------------------
    ! åɤ
    !-----------------------------------------------------------------
    allocate( f_X(DimXMin:DimXMax), f_Z(DimZMin:DimZMax) )
    do i = DimXMin, DimXMax
      f_X(i) = Xmin + DelX * ( real(i, kind) - RegXMin )
    end do
    do k = DimZMin, DimZMax
      f_Z(k) = Zmin + DelZ * ( real(k, kind) - RegZMin )
    end do
    
    !-----------------------------------------------------------------
    ! ȾʻҤ줿åɤ. ֳ֤ˤƤ.
    !-----------------------------------------------------------------
    allocate( s_X(DimXMin: DimXMax), s_Z(DimZMin: DimZMax) )
    s_X(DimXMin+1:DimXMax) =           &
      &  (                             &
      &     f_X(DimXMin+1:DimXMax)     &
      &   + f_X(DimXMin:DimXMax-1)     &
      &  ) * 5.0d-1
    s_X(DimXMin) = s_X(DimXMin+1) - DelX
    
    s_Z(DimZMin+1:DimZMax) =           &
      &  (                             &
      &     f_Z(DimZMin+1:DimZMax)     &
      &   + f_Z(DimZMin:DimZMax-1)     &
      &  ) * 5.0d-1
    s_Z(DimZMin) = s_Z(DimZMin+1) - DelZ

    !-----------------------------------------------------------------
    ! ǥХå⡼ɤݤ, եϤѤѿ礭Ѥ
    !-----------------------------------------------------------------
    if (DebugOn) then
      FileNX   = size(f_X, 1)
      FileNZ   = size(f_Z, 1)
      FileXMin = DimXMin
      FileXMax = DimXMax
      FileZMin = DimZMin
      FileZMax = DimZMax
    else
      FileNX   = NX
      FileNZ   = NZ
      FileXMin = RegXMin + 1
      FileXMax = RegXMax
      FileZMin = RegZMin + 1
      FileZMax = RegZMax
    end if

    !-----------------------------------------------------------------    
    ! ǧ
    !-----------------------------------------------------------------
    call MessageNotify( "M", "gridset_init", "XMin = %f", d=(/XMin/)    )
    call MessageNotify( "M", "gridset_init", "XMax = %f", d=(/XMax/)    )
    call MessageNotify( "M", "gridset_init", "ZMin = %f", d=(/ZMin/)    )
    call MessageNotify( "M", "gridset_init", "ZMax = %f", d=(/ZMax/)    )
    call MessageNotify( "M", "gridset_init", "DelX = %f", d=(/DelX/)    )
    call MessageNotify( "M", "gridset_init", "DelZ = %f", d=(/DelZ/)    )
    call MessageNotify( "M", "gridset_init", "NX = %d",   i=(/NX/)      )
    call MessageNotify( "M", "gridset_init", "NZ = %d",   i=(/NZ/)      )
    call MessageNotify( "M", "gridset_init", "SpcNum = %d", i=(/SpcNum/) )
    call MessageNotify( "M", "gridset_init", "MarginX = %d", i=(/MarginX/) )
    call MessageNotify( "M", "gridset_init", "MarginZ = %d", i=(/MarginZ/) )
    call MessageNotify( "M", "gridset_init", "DimXMin = %d", i=(/DimXMin/) )
    call MessageNotify( "M", "gridset_init", "DimXMax = %d", i=(/DimXMax/) )
    call MessageNotify( "M", "gridset_init", "DimZMin = %d", i=(/DimZMin/) )
    call MessageNotify( "M", "gridset_init", "DimZMax = %d", i=(/DimZMax/) )

  end subroutine gridset_init
  
end module gridset
