#!/usr/bin/env ruby

##################################################
=begin
=arare3j-basefig-make

  Ǿ gpview Υåѡ. 
  arare3j δܾ˴ؤ, 
    + ޤΥץå
    + ps, png ե뤪ӥ˥᡼ gif κ. 
      - ǥեȤǤ ps  gzip ǰ̤. ɬפʤ --notgz


== USAGE
 
  㤨, ʲΤ褦Ѥ. 

    % ./arare3j-basefig-make.rb  ncfile

  եϤˤ --dump ץꤹ

    % ./arare3j-basefig-make.rb --dump ncfile

  ¾ gpview ˤΤޤϤץ, --opt ǻꤹ

    % ./arare3j-basefig-make.rb  --opt "--itr 4 --noannotate" ncfile


== OPTION

    --aspect          : ޤΥڥ

    --opt             : gpview ˤΤޤϤ٤ץλ. 

    --delay           : ˥᡼ gif ݤ delay. 
                        ǥեȤ 40 

    --notgz           : ps  tar ǸǤ zip ʤ. 

    --dump            : ޤΥե

    --nocont          : 2 ץåȤ, 󥿡ʤ


== References

  + http://www.gfd-dennou.org/arch/dcl/dcl-5.3.1/README_pslib
  + http://www.gfd-dennou.org/arch/dcl/dcl-tips/dclpsedit.html


== HISTORY

  2006/01/04   K Sugiyama (created)

=end
##################################################
require "numru/ggraph"
require "getoptlong"
include NumRu

###
### 
###
parser = GetoptLong.new
parser.set_options(
                   ###    global option   ###
                   ['--aspect',      GetoptLong::REQUIRED_ARGUMENT],
                   ['--delay',       GetoptLong::REQUIRED_ARGUMENT],
                   ['--opt',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--dump',        GetoptLong::NO_ARGUMENT],
                   ['--nocont',      GetoptLong::NO_ARGUMENT],
                   ['--notgz',       GetoptLong::NO_ARGUMENT]
                   )
begin
  parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'" 
  end
rescue
  exit(1)
end


###
### Ѥ륳ޥɤӥץ
###

#gp ޥ
gpview   = "/usr/bin/gpview"
gpmaxmin = "| /usr/bin/gpmaxmin"  # ե륿Ȥ

#dcl Ϣ 
dclpsrmcm   = "/usr/bin/dclpsrmcm"
dclpsrot    = "/usr/bin/dclpsrot"
dclpsfont   = "/usr/bin/dclpsfont f=H lcntl=1 fact=7000"
dclpsmargin = "/usr/bin/dclpsmargin"
psout       = "dcl.ps"                # dcl νϤ ps ե̾

# gs Ϣ. ǲ٤ȥ
gsresolv = "90"
gssize   = "900x600"
gs  = "/usr/bin/gs -sDEVICE=pnmraw -q -dNOPAUSE -dSAFER  -sOutputFile=-" \
      +" -r"+gsresolv+" -g"+gssize

# imagemagic
pnmtopng = "/usr/bin/pnmtopng"
convert  = "/usr/bin/convert"

# tar
tar    = "/bin/tar zcf"
taropt = "--remove-files"

# rm
rm = "/bin/rm"


###
### ѿ
###

# ͤν
vars = ["ExnerBasicZ", 
        "PotTempBasicZ",
#        "CpBasicZ", 
        "DensBasicZ",   
        "VelSoundBasicZ",
        "TempBasicZ", 
        "PressBasicZ",  
        "MixRtVBasicZ", 
        "EffMolWtBasicZ"]
aspect= ""
wsn   = "--wsn 1"
opt   = "" 
delay = "-delay 40"  
sint  = ""
cint  = ""
fname = ARGV[0].sub(/\.nc/,"").sub(/@/,"_").sub(/=/,"").sub(/\,/,"_")

# ڥ
aspect = "--aspect"+" "+$OPT_aspect if $OPT_aspect

# ޤΥե
wsn = "--wsn 2"                     if $OPT_dump

# ¾ץ
opt = $OPT_opt                      if $OPT_opt

# delay
delay = "-delay"+" "+$OPT_delay     if $OPT_delay


###
### ޤν, ե
###
vars.each { |var| 

  # 
  maxmin= []

  # ϰϤλ. 
  # gpmaxmin ѤƺǾͤȺͤ
  varmaxmin = gpmaxmin+" "+ARGV[0]+"@"+var
  p varmaxmin
  fil = open(varmaxmin)
  fil.each { |line| 
    /["min"|"max"]=(\S+),\s+/ =~ line  # Ϸ̤ͤȺǾͤõ
    maxmin << $1.to_f if $1
  }
  p maxmin
  range = "--range"+" "+maxmin[1].to_s+":"+maxmin[0].to_s
  
  # ɤ, 󥿡饤
  ## gpmaxmin η̤ǾͤȺͤ
  del = maxmin[0] - maxmin[1]
  
  ## ʬ, 󥿡δֳ֤. ʬϺ 100 Ѥ. 
  sdel = del / 99.0
#  cdel = del / 10.0
  
  ## sint, cint 
  sint = "--sint"+" "+sdel.to_s 
  if ($OPT_nocont) 
    cint = "--nocont"
  else
#    cint = "--cint"+" "+cdel.to_s 
  end

  # ¹ԥޥɤκ, ¹
  gturl = ARGV[0]+"@"+var
  p gpview, gturl, range, aspect, wsn, sint, cint, opt
  view = gpview+" "+gturl+" "+range+" "+aspect+" "+wsn+" " \
         +sint+opt
#         +sint+" "+cint+" "+opt

  p view
  system (view)
  
  # ps --> png Ѵ
  if ($OPT_dump)
    psfile  = fname+"_"+var+".ps"
    pngfile = fname+"_"+var+".png"
    
    # dcl °ޥɤѤѴ
    dclps = dclpsrmcm+" "+psout+" | "+dclpsrot+" | "+dclpsfont+" | " \
            +dclpsmargin+" > "+psfile
    p dclps
    system (dclps)
    
    # ps ե png եѴ
    pspng = gs+" "+psfile+" -c quit| "+pnmtopng+" > "+pngfile
    p pspng
    system (pspng)

    #ݽ
    psrm = rm+" dcl.ps"
    system( psrm )
  end  
}

# ps ե밵
if ($OPT_dump)
  unless ($OPT_notgz)
    psfiles  = fname+"*.ps"
    tgzfile  = fname+"_basefig.tar.gz"
    
    # tar ե˸Ǥ
    pstar = tar+" "+tgzfile+" "+psfiles+" "+taropt
    p pstar
    system (pstar)
  end
end
