=begin JA

= 設定ファイルを用いた実験設定の変更

# * 杉山耕一朗 (sugiyama)
#   * $Id: catseye.rd,v 1.1 2014-02-26 07:09:53 sugiyama Exp $


本文書では設定ファイル(NAMELIST ファイル) を用いた実験設定の変更方法に
ついて記す. 

設定ファイルを変更した後の実際の計算実行の方法については「ごくらくdcpam5」
http://www.gfd-dennou.org/library/dcpam/dcpam5/dcpam5_latest/doc/gokuraku/
を参照されたい.

== 解像度を変更するには

解像度は, 設定ファイル(NAMELIST ファイル) に &gridset_nml,
&axesset_nml を用いて設定する. 

例えば設定ファイルに以下のように書かれている場合, x, y, z 方向の格子サ
イズは 50, 50, 50 であり, dx, dy, dz はそれぞれ 20 m (1000 / 50), 20 m, 
13 m (650 / 50) である.

    &gridset_nml
      xdim  = 50                 ! X 方向刻み点数
      ydim  = 50                 ! Y 方向刻み点数
      zdim  = 50                 ! Z 方向刻み点数
      NCMAX = 1                  ! 化学種の数
    /

    &axesset_nml
      Xmax  = 1.0d3             ! X 座標の終点
      Ymax  = 1.0d3             ! Y 座標の終点
      Zmax  = 6.5d2             ! Z 座標の終点
    /

解像度を 1/2 倍する場合は, 以下のように修正する. この場合, x, y, z 方向
の格子サイズは 100, 1, 100 であり, dx, dy, dz はそれぞれ, 10 m (1000 /
100), 10 m, 6.5 m (650 / 100) である.

    &gridset_nml
      xdim  = 100                ! X 方向刻み点数
      ydim  = 100                ! Y 方向刻み点数
      zdim  = 100                ! Z 方向刻み点数
      NCMAX = 1                  ! 化学種の数
    /

    &axesset_nml
      Xmax  = 1.0d3             ! X 座標の終点
      Ymax  = 1.0d3             ! Y 座標の終点
      Zmax  = 6.5d2             ! Z 座標の終点
    /

なお, 座標軸の下限は何も指定しない場合はゼロである. 例えば, 高度 350 m から
高度 650 m を計算する場合は, 

    &axesset_nml
      Xmax  = 1.0d3             ! X 座標の終点
      Ymax  = 1.0d3             ! Y 座標の終点
      Zmin  = 3.5d2             ! Z 座標の始点
      Zmax  = 6.5d2             ! Z 座標の終点
    /

とする. 


== 時間刻み・積分期間を変更するには

時間刻みや積分期間は, 設定ファイル(NAMELIST ファイル) に &timeset nml
を用いて設定する. deepconv では時間に関する情報は(({秒単位}))で設定する. 

例えば, 設定ファイルに以下のように設定されている場合, 長い時間ステップ
は 0.4 秒, 短い時間ステップは 0.01 秒, 積分時間は 400 秒である. 

    &timeset_nml
      DelTimeLong  = 0.4d0       !長いタイムステップ
      DelTimeShort = 1.0d-2      !短いタイムステップ(音波関連項)
      IntegPeriod  = 400.0d0     !積分時間 
      ... 
    /

これを積分時間 1000 秒にするためには以下のように変更する. 

    &timeset_nml
      DelTimeLong  = 0.4d0       !長いタイムステップ
      DelTimeShort = 1.0d-2      !短いタイムステップ(音波関連項)
      IntegPeriod  = 1000.0d0    !積分時間 
      ...
    /

deepconv では時間刻みを 2 つ設定する必要がある. 短い時間ステップは音波
に関連する項を解くために用いるものであり, それ以外の項は長い時間ステッ
プを用いる. そのため, 短い時間ステップは音波に対する CFL 条件を満たす必
要がある. deepconv 実行時の標準出力に CFL 条件に関する出力が含まれてい
るので, それをチェックすると良い.

    $ ./bin/arare_init-data -N=conf/arare-DensCurrent-dry_init.conf
                         :        
    *** MESSAGE [cflcheck] ***  Sound Wave Velocity = 346.9604303613247
    *** MESSAGE [cflcheck] ***  DelTimeShort = 0.10000000000000000E-01
    *** MESSAGE [cflcheck] ***  Courant number for DelTimeSort = 0.2453380731118955
                         :        
    ########## PREDICTION OF CALCULATION ###########
    Start Date             2014-02-27T12:22:28+09:00
    Current Date           2014-02-27T12:23:05+09:00
    Progress     50.00%  [************             ]
    Remaining CPU TIME      0.310000E+02
    Completion Date        2014-02-27T12:23:36+09:00
    *** MESSAGE [cflcheck] ***  Courant number of VelX for DelTimeLong = 0.93223408165580368
    *** MESSAGE [cflcheck] ***  Courant number of VelY for DelTimeLong = 0.
    *** MESSAGE [cflcheck] ***  Courant number of VelZ for DelTimeLong = 0.44468541992527427
                         :        
                         :        


== 物理定数・惑星に関する定数を変更するには

惑星に関する定数は, 設定ファイル(NAMELIST ファイル) に &constants nmlを
用いて設定する. 比熱と乾燥成分の分子量を決める方法には以下の 3 通りがあ
ります.


===比熱と分子量を陽に与える場合

重力加速度, 温位の基準圧力, 地表面温度・圧力, 乾燥成分の比熱と分子量を
以下のように与えます. この場合, (({定積比熱 (CvDry) や気体定数
(GasRDry) はモデル内部で計算されます})).

    &constants_nml
      Grav         = 9.8d0,        !重力             [m/s]
      PressBasis   = 1000.0d2,     !(温位の)基準圧力 [Pa]
      TempSfc      = 300.0d0,      !地表面温度       [K]
      PressSfc     = 1000.0d2,     !地表面圧力       [Pa]
      CpDry        = 1004.0d0,     !乾燥成分の比熱
      MolWtDry     = 0.029d0,      !乾燥成分の分子量
    /

モデルで実際に使われる値をチェックするためには deepconv の標準出力を
チェックするのが良いでしょう. CvDry や GasRDry の値も確認できます. 

    $ ./bin/arare_init-data -N=conf/arare-DensCurrent-dry_init.conf
                         :        
    *** MESSAGE [constants_init] ***  Grav = 9.800000000000000
    *** MESSAGE [constants_init] ***  PressBasis = 100000.
    *** MESSAGE [constants_init] ***  TempSfc = 300.
    *** MESSAGE [constants_init] ***  PressSfc = 100000.
    *** MESSAGE [constants_init] ***  CpDry    = 1004.
    *** MESSAGE [constants_init] ***  CpDryMol = 29.11600000000000
    *** MESSAGE [constants_init] ***  CvDry    = 717.3103448275862
    *** MESSAGE [constants_init] ***  GasRDry  = 286.6896551724137
    *** MESSAGE [constants_init] ***  MolWtDry = 0.2900000000000000
    *** MESSAGE [constants_init] ***  DayTime  = 86400.
                         :        


===比熱と気体定数を与える場合

重力加速度, 温位の基準圧力, 地表面温度・圧力, 乾燥成分の比熱と気体定数
を以下のように与えます. この場合, (({定積比熱や乾燥成分の分子量はモデル
内部で計算されます})). 

    &constants_nml
      Grav         = 9.8d0,        !重力             [m/s]
      PressBasis   = 1000.0d2,     !(温位の)基準圧力 [Pa]
      TempSfc      = 300.0d0,      !地表面温度       [K]
      PressSfc     = 1000.0d2,     !地表面圧力       [Pa]
      CpDry        = 1004.0d0,     !乾燥成分の比熱
      GasRDry      = 286.7d0,      !乾燥成分の気体定数
    /


===物質名とそのモル比を与える場合

重力加速度, 温位の基準圧力, 地表面温度・圧力, 乾燥成分に相当する物質と
モル比を以下のように与えます. 窒素 80 %, 酸素 20 % としています. (({定
積比熱, 定圧比熱, 乾燥成分の分子量はモデル内部で計算されます})).

    &constants_nml
      Grav         = 9.8d0,        !重力             [m/s]
      PressBasis   = 1000.0d2,     !(温位の)基準圧力 [Pa]
      TempSfc      = 300.0d0,      !地表面温度       [K]
      PressSfc     = 1000.0d2,     !地表面圧力       [Pa]
      SpcDrySymbol(1) = 'N2-g',    !乾燥成分の化学種名
      SpcDrySymbol(2) = 'O2-g',    !乾燥成分の化学種名
      SpcDryMolFr(1)  = 0.8d0,     !乾燥成分の存在度
      SpcDryMolFr(2)  = 0.2d0,     !乾燥成分の存在度
    /



== 出力設定を変更するには

解析用のヒストリデータの出力に関する設定は &gtool_historyauto_nml を編
集することで変更する. 以下では最低限の説明を行います. 詳細は ((<gtool5
チュートリアル集
|URL:http://www.gfd-dennou.org/library/gtool/gt5tutorial/>)) をご覧下さ
い.

例えば, ヒストリーデータの設定として以下が設定されているとします. 

    ! データ出力の全体設定
    !
    &gtool_historyauto_nml
       FilePrefix = "arare-catseye_" ! ファイルの接頭詞
       IntValue = 10.0,              ! 出力間隔の数値
       IntUnit = 'sec',              ! 出力間隔の単位
       AllOutput = .false.
    /
    !
    ! データ出力の個別設定
    !
    &gtool_historyauto_nml
      Name = 'PTemp, VelX, VelZ, Exner, Km',     ! 出力変数
      IntUnit = 'sec',                           ! 出力間隔の単位
    /
    &gtool_historyauto_nml
      Name = 'PTempAdv,PTempTurb',               ! 出力変数
      SpaceAverage = .true.,.true.,.false.
      IntUnit = 'sec',                           ! 出力間隔の単位
    /


それぞれの意味は, 以下の通りです. 出力する変数を増やす場合には, 変数名
を (({Name})) に追加して下さい. また, (({AllOutput})) を (({.true.}))
にすると, 全ての変数が出力されます.


    FilePrex
       (文字型) データのファイル名の接頭詞. 例えば"exp1-" と指定すれば, 変数
       "VelX" の出力ファイル名は"exp1-VelX.nc" となる. また, "data01/" のようにス
       ラッシュを含む文字列を指定することで, カレントディレクトリ以外の場所
       に出力するよう設定することも可能である.

    IntValue
       (実数型) 出力間隔の数値

    IntUnit
       (文字型) 出力間隔の単位. "sec", "min", "hour", "day", "month", "year" な
       どが使用可能である. 使用可能な単位の詳細については, gtool5 ライブラリ: 
       dc date types モジュール (http://www.gfd-dennou.org/library/gtool/gtool5/
       gtool5_current/doc/code_reference/classes/dc_date_types.html) の"Char-
       acters list for unit" を参照されたい.

    AllOutput
       (論理型) HistoryAutoAddVariable によってプログラム内で登録された
       変数を全て出力するためのフラグ. デフォルトではNAMELIST による変
       数ごとの個別出力設定に示すように, 変数は明示的に指定しない限り出
       力されませんが, この項目を ".true." とすることで, 全ての変数が出
       力されます. 

    Precision
       (文字型) データの精度. "oat" (単精度実数型), "double" (倍精度実数型), "int" (整数型) を指定可能

    Name
       (文字型) 出力する変数名. 複数指定する場合はカンマでつなげる. 

    SpaceAverage
       (論理型配列) 空間平均のフラグ. 配列の1 番目, 2 番目, 3 番目が, 経度, 緯
       度, 高度に対応する.



== リスタート計算を行うには

この節では, deepconv/arare5 でのリスタート方法について述べる. 
ここで言うリスタートとは, ある期間積分した後で, その最後の状態から
計算を再開することを指す. 

deepcnov/arare5 のリスタート計算は, 以下の手順により行う.

  * リスタートファイルの指定,
  * 計算再開時刻の指定.
  * 積分時間 / 積分終了時刻の指定.

つまり, 再計算のためには, それ以前の計算においてリスタートファイルを
出力しておく必要がある

=== リスタートファイルの出力のための設定 

リスタートファイルは以下のように指定することで出力される. この例では
200 秒毎にリスタートに必要な情報をリスタートファイルに格納する. 

    !!!
    !!!入出力ファイルに関する設定
    !!!
    &restartfileio_nml      
      ...
      OutputFile = "arare-catseys_restart.nc",  !生成するリスタートファイルの名称
    /

    !!!
    !!!積分時間に関する設定
    !!!
    &timeset_nml
      ... 
      DelTimeOutput = 200.0d0    !出力時間間隔
    /


=== リスタート計算を行うための設定

リスタート計算を行うためには, リスタートする時刻を決める必要がある. 
例えば, リスタートファイル名が input.nc であり, 

    % ncdump -v time input.nc
      netcdf input {
          ...
          double time(time) ;
                  time:long_name = "time" ;
                  time:units = "sec" ;
          ...
        time = 0, 199, 200, 399, 400 ;
    }

ならば, t = 200 sec もしくは t = 400 sec から計算をリスタートさせること
ができる.  (deepconv は時間積分に 2 level scheme を使っているので, リス
タートするためには時刻が 2 つ必要となる. 上記の例では, t = 199 sec と
t = 200 sec, t = 399 sec と t = 400 sec は組である). 


リスタート開始時刻が t = 400 sec, リスタートファイルが
arare-catseys_init.nc, 積分時間が 1000 sec の場合, 以下のように設定する.

    !!!
    !!!入出力ファイルに関する設定
    !!!
    &restartfileio_nml      
      InputFile  = "arare-catseys_init.nc", ! 入力に使うリスタートファイルの名称
      ...
    /

    !!!
    !!!積分時間に関する設定
    !!!
    &timeset_nml
      ... 
      RestartTime   = 400.0d0
      IntegPeriod   = 1000.0d0     !積分時間 
      ... 
    /



=end JA


=begin HTML
<hr />
<small>
  $Id: catseye.rd,v 1.1 2014-02-26 07:09:53 sugiyama Exp $
</small>
=end HTML

