!= Module advection_center4_std
!
! Authors::   ̰ϯ(SUGIYAMA Ko-ichiro)
! Version::   $Id: advection_center4_std.f90,v 1.4 2015/02/19 02:17:22 sugiyama Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2014. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]


module advection_center4_std
  !
  ! ή׻⥸塼. ʬʿѱ黻⥸塼. 
  !
  !   ή: 4 ʬ
  !   ͳȻ (4 ): 2 ʬ
  !
  ! ꡼ץեå, ήʬǷ׻뤿, 
  ! ͳȻɲäƤ. 
  !

  !⥸塼ɤ߹
  !
  use dc_types,   only : DP

  !ۤηػ
  !
  implicit none

  !°λ
  !
  private

  ! ѿ
  !
  real(DP), save :: NuHh  = 0.0d0         !ǮФǴη (ʿ)
  real(DP), save :: NuVh  = 0.0d0         !ǮФǴη (ľ)
  real(DP), save :: NuHm  = 0.0d0         !ư̤ФǴη (ʿ)
  real(DP), save :: NuVm  = 0.0d0         !ư̤ФǴη (ľ)
  character(*), parameter:: module_name = 'advection_center4_std'
                                          ! ⥸塼̾.
                                          ! Module name
  !public
  !
  public advection_center4_std_init
  public advection_center4_std_main

contains

  subroutine advection_center4_std_init( AlphaNDiff, NDiffRatio )
    !
    ! 롼
    !

    ! ⥸塼ɤ߹
    !
    use timeset,    only : DelTimeLong
    use axesset,    only : dx, dy, dz       ! ʻҴֳ
    use dc_message, only : MessageNotify
    use mpi_wrapper,only : myrank

    !ۤηػ
    !
    implicit none
    
    ! ѿ
    !
    real(DP), intent(in) :: AlphaNDiff  !ͳȻη. 
    real(DP), intent(in) :: NDiffRatio

    !-------------------------------------------------------------------
    ! ͳȻ
    !
    ! CReSS ޥ˥奢εҤ˽ä NuH, NuV .
    ! ư̤ǮФͳȻ礭Ѥ褦 NDiffRatio 褸Ƥ.
    ! 
    NuHh = AlphaNDiff * ( SQRT( dx * dy ) ** 4.0d0 ) / (2.0d0 * DelTimeLong)
    NuVh = AlphaNDiff * ( dz ** 4.0d0 ) / (2.0d0 * DelTimeLong)

    NuHm = NuHh * NDiffRatio
    NuVm = NuVh * NDiffRatio

    !-------------------------------------------------------------------
    ! 
    !
    if (myrank == 0) then 
      call MessageNotify( "M", module_name, "NuHh = %f", d=(/NuHh/) )
      call MessageNotify( "M", module_name, "NuVh = %f", d=(/NuVh/) )
      call MessageNotify( "M", module_name, "NuHm = %f", d=(/NuHm/) )
      call MessageNotify( "M", module_name, "NuVm = %f", d=(/NuVm/) )
    end if

  end subroutine advection_center4_std_init

!!!------------------------------------------------------------------------!!!
  
  subroutine advection_center4_std_main(    &
    & pyz_VelXB,    pyz_VelXN,          & ! (in)
    & xqz_VelYB,    xqz_VelYN,          & ! (in)
    & xyr_VelZB,    xyr_VelZN,          & ! (in)
    & xyz_PTempB,   xyz_PTempN,         & ! (in)
    & xyz_ExnerB,   xyz_ExnerN,         & ! (in)
    & xyzf_QMixB,   xyzf_QMixN,         & ! (in)
    & xyz_KmB,      xyz_KmN,            & ! (in)
    & pyz_VelXAdv,  pyz_VelXnDiff,      & !(out)
    & xqz_VelYAdv,  xqz_VelYnDiff,      & !(out)
    & xyr_VelZAdv,  xyr_VelZnDiff,      & !(out)
    & xyz_PTempAdv, xyz_PTempNDiff,     & !(out)
    & xyz_ExnerAdv, xyz_ExnerNDiff,     & !(out)
    & xyzf_QMixAdv, xyzf_QMixNDiff,     & !(out)
    & xyz_KmAdv,    xyz_KmNDiff         & !(out)
    & )
    ! 
    ! ή׻
    !
    !   ή: 4 ʬ
    !   ͳȻ (4 ): 2 ʬ
    !
    ! ꡼ץեå, ήʬǷ׻뤿, 
    ! ͳȻɲäƤ. 
    !

    !⥸塼ɤ߹
    !
    use dc_types, only: DP
    use gridset, only : imin,            &! x β
      &                 imax,            &! x ξ
      &                 jmin,            &! y β
      &                 jmax,            &! y ξ
      &                 kmin,            &! z β
      &                 kmax,            &! z ξ
      &                 ncmax
    use basicset,only : xyz_PTempBZ,    & ! ̤δܾ
      &                 xyz_ExnerBZ,    & ! ̤δܾ
      &                 xyzf_QMixBZ       ! δܾ
    use axesset, only : pyz_xyz, pyz_pqz, pqz_xqz, pyz_pyr, pyr_xyr, &
      &                 xqz_pqz, pqz_pyz, xqz_xyz, xqz_xqr, xqr_xyr, &
      &                 xyr_pyr, pyr_pyz, xyr_xqr, xqr_xqz, xyr_xyz, &
      &                 xyz_pyz, xyz_xqz, xyz_xyr
    use xyz_deriv_c4_module, &
      &          only : xyz_c4dx_pyz, pqz_c4dy_pyz, pyr_c4dz_pyz, &
      &                 pqz_c4dx_xqz, xyz_c4dy_xqz, xqr_c4dz_xqz, &
      &                 pyr_c4dx_xyr, xqr_c4dy_xyr, xyz_c4dz_xyr, & 
      &                 pyz_c4dx_xyz, xqz_c4dy_xyz, xyr_c4dz_xyz
    use xyz_deriv_module, &
      &          only : pyz_dx_xyz, xyz_dx_pyz, pyz_dy_pqz, &
      &                 pqz_dy_pyz, pyz_dz_pyr, pyr_dz_pyz, &
      &                 xqz_dx_pqz, pqz_dx_xqz, xqz_dy_xyz, &
      &                 xyz_dy_xqz, xqz_dz_xqr, xqr_dz_xqz, &
      &                 xyr_dx_pyr, pyr_dx_xyr, xyr_dy_xqr, &
      &                 xqr_dy_xyr, xyr_dz_xyz, xyz_dz_xyr, &
      &                 xyz_dx_pyz, pyz_dx_xyz, xyz_dy_xqz, &
      &                 xqz_dy_xyz, xyz_dz_xyr, xyr_dz_xyz

    ! ۤηػ
    !
    implicit none

    ! 
    !
    real(DP), intent(in)    :: pyz_VelXB(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: pyz_VelXN(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xqz_VelYB(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xqz_VelYN(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyr_VelZB(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyr_VelZN(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(in)    :: xyz_PTempB(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyz_PTempN(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyz_ExnerB(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyz_ExnerN(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyzf_QMixB(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP), intent(in)    :: xyzf_QMixN(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP), intent(in)    :: xyz_KmB(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyz_KmN(imin:imax,jmin:jmax,kmin:kmax)

    real(DP), intent(out)   :: pyz_VelXAdv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)   :: xqz_VelYAdv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)   :: xyr_VelZAdv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)   :: xyz_KmAdv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)   :: xyz_ExnerAdv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)   :: xyz_PTempAdv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)   :: xyzf_QMixAdv(imin:imax,jmin:jmax,kmin:kmax,1:ncmax)
    real(DP), intent(out)   :: pyz_VelXnDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)   :: xqz_VelYnDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)   :: xyr_VelZnDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)   :: xyz_KmNDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)   :: xyz_ExnerNDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)   :: xyz_PTempNDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)   :: xyzf_QMixNDiff(imin:imax,jmin:jmax,kmin:kmax,1:ncmax)

    real(DP)                :: xyz_VarB(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)                :: xyz_VarN(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)                :: xyzf_VarB(imin:imax,jmin:jmax,kmin:kmax,1:ncmax)
    real(DP)                :: xyzf_VarN(imin:imax,jmin:jmax,kmin:kmax,1:ncmax)

    integer                 :: f


    !------------------------------------------------------------------------
    ! X ®
    !

    ! advection
    !
    pyz_VelXAdv =                                                      &
      & - pyz_VelXN * pyz_xyz( xyz_c4dx_pyz( pyz_VelXN ) )             &
      & - pyz_pqz( pqz_xqz( xqz_VelYN ) * pqz_c4dy_pyz( pyz_VelXN ) )  &
      & - pyz_pyr( pyr_xyr( xyr_VelZN ) * pyr_c4dz_pyz( pyz_VelXN ) )

    ! Numerical diffusion term 
    !
    pyz_VelXnDiff =                                                             &
      & - NuHm * ( pyz_dx_xyz(xyz_dx_pyz(pyz_dx_xyz(xyz_dx_pyz( pyz_VelXB ))))) &
      & - NuHm * ( pyz_dy_pqz(pqz_dy_pyz(pyz_dy_pqz(pqz_dy_pyz( pyz_VelXB ))))) &
      & - NuVm * ( pyz_dz_pyr(pyr_dz_pyz(pyz_dz_pyr(pyr_dz_pyz( pyz_VelXB )))))    

    !------------------------------------------------------------------------
    ! Y ®
    !

    ! advection
    !
    xqz_VelYAdv =                                                      &
      & - xqz_pqz( pqz_pyz( pyz_VelXN ) * pqz_c4dx_xqz( xqz_VelYN ) )  &
      & - xqz_VelYN * xqz_xyz( xyz_c4dy_xqz( xqz_VelYN ) )             &
      & - xqz_xqr( xqr_xyr( xyr_VelZN ) * xqr_c4dz_xqz( xqz_VelYN ) )

    ! Numerical diffusion term
    !
    xqz_VelYnDiff =                                                             &
      & - NuHm * ( xqz_dx_pqz(pqz_dx_xqz(xqz_dx_pqz(pqz_dx_xqz( xqz_VelYB ))))) &
      & - NuHm * ( xqz_dy_xyz(xyz_dy_xqz(xqz_dy_xyz(xyz_dy_xqz( xqz_VelYB ))))) &
      & - NuVm * ( xqz_dz_xqr(xqr_dz_xqz(xqz_dz_xqr(xqr_dz_xqz( xqz_VelYB )))))

    !------------------------------------------------------------------------
    ! Z ®
    !

    ! Advection term
    !
    xyr_VelZAdv =                                                       &
      & - xyr_pyr( pyr_pyz( pyz_VelXN ) * pyr_c4dx_xyr( xyr_VelZN ) )   &
      & - xyr_xqr( xqr_xqz( xqz_VelYN ) * xqr_c4dy_xyr( xyr_VelZN ) )   &
      & - xyr_VelZN * xyr_xyz( xyz_c4dz_xyr( xyr_VelZN ) )
       
    ! Numerical diffusion term
    !
    xyr_VelZnDiff =                                                             &
      & - NuHm * ( xyr_dx_pyr(pyr_dx_xyr(xyr_dx_pyr(pyr_dx_xyr( xyr_VelZB ))))) &
      & - NuHm * ( xyr_dy_xqr(xqr_dy_xyr(xyr_dy_xqr(xqr_dy_xyr( xyr_VelZB ))))) & 
      & - NuVm * ( xyr_dz_xyz(xyz_dz_xyr(xyr_dz_xyz(xyz_dz_xyr( xyr_VelZB )))))
        
    !------------------------------------------------------------------------
    ! 
    !

    ! ̤׻
    !
    xyz_VarB = xyz_PTempB 
    xyz_VarN = xyz_PTempN + xyz_PTempBZ

    ! Advection term
    !
    xyz_PTempAdv =                                         &
      & - xyz_pyz( pyz_VelXN * pyz_c4dx_xyz( xyz_VarN ) )  &
      & - xyz_xqz( xqz_VelYN * xqz_c4dy_xyz( xyz_VarN ) )  &
      & - xyz_xyr( xyr_VelZN * xyr_c4dz_xyz( xyz_VarN ) )  
    
    ! numerical diffusion term
    !
    xyz_PTempNDiff =                                                           &
      &  - NuHh * (xyz_dx_pyz(pyz_dx_xyz(xyz_dx_pyz(pyz_dx_xyz( xyz_VarB ))))) &
      &  - NuHh * (xyz_dy_xqz(xqz_dy_xyz(xyz_dy_xqz(xqz_dy_xyz( xyz_VarB ))))) &
      &  - NuVh * (xyz_dz_xyr(xyr_dz_xyz(xyz_dz_xyr(xyr_dz_xyz( xyz_VarB ))))) 

    !------------------------------------------------------------------------
    ! ʡؿ
    !

    ! ̤׻
    !
    xyz_VarB = xyz_ExnerB 
    xyz_VarN = xyz_ExnerN + xyz_ExnerBZ

    ! Advection term
    !
    xyz_ExnerAdv =                                         &
      & - xyz_pyz( pyz_VelXN * pyz_c4dx_xyz( xyz_VarN ) )  &
      & - xyz_xqz( xqz_VelYN * xqz_c4dy_xyz( xyz_VarN ) )  &
      & - xyz_xyr( xyr_VelZN * xyr_c4dz_xyz( xyz_VarN ) )  

    ! numerical diffusion term
    !
    xyz_ExnerNDiff =                                                           &
      &  - NuHh * (xyz_dx_pyz(pyz_dx_xyz(xyz_dx_pyz(pyz_dx_xyz( xyz_VarB ))))) &
      &  - NuHh * (xyz_dy_xqz(xqz_dy_xyz(xyz_dy_xqz(xqz_dy_xyz( xyz_VarB ))))) &
      &  - NuVh * (xyz_dz_xyr(xyr_dz_xyz(xyz_dz_xyr(xyr_dz_xyz( xyz_VarB )))))     
    
    !------------------------------------------------------------------------
    ! ήȻ
    !

    ! ܾʤ
    !
    xyz_VarB = xyz_KmB
    xyz_VarN = xyz_KmN

    ! Advection term
    !
    xyz_KmAdv =                                            &
      & - xyz_pyz( pyz_VelXN * pyz_c4dx_xyz( xyz_VarN ) )  &
      & - xyz_xqz( xqz_VelYN * xqz_c4dy_xyz( xyz_VarN ) )  &
      & - xyz_xyr( xyr_VelZN * xyr_c4dz_xyz( xyz_VarN ) )  

    ! numerical diffusion term
    !
    xyz_KmNDiff =                                                              &
      &  - NuHh * (xyz_dx_pyz(pyz_dx_xyz(xyz_dx_pyz(pyz_dx_xyz( xyz_VarB ))))) &
      &  - NuHh * (xyz_dy_xqz(xqz_dy_xyz(xyz_dy_xqz(xqz_dy_xyz( xyz_VarB ))))) &
      &  - NuVh * (xyz_dz_xyr(xyr_dz_xyz(xyz_dz_xyr(xyr_dz_xyz( xyz_VarB ))))) 
    
    !---------------------------------------------------------------------
    ! 
    ! 
    
    ! ̤׻
    !
    xyzf_VarB = xyzf_QMixB 
    xyzf_VarN = xyzf_QMixN + xyzf_QMixBZ

    do f = 1, ncmax

      ! Advection term
      !
      xyzf_QMixAdv(:,:,:,f) = &
        & - xyz_pyz( pyz_VelXN * pyz_c4dx_xyz( xyzf_VarN(:,:,:,f) ) ) &
        & - xyz_xqz( xqz_VelYN * xqz_c4dy_xyz( xyzf_VarN(:,:,:,f) ) ) &
        & - xyz_xyr( xyr_VelZN * xyr_c4dz_xyz( xyzf_VarN(:,:,:,f) ) ) 
      
      ! numerical diffusion term
      !
!      xyzf_QMixNDiff(:,:,:,f) = 0.0d0
!      xyzf_QMixNDiff(:,:,:,f) = &
!        &  - NuHh * (xyz_dx_pyz(pyz_dx_xyz(xyz_dx_pyz(pyz_dx_xyz( xyzf_VarB(:,:,:,f) ))))) &
!        &  - NuHh * (xyz_dy_xqz(xqz_dy_xyz(xyz_dy_xqz(xqz_dy_xyz( xyzf_VarB(:,:,:,f) ))))) &


      xyzf_QMixNDiff(:,:,:,f) = &
        &  - NuHh * (xyz_dx_pyz(pyz_dx_xyz(xyz_dx_pyz(pyz_dx_xyz( xyzf_VarB(:,:,:,f) ))))) &
        &  - NuHh * (xyz_dy_xqz(xqz_dy_xyz(xyz_dy_xqz(xqz_dy_xyz( xyzf_VarB(:,:,:,f) ))))) &
        &  - NuVh * (xyz_dz_xyr(xyr_dz_xyz(xyz_dz_xyr(xyr_dz_xyz( xyzf_VarB(:,:,:,f) )))))   
  
    end do
    
  end subroutine advection_center4_std_main
  
end module advection_center4_std
