!= Module DynamicsHEVI
!
! Authors::   ̰ϯ(SUGIYAMA Ko-ichiro), ODAKA Masatsugu 
! Version::   $Id: dynamics_hevi_v2.f90,v 1.8 2014/07/08 00:58:06 sugiyama Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]


module DynamicsHEVI
  !
  ! ϳإ: ʬʿѱ黻⥸塼Ȥ鷺˽񤭲. 
  !           ׻®٤ v1  2 ܰʾᤤ, ǥХåϤˤ. 
  !
  ! Note: 
  !  * ʡؿζΥˤ, 2 ٤Υۤ
  !    ѤƤ뤿, Ϲη׻ץˤ
  !    differentiate_center4 ⥸塼ꤹ뤳ȤϤǤʤΤ.
  !


  !⥸塼ɤ߹
  use dc_types,   only : DP, STRING
  use dc_iounit,  only : FileOpen
  use dc_message, only : MessageNotify
  use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut 

  use mpi_wrapper,only: myrank
  use gridset, only: &
    &                 imin,            &! x β
    &                 imax,            &! x ξ
    &                 jmin,            &! y β
    &                 jmax,            &! y ξ
    &                 kmin,            &! z β
    &                 kmax,            &! z ξ
    &                 nx,              &! x ʪΰξ
    &                 ny,              &! x ʪΰξ
    &                 nz,              &! y ʪΰξ
    &                 ncmax,           &! ʪ
    &                 FlagCalc3D
  use constants,only: CpDry             ! ʬǮ
  use composition, only: SpcWetSymbol
  use timeset, only:  DelTimeShort, DelTimeLong, TimeN
  use axesset, only:  dx, dy, dz       ! ʻҴֳ
  use basicset, only: xyz_VelSW,       &!ܾβ® 
    &                 xyz_VelSoundBZ,  &!ܾβ® 
    &                 xyz_DensBZ,      &!ܾ̩
    &                 xyz_PTempBZ,     &!ܾβ
    &                 xyz_VPTempBZ,    &!ܾβ
    &                 pyz_VPTempBZ,    &!ܾβ
    &                 xqz_VPTempBZ,    &!ܾβ
    &                 xyr_VPTempBZ,    &!ܾβ
    &                 xyz_ExnerBZ,     &
    &                 xyzf_QMixBZ,     &
    &                 xyr_QMixBZPerMolWt, &
    &                 xyr_QMixBZ, xyz_EffMolWtBZ   
  use setmargin,only: SetMargin_xyzf, SetMargin_xyz, &
    &                 SetMargin_pyz, SetMargin_xqz, SetMargin_xyr
  use fillnegative, only: FillNegativeQMix
  use namelist_util, only: namelist_filename

  !ۤηػ
  implicit none

  !°λ
  private
  
  real(DP), save         :: beta  = 1.0d0         !󥯥˥륽ˡʤ 0.5
                                                  !ˡʤ 1

  integer, save          :: N = 10                !/μ, ˡ
  integer, save          :: M = 10                !ȿ
  integer, save          :: NUD = 1               !ξ廰ʬ
  integer, save          :: NLD = 1               !βʬ
  integer, save          :: NAL = 1               !LU ʬη L ˡ
  integer, save          :: NA = 3                !NUD + NLD + 1

  real(DP), allocatable, save :: xyz_F1BZ(:,:,:)            !η׻Ѥ
  real(DP), allocatable, save :: xyr_CpVPTempBZ(:,:,:)      !η׻Ѥ
  real(DP), allocatable, save :: xyr_CpDensVPTemp2BZ(:,:,:) !η׻Ѥ
  real(DP), allocatable, save :: xyr_DensVPTempBZ(:,:,:)    !η׻Ѥ

  real(DP), allocatable, save :: A(:)             !гʬ
  real(DP), allocatable, save :: B(:)             !ξ廰ʬ
  real(DP), allocatable, save :: C(:)             !βʬ
  real(DP), allocatable, save :: AL1(:)           !LU ʬη L (1 )
  integer,  allocatable, save :: IP(:)            !ʬԥܥåȸ򴹤ξǼ

  real(DP), save :: AlphaH = 0.0d0                !ȸθ그 (ʿ)
  real(DP), save :: AlphaV = 0.0d0                !ȸθ그 (ľ)
  real(DP), save :: NuHh  = 0.0d0                 !ǮФǴη (ʿ)
  real(DP), save :: NuVh  = 0.0d0                 !ǮФǴη (ľ)
  real(DP), save :: NuHm  = 0.0d0                 !ư̤ФǴη (ʿ)
  real(DP), save :: NuVm  = 0.0d0                 !ư̤ФǴη (ľ)
  real(DP), save :: NuHh2  = 0.0d0                !ǮФǴη (ʿ, 2 )
  real(DP), save :: NuVh2  = 0.0d0                !ǮФǴη (ľ, 2 )
  real(DP), save :: NuHm2  = 0.0d0                !ư̤ФǴη (ʿ, 2 )
  real(DP), save :: NuVm2  = 0.0d0                !ư̤ФǴη (ľ, 2 )

  character(*), parameter:: module_name = 'DynamicHEVI'
                                                  ! ⥸塼̾.
                                                  ! Module name
  real(DP), save :: FactorBuoyTemp    = 1.0d0     ! (٤δͿ) ̵ͭ
                                                  !θʤͤ򥼥ˤ.
  real(DP), save :: FactorBuoyMolWt   = 1.0d0     ! (ʬ̸) ̵ͭ
                                                  !θʤͤ򥼥ˤ.
  real(DP), save :: FactorBuoyLoading = 1.0d0     ! (ٽŸ) ̵ͭ
                                                  !θʤͤ򥼥ˤ.

  !public 
  public Dynamics_Init
  public Dynamics_Long_forcing
  public Dynamics_Short_integrate
  public Dynamics_Long_integrate
  public Dynamics2D_Long_forcing
  public Dynamics2D_Short_integrate

contains

  subroutine Dynamics_Init

    !ۤηػ
    implicit none
    
    real(DP)  :: DelXMin, DelYMin, DelZMin
    real(DP)  :: AlphaSound = 5.0d-2  !ȸη (ģͽ̺49 )
    real(DP)  :: AlphaNDiff = 1.0d-3  !4οͳȻη. CReSS ޥ˥奢
    real(DP)  :: NDiffRatio = 1.0d0   !®٤ФǴ夲Ͽ 1 ʾˤ. 
    integer   :: unit                 !ֹ

    !-------------------------------------------------------------------
    ! Namelist 
    !
    NAMELIST /Dynamics_nml/                                    &
         & AlphaSound, AlphaNDiff, NDiffRatio, beta,           &
         & FactorBuoyTemp, FactorBuoyMolWt, FactorBuoyLoading

    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=dynamics_nml)
    close(unit)
   
    !-------------------------------------------------------------------
    ! ȸθ그
    ! 
    ! ģͽ̺ 49 p53 ˽, ʿȱľȤʬƹͤ. 
    ! ʤ, 2 ׻ξˤ DelY ˰¸ʤ褦ˤ. 
    !
    DelXMin = dx
    DelYMin = dy
    DelZMin = dz
    if ( FlagCalc3D ) then 
      AlphaH = AlphaSound * ( Min(DelXMin * DelXMin, DelYMin * DelYMin) ) / DelTimeShort
      AlphaV = AlphaSound * ( Min(DelXMin * DelXMin, DelYMin * DelYMin, DelZMin * DelZMin) ) / DelTimeShort
    else
      AlphaH = AlphaSound * ( DelXMin * DelXMin ) / DelTimeShort
      AlphaV = AlphaSound * ( Min(DelXMin * DelXMin, DelZMin * DelZMin) ) / DelTimeShort
    end if

    !-------------------------------------------------------------------
    ! ͳȻ
    !
    ! CReSS ޥ˥奢εҤ˽ä NuH, NuV .
    ! ư̤ǮФͳȻ礭Ѥ褦 NDiffRatio 褸Ƥ.
    ! 
    if ( FlagCalc3D ) then 
      NuHh = AlphaNDiff * ( SQRT(DelXMin*DelYMin) ** 4.0d0 ) / (2.0d0 * DelTimeLong)
    else
      NuHh = AlphaNDiff * ( DelXMin ** 4.0d0 ) / (2.0d0 * DelTimeLong)
    end if
    NuVh = AlphaNDiff * ( DelZMin ** 4.0d0 ) / (2.0d0 * DelTimeLong)

    NuHm = NuHh * NDiffRatio
    NuVm = NuVh * NDiffRatio

    !-------------------------------------------------------------------
    ! 
    !
    if (myrank == 0) then 
      call MessageNotify( "M", module_name, "Alpha = %f", d=(/Alpha/) )
      call MessageNotify( "M", module_name, "NuHh = %f", d=(/NuHh/) )
      call MessageNotify( "M", module_name, "NuVh = %f", d=(/NuVh/) )
      call MessageNotify( "M", module_name, "NuHm = %f", d=(/NuHm/) )
      call MessageNotify( "M", module_name, "NuVm = %f", d=(/NuVm/) )
      call MessageNotify( "M", module_name, "FactorBuoyTemp = %f", d=(/FactorBuoyTemp/) )
      call MessageNotify( "M", module_name, "FactorBuoyMolWt = %f", d=(/FactorBuoyMolWt/) )
      call MessageNotify( "M", module_name, "FactorBuoyLoading = %f", d=(/FactorBuoyLoading/) )
    end if

    ! ľˡѤ뤿, νԤ. 
    !
    call Dynamics_VI_init

    ! tendency ν
    !
    call Dynamics_Tendency_output

  end subroutine Dynamics_Init


  subroutine Dynamics_Long_forcing(   &
    & pyz_VelXBl,  pyz_VelXNl,        & ! (in)
    & xqz_VelYBl,  xqz_VelYNl,        & ! (in)
    & xyr_VelZBl,  xyr_VelZNl,        & ! (in)
    & xyz_PTempBl, xyz_PTempNl,       & ! (in)
    & xyz_ExnerBl, xyz_ExnerNl,       & ! (in)
    & xyzf_QMixBl, xyzf_QMixNl,       & ! (in)
    & xyz_KmBl,    xyz_KmNl,          & ! (in)
    & pyz_DVelXDtNl,                  & ! (inout)
    & xqz_DVelYDtNl,                  & ! (inout)
    & xyr_DVelZDtNl,                  & ! (inout)
    & xyz_DPTempDtNl,                 & ! (inout)
    & xyz_DExnerDtNl,                 & ! (inout)
    & xyzf_DQMixDtNl,                 & ! (inout)
    & xyz_DKmDtNl                     & ! (inout)
    & )

    implicit none

    real(DP), intent(in)    :: pyz_VelXBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: pyz_VelXNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xqz_VelYBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xqz_VelYNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyr_VelZBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyr_VelZNl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(in)    :: xyz_PTempBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyz_PTempNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyz_ExnerBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyz_ExnerNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyzf_QMixBl(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP), intent(in)    :: xyzf_QMixNl(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP), intent(in)    :: xyz_KmBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyz_KmNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout) :: pyz_DVelXDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout) :: xqz_DVelYDtNl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(inout) :: xyr_DVelZDtNl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(inout) :: xyz_DPTempDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout) :: xyz_DExnerDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout) :: xyzf_DQMixDtNl(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP), intent(inout) :: xyz_DKmDtNl(imin:imax,jmin:jmax,kmin:kmax)

    real(DP)             :: pyz_Adv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: pyz_nDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xqz_Adv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xqz_nDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_Adv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_nDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_BuoyT(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_BuoyM(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_BuoyD(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyz_Adv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyz_nDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyzf_Adv(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP)             :: xyzf_nDiff(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP)             :: xyz_PTempAll(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyzf_QMixAll(imin:imax,jmin:jmax,kmin:kmax,1:ncmax)

    integer              :: f


    !--------------------------------------------------------------------
    ! ήȻ

    ! ήӿͳȻ
    !
    call AdvC4_nDiff_xyz( xyz_KmBl, xyz_KmNl ) !(IN)
    
    ! tendency ι
    !
    xyz_DKmDtNl = xyz_DKmDtNl + xyz_Adv + xyz_nDiff
    
    call HistoryAutoPut(TimeN, 'KmAdv',   xyz_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'KmNDiff', xyz_nDiff(1:nx,1:ny,1:nz))

    !--------------------------------------------------------------------
    ! 

    ! ήˤĤƤ, ܾθ.
    !
    xyz_PTempAll = xyz_PTempNl + xyz_PTempBZ
    call AdvC4_nDiff_xyz( xyz_PTempBl, xyz_PTempAll ) !(IN)

    ! tendency ι
    !
    xyz_DPTempDtNl = xyz_DPTempDtNl + xyz_Adv + xyz_nDiff
    
    ! output
    !
    call HistoryAutoPut(TimeN, 'PTempAdv',   xyz_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'PTempNDiff', xyz_nDiff(1:nx,1:ny,1:nz))

    !--------------------------------------------------------------------
    ! ʡؿ

    ! ήˤĤƤ, ܾθ.
    !
    xyz_ExnerAll = xyz_ExnerNl + xyz_ExnerBZ
    call AdvC4_nDiff_xyz( xyz_ExnerBl, xyz_ExnerAll ) !(IN)

    ! tendency ι
    !
    xyz_DExnerDtNl = xyz_DExnerDtNl + xyz_Adv + xyz_nDiff
    
    ! output
    !
    call HistoryAutoPut(TimeN, 'ExnerAdv',   xyz_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'ExnerNDiff', xyz_nDiff(1:nx,1:ny,1:nz))

    
    !--------------------------------------------------------------------
    ! 
    ! 

    ! ήˤĤƤ, ܾθ.
    !
    xyzf_QMixAll = xyzf_QMixNl + xyzf_QMixBZ
    call AdvC4_nDiff_xyzf( xyzf_QMixBl, xyzf_QMixAll ) !(IN)

    ! tendency ι    
    !
    xyzf_DQMixDtNl = xyzf_DQMixDtNl + xyzf_Adv + xyzf_nDiff
    
    ! output
    !
    do f = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(f))//'_Adv',   &
        & xyzf_Adv(1:nx,1:ny,1:nz,f))
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(f))//'_NDiff', &
        & xyzf_NDiff(1:nx,1:ny,1:nz,f))
    end do

    !------------------------------------------------------------------
    ! VelX, VelY, VelZ
    ! 

    ! ήࡦͳȻޤȤƷ׻
    !
    call AdvC4_nDiff_pyz_xqz_xyr

    ! tendency of VelX
    !
    pyz_DVelXDtNl = pyz_DVelXDtNl + pyz_Adv + pyz_NDiff

    call HistoryAutoPut(TimeN, 'VelXAdv',   pyz_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelXNDiff', pyz_nDiff(1:nx,1:ny,1:nz))

    ! tendency of VelY
    !
    xqz_DVelYDtNl = xqz_DVelYDtNl + xqz_Adv + xqz_NDiff

    call HistoryAutoPut(TimeN, 'VelYAdv',   xqz_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelYNDiff', xqz_nDiff(1:nx,1:ny,1:nz))

    ! Buoyancy 
    ! 
    call BuoyancyLong_xyr

    ! tendency of VelZ
    !
    xyr_DVelZDtNl = xyr_DVelZDtNl + xyr_Adv + xyr_NDiff          &
         &          + xyr_BuoyT * FactorBuoyTemp                 &
         &          + xyr_BuoyM * FactorBuoyMolWt                &
         &          + xyr_BuoyD * FactorBuoyLoading

    call HistoryAutoPut(TimeN, 'VelZAdv',   xyr_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelZNDiff', xyr_NDiff(1:nx,1:ny,1:nz))    
    call HistoryAutoPut(TimeN, 'VelZBuoyT', xyr_BuoyT(1:nx,1:ny,1:nz))    
    call HistoryAutoPut(TimeN, 'VelZBuoyM', xyr_BuoyM(1:nx,1:ny,1:nz))    
    call HistoryAutoPut(TimeN, 'VelZBuoyD', xyr_BuoyD(1:nx,1:ny,1:nz))    

  contains
    
    subroutine AdvC4_nDiff_pyz_xqz_xyr

      implicit none

      real(DP)              :: fct1, fct2
      integer               :: i, j, k
      
      ! ʬѤ뷸ͽ׻
      !
      fct1 = 9.0d0 / 8.0d0
      fct2 = 1.0d0 / 24.0d0
      
      ! ήη׻. ή: 4 濴ʬ
      ! 
      do k = kmin + 2, kmax - 2
        do j = jmin + 2, jmax - 2
          do i = imin + 2, imax - 2
            
            pyz_Adv(i,j,k) =                                                   &
              & - pyz_VelXNl(i,j,k)                                            &
              &   * (                                                          &
              &       fct1 * (   pyz_VelXNl(i+1,j,k) - pyz_VelXNl(i-1,j,k) )   &
              &     - fct2 * (   pyz_VelXNl(i+2,j,k) + pyz_VelXNl(i+1,j,k)     &
              &                - pyz_VelXNl(i-1,j,k) - pyz_VelXNl(i-2,j,k) )   &
              &     ) * 5.0d-1 / dx                                            &
              & - (                                                            &
              &   + ( xqz_VelYNl(i+1,j,k) + xqz_VelYNl(i,j,k) )                &  
              &     * (                                                        &  
              &         fct1 * ( pyz_VelXNl(i,j+1,k) - pyz_VelXNl(i,j,k)   )   &
              &       - fct2 * ( pyz_VelXNl(i,j+2,k) - pyz_VelXNl(i,j-1,k) )   &
              &       )                                                        &
              &   + ( xqz_VelYNl(i+1,j-1,k) + xqz_VelYNl(i,j-1,k) )            & 
              &     * (                                                        &
              &         fct1 * ( pyz_VelXNl(i,j,k)   - pyz_VelXNl(i,j-1,k) )   &
              &       - fct2 * ( pyz_VelXNl(i,j+1,k) - pyz_VelXNl(i,j-2,k) )   &
              &       )                                                        &
              &   ) * 2.5d-1 / dy                                              &
              & - (                                                            &
              &   + ( xyr_VelZNl(i+1,j,k) + xyr_VelZNl(i,j,k) )                & 
              &     * (                                                        &
              &         fct1 * ( pyz_VelXNl(i,j,k+1) - pyz_VelXNl(i,j,k)   )   &
              &       - fct2 * ( pyz_VelXNl(i,j,k+2) - pyz_VelXNl(i,j,k-1) )   &
              &       )                                                        &
              &   + ( xyr_VelZNl(i+1,j,k-1) + xyr_VelZNl(i,j,k-1) )            & 
              &     * (                                                        &
              &         fct1 * ( pyz_VelXNl(i,j,k)   - pyz_VelXNl(i,j,k-1) )   &
              &       - fct2 * ( pyz_VelXNl(i,j,k+1) - pyz_VelXNl(i,j,k-2) )   &
              &       )                                                        &
              &   ) * 2.5d-1 / dz
            
          end do
        end do
      end do
      
      pyz_Adv(imin:imin+1,:,:) = 0.0d0
      pyz_Adv(imax-1:imax,:,:) = 0.0d0
      pyz_Adv(:,jmin:jmin+1,:) = 0.0d0
      pyz_Adv(:,jmax-1:jmax,:) = 0.0d0
      pyz_Adv(:,:,kmin:kmin+1) = 0.0d0
      pyz_Adv(:,:,kmax-1:kmax) = 0.0d0
      
      do k = kmin + 2, kmax - 2
        do j = jmin + 2, jmax - 2
          do i = imin + 2, imax - 2
            
            xqz_Adv(i,j,k) =                                                   &
              & - (                                                            &
              &   + ( pyz_VelXNl(i,j+1,k) + pyz_VelXNl(i,j,k) )                & ! pqz_VelX(i,j,k) 
              &     * (                                                        &
              &         fct1 * ( xqz_VelYNl(i+1,j,k) - xqz_VelYNl(i,j,k)   )   &
              &       - fct2 * ( xqz_VelYNl(i+2,j,k) - xqz_VelYNl(i-1,j,k) )   &
              &       )                                                        &
              &   + ( pyz_VelXNl(i-1,j+1,k) + pyz_VelXNl(i-1,j,k) )            &  ! pqz_VelX(i-1,j,k)
              &     * (                                                        &
              &         fct1 * ( xqz_VelYNl(i,j,k)   - xqz_VelYNl(i-1,j,k) )   &
              &       - fct2 * ( xqz_VelYNl(i+1,j,k) - xqz_VelYNl(i-2,j,k) )   &
              &       )                                                        &
              &   ) * 2.5d-1 / dx                                              &
              & - xqz_VelYNl(i,j,k)                                            &
              &   * (                                                          &
              &       fct1 * (   xqz_VelYNl(i,j+1,k) - xqz_VelYNl(i,j-1,k) )   &
              &     - fct2 * (   xqz_VelYNl(i,j+2,k) + xqz_VelYNl(i,j+1,k)     &
              &                - xqz_VelYNl(i,j-1,k) - xqz_VelYNl(i,j-2,k) )   &
              &     ) * 5.0d-1 / dy                                            &
              & - (                                                            &
              &   + ( xyr_VelZNl(i,j+1,k) + xyr_VelZNl(i,j,k) )                & 
              &     * (                                                        &
              &         fct1 * ( xqz_VelYNl(i,j,k+1) - xqz_VelYNl(i,j,k)   )   &
              &       - fct2 * ( xqz_VelYNl(i,j,k+2) - xqz_VelYNl(i,j,k-1) )   &
              &       )                                                        &
              &   + ( xyr_VelZNl(i,j+1,k-1) + xyr_VelZNl(i,j,k-1) )            & 
              &     * (                                                        &
              &         fct1 * ( xqz_VelYNl(i,j,k)   - xqz_VelYNl(i,j,k-1) )   &
              &       - fct2 * ( xqz_VelYNl(i,j,k+1) - xqz_VelYNl(i,j,k-2) )   &
              &       )                                                        &
              &   ) * 2.5d-1 / dz
          end do
        end do
      end do
      
      xqz_Adv(imin:imin+1,:,:) = 0.0d0
      xqz_Adv(imax-1:imax,:,:) = 0.0d0
      xqz_Adv(:,jmin:jmin+1,:) = 0.0d0
      xqz_Adv(:,jmax-1:jmax,:) = 0.0d0
      xqz_Adv(:,:,kmin:kmin+1) = 0.0d0
      xqz_Adv(:,:,kmax-1:kmax) = 0.0d0
      
      do k = kmin + 2, kmax - 2
        do j = jmin + 2, jmax - 2
          do i = imin + 2, imax - 2
            
            xyr_Adv(i,j,k) =                                                   &
              & - (                                                            &
              &   + ( pyz_VelXNl(i,j,k+1) + pyz_VelXNl(i,j,k) )                & 
              &     * (                                                        &
              &         fct1 * ( xyr_VelZNl(i+1,j,k) - xyr_VelZNl(i,j,k)   )   &
              &       - fct2 * ( xyr_VelZNl(i+2,j,k) - xyr_VelZNl(i-1,j,k) )   &
              &       )                                                        &
              &   + ( pyz_VelXNl(i-1,j,k+1) + pyz_VelXNl(i-1,j,k) )            & 
              &     * (                                                        &
              &         fct1 * ( xyr_VelZNl(i,j,k)   - xyr_VelZNl(i-1,j,k) )   &
              &       - fct2 * ( xyr_VelZNl(i+1,j,k) - xyr_VelZNl(i-2,j,k) )   &
              &       )                                                        &
              &   ) * 2.5d-1 / dx                                              &
              & - (                                                            &
              &   + ( xqz_VelYNl(i,j,k+1) + xqz_VelYNl(i,j,k) )                & 
              &     * (                                                        &
              &         fct1 * ( xyr_VelZNl(i,j+1,k) - xyr_VelZNl(i,j,k)   )   &
              &       - fct2 * ( xyr_VelZNl(i,j+2,k) - xyr_VelZNl(i,j-1,k) )   &
              &       )                                                        &
              &   + ( xqz_VelYNl(i,j-1,k+1) + xqz_VelYNl(i,j-1,k) )            & 
              &     * (                                                        &
              &         fct1 * ( xyr_VelZNl(i,j,k)   - xyr_VelZNl(i,j-1,k) )   &
              &       - fct2 * ( xyr_VelZNl(i,j+1,k) - xyr_VelZNl(i,j-2,k) )   &
              &       )                                                        &
              &   ) * 2.5d-1 / dy                                              &
              & - xyr_VelZNl(i,j,k)                                            &
              &   * (                                                          &
              &       fct1 * (   xyr_VelZNl(i,j,k+1) - xyr_VelZNl(i,j,k-1) )   &
              &     - fct2 * (   xyr_VelZNl(i,j,k+2) + xyr_VelZNl(i,j,k+1)     &
              &                - xyr_VelZNl(i,j,k-1) - xyr_VelZNl(i,j,k-2) )   &
              &     ) * 5.0d-1 / dz
          end do
        end do
      end do
      
      xyr_Adv(imin:imin+1,:,:) = 0.0d0
      xyr_Adv(imax-1:imax,:,:) = 0.0d0
      xyr_Adv(:,jmin:jmin+1,:) = 0.0d0
      xyr_Adv(:,jmax-1:jmax,:) = 0.0d0
      xyr_Adv(:,:,kmin:kmin+1) = 0.0d0
      xyr_Adv(:,:,kmax-1:kmax) = 0.0d0
      
      do k = kmin + 2, kmax - 2
        do j = jmin + 2, jmax - 2
          do i = imin + 2, imax - 2
            
            pyz_nDiff(i,j,k) =                             &
              & - (                                        &
              &     + pyz_VelXBl(i+2,j,k)                  &
              &     + pyz_VelXBl(i-2,j,k)                  &
              &     - pyz_VelXBl(i+1,j,k) * 4.0d0          &
              &     - pyz_VelXBl(i-1,j,k) * 4.0d0          &
              &     + pyz_VelXBl(i  ,j,k) * 6.0d0          &
              &   ) * NuHm / ( dx ** 4.0d0 )               &
              & - (                                        &
              &     + pyz_VelXBl(i,j+2,k)                  &
              &     + pyz_VelXBl(i,j-2,k)                  &
              &     - pyz_VelXBl(i,j+1,k) * 4.0d0          &
              &     - pyz_VelXBl(i,j-1,k) * 4.0d0          &
              &     + pyz_VelXBl(i,j  ,k) * 6.0d0          &
              &   ) * NuHm / ( dy ** 4.0d0 )               &
              & - (                                        & 
              &     + pyz_VelXBl(i,j,k+2)                  &
              &     + pyz_VelXBl(i,j,k-2)                  &
              &     - pyz_VelXBl(i,j,k+1) * 4.0d0          &
              &     - pyz_VelXBl(i,j,k-1) * 4.0d0          &
              &     + pyz_VelXBl(i,j,k  ) * 6.0d0          &
              &   ) * NuVm / ( dz ** 4.0d0 )
            
          end do
        end do
      end do
      
      pyz_nDiff(imin:imin+1,:,:) = 0.0d0
      pyz_nDiff(imax-1:imax,:,:) = 0.0d0
      pyz_nDiff(:,jmin:jmin+1,:) = 0.0d0
      pyz_nDiff(:,jmax-1:jmax,:) = 0.0d0
      pyz_nDiff(:,:,kmin:kmin+1) = 0.0d0
      pyz_nDiff(:,:,kmax-1:kmax) = 0.0d0

      do k = kmin + 2, kmax - 2
        do j = jmin + 2, jmax - 2
          do i = imin + 2, imax - 2
            
            xqz_nDiff(i,j,k) =                             &
              & - (                                        &
              &     + xqz_VelYBl(i+2,j,k)                  &
              &     + xqz_VelYBl(i-2,j,k)                  &
              &     - xqz_VelYBl(i+1,j,k) * 4.0d0          &
              &     - xqz_VelYBl(i-1,j,k) * 4.0d0          &
              &     + xqz_VelYBl(i  ,j,k) * 6.0d0          &
              &   ) * NuHm / ( dx ** 4.0d0 )               &
              & - (                                        &
              &     + xqz_VelYBl(i,j+2,k)                  &
              &     + xqz_VelYBl(i,j-2,k)                  &
              &     - xqz_VelYBl(i,j+1,k) * 4.0d0          &
              &     - xqz_VelYBl(i,j-1,k) * 4.0d0          &
              &     + xqz_VelYBl(i,j  ,k) * 6.0d0          &
              &   ) * NuHm / ( dy ** 4.0d0 )               &
              & - (                                        & 
              &     + xqz_VelYBl(i,j,k+2)                  &
              &     + xqz_VelYBl(i,j,k-2)                  &
              &     - xqz_VelYBl(i,j,k+1) * 4.0d0          &
              &     - xqz_VelYBl(i,j,k-1) * 4.0d0          &
              &     + xqz_VelYBl(i,j,k  ) * 6.0d0          &
              &   ) * NuVm / ( dz ** 4.0d0 )
          end do
        end do
      end do
      
      xqz_nDiff(imin:imin+1,:,:) = 0.0d0
      xqz_nDiff(imax-1:imax,:,:) = 0.0d0
      xqz_nDiff(:,jmin:jmin+1,:) = 0.0d0
      xqz_nDiff(:,jmax-1:jmax,:) = 0.0d0
      xqz_nDiff(:,:,kmin:kmin+1) = 0.0d0
      xqz_nDiff(:,:,kmax-1:kmax) = 0.0d0
      
      do k = kmin + 2, kmax - 2
        do j = jmin + 2, jmax - 2
          do i = imin + 2, imax - 2
            
            xyr_nDiff(i,j,k) =                             &
              & - (                                        &
              &     + xyr_VelZBl(i+2,j,k)                  &
              &     + xyr_VelZBl(i-2,j,k)                  &
              &     - xyr_VelZBl(i+1,j,k) * 4.0d0          &
              &     - xyr_VelZBl(i-1,j,k) * 4.0d0          &
              &     + xyr_VelZBl(i  ,j,k) * 6.0d0          &
              &   ) * NuHm / ( dx ** 4.0d0 )               &
              & - (                                        &
              &     + xyr_VelZBl(i,j+2,k)                  &
              &     + xyr_VelZBl(i,j-2,k)                  &
              &     - xyr_VelZBl(i,j+1,k) * 4.0d0          &
              &     - xyr_VelZBl(i,j-1,k) * 4.0d0          &
              &     + xyr_VelZBl(i,j  ,k) * 6.0d0          &
              &   ) * NuHm / ( dy ** 4.0d0 )               &
              & - (                                        &
              &     + xyr_VelZBl(i,j,k+2)                  &
              &     + xyr_VelZBl(i,j,k-2)                  &
              &     - xyr_VelZBl(i,j,k+1) * 4.0d0          &
              &     - xyr_VelZBl(i,j,k-1) * 4.0d0          &
              &     + xyr_VelZBl(i,j,k  ) * 6.0d0          &
              &   ) * NuVm / ( dz ** 4.0d0 )
          end do
        end do
      end do
      
      xyr_nDiff(imin:imin+1,:,:) = 0.0d0
      xyr_nDiff(imax-1:imax,:,:) = 0.0d0
      xyr_nDiff(:,jmin:jmin+1,:) = 0.0d0
      xyr_nDiff(:,jmax-1:jmax,:) = 0.0d0
      xyr_nDiff(:,:,kmin:kmin+1) = 0.0d0
      xyr_nDiff(:,:,kmax-1:kmax) = 0.0d0
      
    end subroutine AdvC4_nDiff_pyz_xqz_xyr
    
    
    subroutine AdvC4_nDiff_xyz( xyz_VarBl, xyz_VarNl )
      
      implicit none
      
      real(DP), intent(in)  :: xyz_VarBl(imin:imax,jmin:jmax,kmin:kmax)
      real(DP), intent(in)  :: xyz_VarNl(imin:imax,jmin:jmax,kmin:kmax)
      
      real(DP)              :: fct1, fct2
      integer               :: i, j, k
      
      ! ʬѤ뷸ͽ׻
      !
      fct1 = 9.0d0 / 8.0d0
      fct2 = 1.0d0 / 24.0d0

      ! ήη׻. ή: 4 濴ʬ
      ! 
      do k = kmin + 2, kmax - 2
        do j = jmin + 2, jmax - 2
          do i = imin + 2, imax - 2
            
            xyz_Adv(i,j,k) =                                                  &
              & - (                                                           &
              &      pyz_VelXNl(i,j,k)                                        &
              &        * (                                                    &
              &            fct1 * ( xyz_VarNl(i+1,j,k) - xyz_VarNl(i,j,k)   ) &
              &          - fct2 * ( xyz_VarNl(i+2,j,k) - xyz_VarNl(i-1,j,k) ) &
              &          )                                                    &
              &    + pyz_VelXNl(i-1,j,k)                                      &
              &        * (                                                    &
              &            fct1 * ( xyz_VarNl(i,j,k)   - xyz_VarNl(i-1,j,k) ) &
              &          - fct2 * ( xyz_VarNl(i+1,j,k) - xyz_VarNl(i-2,j,k) ) &
              &          )                                                    &
              &   ) * 5.0d-1 / dx                                             &
              & - (                                                           &
              &      xqz_VelYNl(i,j,k)                                        &
              &        * (                                                    &
              &            fct1 * ( xyz_VarNl(i,j+1,k) - xyz_VarNl(i,j,k)   ) &
              &          - fct2 * ( xyz_VarNl(i,j+2,k) - xyz_VarNl(i,j-1,k) ) &
              &          )                                                    &
              &    + xqz_VelYNl(i,j-1,k)                                      &
              &        * (                                                    &
              &            fct1 * ( xyz_VarNl(i,j,k)   - xyz_VarNl(i,j-1,k) ) &
              &          - fct2 * ( xyz_VarNl(i,j+1,k) - xyz_VarNl(i,j-2,k) ) &
              &          )                                                    &
              &   ) * 5.0d-1 / dy                                             &
              & - (                                                           &
              &      xyr_VelZNl(i,j,k)                                        &
              &        * (                                                    &
              &            fct1 * ( xyz_VarNl(i,j,k+1) - xyz_VarNl(i,j,k)   ) &
              &          - fct2 * ( xyz_VarNl(i,j,k+2) - xyz_VarNl(i,j,k-1) ) &
              &          )                                                    &
              &    + xyr_VelZNl(i,j,k-1)                                      &
              &        * (                                                    &
              &            fct1 * ( xyz_VarNl(i,j,k)   - xyz_VarNl(i,j,k-1) ) &
              &          - fct2 * ( xyz_VarNl(i,j,k+1) - xyz_VarNl(i,j,k-2) ) &
              &          )                                                    &
              &   ) * 5.0d-1 / dz
          end do
        end do
      end do
      
      xyz_Adv(imin:imin+1,:,:) = 0.0d0
      xyz_Adv(imax-1:imax,:,:) = 0.0d0
      xyz_Adv(:,jmin:jmin+1,:) = 0.0d0
      xyz_Adv(:,jmax-1:jmax,:) = 0.0d0
      xyz_Adv(:,:,kmin:kmin+1) = 0.0d0
      xyz_Adv(:,:,kmax-1:kmax) = 0.0d0
      
      ! 4 οͳȻ: 2 濴ʬ
      ! 
      do k = kmin + 2, kmax - 2
        do j = jmin + 2, jmax - 2
          do i = imin + 2, imax - 2
            
            xyz_nDiff(i,j,k) =                            &
              & - (                                       &
              &     + xyz_VarBl(i+2,j,k)                  &
              &     + xyz_VarBl(i-2,j,k)                  &
              &     - xyz_VarBl(i+1,j,k) * 4.0d0          &
              &     - xyz_VarBl(i-1,j,k) * 4.0d0          &
              &     + xyz_VarBl(i  ,j,k) * 6.0d0          &
              &   ) * NuHh / ( dx ** 4.0d0 )              &
              & - (                                       &
              &       xyz_VarBl(i,j+2,k)                  &
              &     + xyz_VarBl(i,j-2,k)                  &
              &     - xyz_VarBl(i,j+1,k) * 4.0d0          &
              &     - xyz_VarBl(i,j-1,k) * 4.0d0          &
              &     + xyz_VarBl(i,j  ,k) * 6.0d0          &
              &   ) * NuHh / ( dy ** 4.0d0 )              &
              & - (                                       &
              &       xyz_VarBl(i,j,k+2)                  &
              &     + xyz_VarBl(i,j,k-2)                  &
              &     - xyz_VarBl(i,j,k+1) * 4.0d0          &
              &     - xyz_VarBl(i,j,k-1) * 4.0d0          &
              &     + xyz_VarBl(i,j,k  ) * 6.0d0          &
              &   ) * NuVh / ( dz ** 4.0d0 )
          end do
        end do
      end do
      
      xyz_nDiff(imin:imin+1,:,:) = 0.0d0
      xyz_nDiff(imax-1:imax,:,:) = 0.0d0
      xyz_nDiff(:,jmin:jmin+1,:) = 0.0d0
      xyz_nDiff(:,jmax-1:jmax,:) = 0.0d0
      xyz_nDiff(:,:,kmin:kmin+1) = 0.0d0
      xyz_nDiff(:,:,kmax-1:kmax) = 0.0d0
      
    end subroutine AdvC4_nDiff_xyz
    
    
    subroutine AdvC4_nDiff_xyzf( xyzf_VarBl, xyzf_VarNl ) 

      implicit none
      
      real(DP), intent(in)  :: xyzf_VarBl(imin:imax,jmin:jmax,kmin:kmax,1:ncmax)
      real(DP), intent(in)  :: xyzf_VarNl(imin:imax,jmin:jmax,kmin:kmax,1:ncmax)
      
      real(DP)              :: fct1, fct2
      integer               :: s, i, j, k
      
      ! ʬѤ뷸ͽ׻
      !
      fct1 = 9.0d0 / 8.0d0
      fct2 = 1.0d0 / 24.0d0
      
      ! ήη׻. ή: 4 濴ʬ
      ! 
      do s = 1, ncmax
        do k = kmin + 2, kmax - 2
          do j = jmin + 2, jmax - 2
            do i = imin + 2, imax - 2
              
              xyzf_Adv(i,j,k,s) =                                                     &
                & - (                                                                 &
                &      pyz_VelXNl(i,j,k)                                              &
                &        * (                                                          &
                &            fct1 * ( xyzf_VarNl(i+1,j,k,s) - xyzf_VarNl(i,j,k,s)   ) &
                &          - fct2 * ( xyzf_VarNl(i+2,j,k,s) - xyzf_VarNl(i-1,j,k,s) ) &
                &          )                                                          &
                &    + pyz_VelXNl(i-1,j,k)                                            &
                &        * (                                                          &
                &            fct1 * ( xyzf_VarNl(i,j,k,s)   - xyzf_VarNl(i-1,j,k,s) ) &
                &          - fct2 * ( xyzf_VarNl(i+1,j,k,s) - xyzf_VarNl(i-2,j,k,s) ) &
                &          )                                                          &
                &   ) * 5.0d-1 / dx                                                   &
                & - (                                                                 &
                &      xqz_VelYNl(i,j,k)                                              &
                &        * (                                                          &
                &            fct1 * ( xyzf_VarNl(i,j+1,k,s) - xyzf_VarNl(i,j,k,s)   ) &
                &          - fct2 * ( xyzf_VarNl(i,j+2,k,s) - xyzf_VarNl(i,j-1,k,s) ) &
                &          )                                                          &
                &    + xqz_VelYNl(i,j-1,k)                                            &
                &        * (                                                          &
                &            fct1 * ( xyzf_VarNl(i,j,k,s)   - xyzf_VarNl(i,j-1,k,s) ) &
                &          - fct2 * ( xyzf_VarNl(i,j+1,k,s) - xyzf_VarNl(i,j-2,k,s) ) &
                &          )                                                          &
                &   ) * 5.0d-1 / dy                                                   &
                & - (                                                                 &
                &      xyr_VelZNl(i,j,k)                                              &
                &        * (                                                          &
                &            fct1 * ( xyzf_VarNl(i,j,k+1,s) - xyzf_VarNl(i,j,k,s)   ) &
                &          - fct2 * ( xyzf_VarNl(i,j,k+2,s) - xyzf_VarNl(i,j,k-1,s) ) &
                &          )                                                          &
                &    + xyr_VelZNl(i,j,k-1)                                            &
                &        * (                                                          &
                &            fct1 * ( xyzf_VarNl(i,j,k,s)   - xyzf_VarNl(i,j,k-1,s) ) &
                &          - fct2 * ( xyzf_VarNl(i,j,k+1,s) - xyzf_VarNl(i,j,k-2,s) ) &
                &          )                                                          &
                &   ) * 5.0d-1 / dz
            end do
          end do
        end do
      end do
      
      xyzf_Adv(imin:imin+1,:,:,:) = 0.0d0
      xyzf_Adv(imax-1:imax,:,:,:) = 0.0d0
      xyzf_Adv(:,jmin:jmin+1,:,:) = 0.0d0
      xyzf_Adv(:,jmax-1:jmax,:,:) = 0.0d0
      xyzf_Adv(:,:,kmin:kmin+1,:) = 0.0d0
      xyzf_Adv(:,:,kmax-1:kmax,:) = 0.0d0
      
      ! ͳȻ: 2 濴ʬ
      ! 
      do s = 1, ncmax
        do k = kmin + 2, kmax - 2
          do j = jmin + 2, jmax - 2
            do i = imin + 2, imax - 2
              
              xyzf_nDiff(i,j,k,s) =                            &
                & - (                                          &
                &       xyzf_VarBl(i+2,j,k,s)                  &
                &     + xyzf_VarBl(i-2,j,k,s)                  &
                &     - xyzf_VarBl(i+1,j,k,s) * 4.0d0          &
                &     - xyzf_VarBl(i-1,j,k,s) * 4.0d0          &
                &     + xyzf_VarBl(i  ,j,k,s) * 6.0d0          &
                &   ) * NuHh / ( dx ** 4.0d0 )                 &
                & - (                                          &
                &       xyzf_VarBl(i,j+2,k,s)                  &
                &     + xyzf_VarBl(i,j-2,k,s)                  &
                &     - xyzf_VarBl(i,j+1,k,s) * 4.0d0          &
                &     - xyzf_VarBl(i,j-1,k,s) * 4.0d0          &
                &     + xyzf_VarBl(i,j  ,k,s) * 6.0d0          &
                &   ) * NuHh / ( dy ** 4.0d0 )                 &
                & - (                                          &
                &       xyzf_VarBl(i,j,k+2,s)                  &
                &     + xyzf_VarBl(i,j,k-2,s)                  &
                &     - xyzf_VarBl(i,j,k+1,s) * 4.0d0          &
                &     - xyzf_VarBl(i,j,k-1,s) * 4.0d0          &
                &     + xyzf_VarBl(i,j,k  ,s) * 6.0d0          &
                &   ) * NuVh / ( dz ** 4.0d0 )
            end do
          end do
        end do
      end do
      
      xyzf_nDiff(imin:imin+1,:,:,:) = 0.0d0
      xyzf_nDiff(imax-1:imax,:,:,:) = 0.0d0
      xyzf_nDiff(:,jmin:jmin+1,:,:) = 0.0d0
      xyzf_nDiff(:,jmax-1:jmax,:,:) = 0.0d0
      xyzf_nDiff(:,:,kmin:kmin+1,:) = 0.0d0
      xyzf_nDiff(:,:,kmax-1:kmax,:) = 0.0d0
      
    end subroutine AdvC4_nDiff_xyzf
  

    subroutine BuoyancyLong_xyr
      
      use composition, only: GasNum,       &! 
        &                    IdxG,         &!
        &                    MolWtWet       ! ʬʬ
      use constants,only:    MolWtDry,     &! ʬʬ
        &                    Grav           ! ϲ®
      
      implicit none
      
      real(DP)              :: xyzf_QMixPerMolWt(imin:imax,jmin:jmax,kmin:kmax, 1:GasNum)
      real(DP)              :: tmp1(imin:imax,jmin:jmax,kmin:kmax)
      real(DP)              :: tmp2(imin:imax,jmin:jmax,kmin:kmax)
      real(DP)              :: tmp3(imin:imax,jmin:jmax,kmin:kmax)
      integer               :: i, j, k, f, n
      
      do f = 1, GasNum
        n = IdxG(f)
        xyzf_QMixPerMolWt(:,:,:,f) = xyzf_QMixNl(:,:,:,n) / MolWtWet(n)
      end do
      
      ! Buoyancy due to temperature disturbunce
      !
      do k = kmin, kmax - 1
        do j = jmin, jmax
          do i = imin, imax
            
            xyr_BuoyT(i,j,k) =                                  &
              & Grav                                            &
              & * (                                             &
              &     xyz_PTempNl(i,j,k+1) / xyz_PTempBZ(i,j,k+1) &
              &   + xyz_PTempNl(i,j,k)   / xyz_PTempBZ(i,j,k)   &
              &   ) * 5.0d-1
            
          end do
        end do
      end do
      
      xyr_BuoyT(:,:,kmax) = 0.0d0
      
      ! Buoyancy due to molecular weight
      !
      tmp1 = sum(xyzf_QMixPerMolWt, 4) 
      tmp2 = sum(xyzf_QMixNl(:,:,:,1:GasNum), 4)
      
      do k = kmin, kmax - 1
        do j = jmin, jmax 
          do i = imin, imax 
            
            xyr_BuoyM(i,j,k) =                                       &
              & + Grav                                               &
              &   * ( tmp1(i,j,k+1) + tmp1(i,j,k) ) * 5.0d-1         &
              &   / ( 1.0d0 / MolWtDry + xyr_QMixBZPerMolWt(i,j,k) ) &
              & - Grav                                               &
              &   * ( tmp2(i,j,k+1) + tmp2(i,j,k) ) * 5.0d-1         &
              &   / ( 1.0d0 + xyr_QmixBZ(i,j,k) ) 
            
          end do
        end do
      end do
      xyr_BuoyM(:,:,kmax) = 0.0d0
      
      ! Buoyancy due to loading
      !
      tmp3 = sum(xyzf_QMixNl(:,:,:,GasNum+1:ncmax), 4) 
      
      do k = kmin, kmax - 1
        do j = jmin, jmax 
          do i = imin, imax 
            
            xyr_BuoyD(i,j,k) =                                &
              & - Grav                                        &
              &   * ( tmp3(i,j,k+1) + tmp3(i,j,k) ) * 5.0d-1  &
              &   / ( 1.0d0 + xyr_QMixBZ(i,j,k) )
            
          end do
        end do
      end do
      
      xyr_BuoyD(:,:,kmax) = 0.0d0
      
    end subroutine BuoyancyLong_xyr
        
  end subroutine Dynamics_Long_forcing

!!!-----------------------------------------------------------!!!

  subroutine Dynamics2D_Long_forcing( &
    & pyz_VelXBl,  pyz_VelXNl,        & ! (in)
    & xyr_VelZBl,  xyr_VelZNl,        & ! (in)
    & xyz_PTempBl, xyz_PTempNl,       & ! (in)
    & xyzf_QMixBl, xyzf_QMixNl,       & ! (in)
    & xyz_KmBl,    xyz_KmNl,          & ! (in)
    & pyz_DVelXDtNl,                  & ! (inout)
    & xqz_DVelYDtNl,                  & ! (inout)
    & xyr_DVelZDtNl,                  & ! (inout)
    & xyz_DPTempDtNl,                 & ! (inout)
    & xyzf_DQMixDtNl,                 & ! (inout)
    & xyz_DKmDtNl                     & ! (inout)
    & )

    implicit none

    real(DP), intent(in)    :: pyz_VelXBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: pyz_VelXNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyr_VelZBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyr_VelZNl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(in)    :: xyz_PTempBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyz_PTempNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyzf_QMixBl(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP), intent(in)    :: xyzf_QMixNl(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP), intent(in)    :: xyz_KmBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)    :: xyz_KmNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout) :: pyz_DVelXDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout) :: xqz_DVelYDtNl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(inout) :: xyr_DVelZDtNl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(inout) :: xyz_DPTempDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout) :: xyzf_DQMixDtNl(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP), intent(inout) :: xyz_DKmDtNl(imin:imax,jmin:jmax,kmin:kmax)

    real(DP)             :: pyz_Adv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: pyz_nDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_Adv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_nDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_BuoyT(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_BuoyM(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_BuoyD(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyz_Adv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyz_nDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyzf_Adv(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP)             :: xyzf_nDiff(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP)             :: xyz_PTempAll(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyzf_QMixAll(imin:imax,jmin:jmax,kmin:kmax,1:ncmax)

    integer              :: f


    !--------------------------------------------------------------------
    ! ήȻ

    ! ήӿͳȻ
    !
    call AdvC4_nDiff_xyz( xyz_KmBl, xyz_KmNl ) !(IN)
    
    ! tendency ι
    !
    xyz_DKmDtNl = xyz_DKmDtNl + xyz_Adv + xyz_nDiff
    
    call HistoryAutoPut(TimeN, 'KmAdv',   xyz_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'KmNDiff', xyz_nDiff(1:nx,1:ny,1:nz))
    
    !--------------------------------------------------------------------
    ! 

    ! ήˤĤƤ, ܾθ.
    !
    xyz_PTempAll = xyz_PTempNl + xyz_PTempBZ
    call AdvC4_nDiff_xyz( xyz_PTempBl, xyz_PTempAll ) !(IN)

    ! tendency ι
    !
    xyz_DPTempDtNl = xyz_DPTempDtNl + xyz_Adv + xyz_nDiff
    
    ! output
    !
    call HistoryAutoPut(TimeN, 'PTempAdv',   xyz_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'PTempNDiff', xyz_nDiff(1:nx,1:ny,1:nz))

    !--------------------------------------------------------------------
    ! 
    ! 

    ! ήˤĤƤ, ܾθ.
    !
    xyzf_QMixAll = xyzf_QMixNl + xyzf_QMixBZ
    call AdvC4_nDiff_xyzf( xyzf_QMixBl, xyzf_QMixAll ) !(IN)

    ! tendency ι    
    !
    xyzf_DQMixDtNl = xyzf_DQMixDtNl + xyzf_Adv + xyzf_nDiff
    
    ! output
    !
    do f = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(f))//'_Adv',   &
        & xyzf_Adv(1:nx,1:ny,1:nz,f))
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(f))//'_NDiff', &
        & xyzf_NDiff(1:nx,1:ny,1:nz,f))
    end do

    !------------------------------------------------------------------
    ! VelX, VelY, VelZ
    ! 

    ! ήࡦͳȻޤȤƷ׻
    !
    call AdvC4_nDiff_pyz_xyr

    ! tendency of VelX
    !
    pyz_DVelXDtNl = pyz_DVelXDtNl + pyz_Adv + pyz_NDiff
    
    call HistoryAutoPut(TimeN, 'VelXAdv',   pyz_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelXNDiff', pyz_nDiff(1:nx,1:ny,1:nz))


    ! tendency of VelY
    !
    xqz_DVelYDtNl = 0.0d0

    ! Buoyancy 
    ! 
    call BuoyancyLong_xyr

    ! tendency of VelZ
    !
    xyr_DVelZDtNl = xyr_DVelZDtNl + xyr_Adv + xyr_NDiff          &
         &          + xyr_BuoyT * FactorBuoyTemp                 &
         &          + xyr_BuoyM * FactorBuoyMolWt                &
         &          + xyr_BuoyD * FactorBuoyLoading

    call HistoryAutoPut(TimeN, 'VelZAdv',   xyr_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelZNDiff', xyr_NDiff(1:nx,1:ny,1:nz))    
    call HistoryAutoPut(TimeN, 'VelZBuoyT', xyr_BuoyT(1:nx,1:ny,1:nz))    
    call HistoryAutoPut(TimeN, 'VelZBuoyM', xyr_BuoyM(1:nx,1:ny,1:nz))    
    call HistoryAutoPut(TimeN, 'VelZBuoyD', xyr_BuoyD(1:nx,1:ny,1:nz))    

  contains
    
    subroutine AdvC4_nDiff_pyz_xyr

      implicit none

      real(DP)              :: fct1, fct2
      integer               :: i, j, k
      
      ! ʬѤ뷸ͽ׻
      !
      fct1 = 9.0d0 / 8.0d0
      fct2 = 1.0d0 / 24.0d0
      
      ! ήη׻. ή: 4 濴ʬ
      ! 
      do k = kmin + 2, kmax - 2
        do j = 1, ny
          do i = imin + 2, imax - 2
            
            pyz_Adv(i,j,k) =                                                   &
              & - pyz_VelXNl(i,j,k)                                            &
              &   * (                                                          &
              &       fct1 * (   pyz_VelXNl(i+1,j,k) - pyz_VelXNl(i-1,j,k) )   &
              &     - fct2 * (   pyz_VelXNl(i+2,j,k) + pyz_VelXNl(i+1,j,k)     &
              &                - pyz_VelXNl(i-1,j,k) - pyz_VelXNl(i-2,j,k) )   &
              &     ) * 5.0d-1 / dx                                            &
              & - (                                                            &
              &   + ( xyr_VelZNl(i+1,j,k) + xyr_VelZNl(i,j,k) )                & 
              &     * (                                                        &
              &         fct1 * ( pyz_VelXNl(i,j,k+1) - pyz_VelXNl(i,j,k)   )   &
              &       - fct2 * ( pyz_VelXNl(i,j,k+2) - pyz_VelXNl(i,j,k-1) )   &
              &       )                                                        &
              &   + ( xyr_VelZNl(i+1,j,k-1) + xyr_VelZNl(i,j,k-1) )            & 
              &     * (                                                        &
              &         fct1 * ( pyz_VelXNl(i,j,k)   - pyz_VelXNl(i,j,k-1) )   &
              &       - fct2 * ( pyz_VelXNl(i,j,k+1) - pyz_VelXNl(i,j,k-2) )   &
              &       )                                                        &
              &   ) * 2.5d-1 / dz
            
          end do
        end do
      end do
      
      pyz_Adv(imin:imin+1,:,:) = 0.0d0
      pyz_Adv(imax-1:imax,:,:) = 0.0d0
      pyz_Adv(:,:,kmin:kmin+1) = 0.0d0
      pyz_Adv(:,:,kmax-1:kmax) = 0.0d0
      
      do k = kmin + 2, kmax - 2
        do j = 1, ny
          do i = imin + 2, imax - 2
            
            xyr_Adv(i,j,k) =                                                   &
              & - (                                                            &
              &   + ( pyz_VelXNl(i,j,k+1) + pyz_VelXNl(i,j,k) )                & 
              &     * (                                                        &
              &         fct1 * ( xyr_VelZNl(i+1,j,k) - xyr_VelZNl(i,j,k)   )   &
              &       - fct2 * ( xyr_VelZNl(i+2,j,k) - xyr_VelZNl(i-1,j,k) )   &
              &       )                                                        &
              &   + ( pyz_VelXNl(i-1,j,k+1) + pyz_VelXNl(i-1,j,k) )            & 
              &     * (                                                        &
              &         fct1 * ( xyr_VelZNl(i,j,k)   - xyr_VelZNl(i-1,j,k) )   &
              &       - fct2 * ( xyr_VelZNl(i+1,j,k) - xyr_VelZNl(i-2,j,k) )   &
              &       )                                                        &
              &   ) * 2.5d-1 / dx                                              &
              & - xyr_VelZNl(i,j,k)                                            &
              &   * (                                                          &
              &       fct1 * (   xyr_VelZNl(i,j,k+1) - xyr_VelZNl(i,j,k-1) )   &
              &     - fct2 * (   xyr_VelZNl(i,j,k+2) + xyr_VelZNl(i,j,k+1)     &
              &                - xyr_VelZNl(i,j,k-1) - xyr_VelZNl(i,j,k-2) )   &
              &     ) * 5.0d-1 / dz
          end do
        end do
      end do
      
      xyr_Adv(imin:imin+1,:,:) = 0.0d0
      xyr_Adv(imax-1:imax,:,:) = 0.0d0
      xyr_Adv(:,:,kmin:kmin+1) = 0.0d0
      xyr_Adv(:,:,kmax-1:kmax) = 0.0d0
      
      do k = kmin + 2, kmax - 2
        do j = 1, ny
          do i = imin + 2, imax - 2
            
            pyz_nDiff(i,j,k) =                             &
              & - (                                        &
              &     + pyz_VelXBl(i+2,j,k)                  &
              &     + pyz_VelXBl(i-2,j,k)                  &
              &     - pyz_VelXBl(i+1,j,k) * 4.0d0          &
              &     - pyz_VelXBl(i-1,j,k) * 4.0d0          &
              &     + pyz_VelXBl(i  ,j,k) * 6.0d0          &
              &   ) * NuHm / ( dx ** 4.0d0 )               &
              & - (                                        & 
              &     + pyz_VelXBl(i,j,k+2)                  &
              &     + pyz_VelXBl(i,j,k-2)                  &
              &     - pyz_VelXBl(i,j,k+1) * 4.0d0          &
              &     - pyz_VelXBl(i,j,k-1) * 4.0d0          &
              &     + pyz_VelXBl(i,j,k  ) * 6.0d0          &
              &   ) * NuVm / ( dz ** 4.0d0 )
            
          end do
        end do
      end do
      
      pyz_nDiff(imin:imin+1,:,:) = 0.0d0
      pyz_nDiff(imax-1:imax,:,:) = 0.0d0
      pyz_nDiff(:,:,kmin:kmin+1) = 0.0d0
      pyz_nDiff(:,:,kmax-1:kmax) = 0.0d0

      do k = kmin + 2, kmax - 2
        do j = 1, ny          
          do i = imin + 2, imax - 2
            
            xyr_nDiff(i,j,k) =                             &
              & - (                                        &
              &     + xyr_VelZBl(i+2,j,k)                  &
              &     + xyr_VelZBl(i-2,j,k)                  &
              &     - xyr_VelZBl(i+1,j,k) * 4.0d0          &
              &     - xyr_VelZBl(i-1,j,k) * 4.0d0          &
              &     + xyr_VelZBl(i  ,j,k) * 6.0d0          &
              &   ) * NuHm / ( dx ** 4.0d0 )               &
              & - (                                        &
              &     + xyr_VelZBl(i,j,k+2)                  &
              &     + xyr_VelZBl(i,j,k-2)                  &
              &     - xyr_VelZBl(i,j,k+1) * 4.0d0          &
              &     - xyr_VelZBl(i,j,k-1) * 4.0d0          &
              &     + xyr_VelZBl(i,j,k  ) * 6.0d0          &
              &   ) * NuVm / ( dz ** 4.0d0 )
          end do
        end do
      end do
      
      xyr_nDiff(imin:imin+1,:,:) = 0.0d0
      xyr_nDiff(imax-1:imax,:,:) = 0.0d0
      xyr_nDiff(:,:,kmin:kmin+1) = 0.0d0
      xyr_nDiff(:,:,kmax-1:kmax) = 0.0d0
      
    end subroutine AdvC4_nDiff_pyz_xyr
    
    
    subroutine AdvC4_nDiff_xyz( xyz_VarBl, xyz_VarNl )
      
      implicit none
      
      real(DP), intent(in)  :: xyz_VarBl(imin:imax,jmin:jmax,kmin:kmax)
      real(DP), intent(in)  :: xyz_VarNl(imin:imax,jmin:jmax,kmin:kmax)
      
      real(DP)              :: fct1, fct2
      integer               :: i, j, k
      
      ! ʬѤ뷸ͽ׻
      !
      fct1 = 9.0d0 / 8.0d0
      fct2 = 1.0d0 / 24.0d0

      ! ήη׻. ή: 4 濴ʬ
      ! 
      do k = kmin + 2, kmax - 2
        do j = 1, ny
          do i = imin + 2, imax - 2
            
            xyz_Adv(i,j,k) =                                                  &
              & - (                                                           &
              &      pyz_VelXNl(i,j,k)                                        &
              &        * (                                                    &
              &            fct1 * ( xyz_VarNl(i+1,j,k) - xyz_VarNl(i,j,k)   ) &
              &          - fct2 * ( xyz_VarNl(i+2,j,k) - xyz_VarNl(i-1,j,k) ) &
              &          )                                                    &
              &    + pyz_VelXNl(i-1,j,k)                                      &
              &        * (                                                    &
              &            fct1 * ( xyz_VarNl(i,j,k)   - xyz_VarNl(i-1,j,k) ) &
              &          - fct2 * ( xyz_VarNl(i+1,j,k) - xyz_VarNl(i-2,j,k) ) &
              &          )                                                    &
              &   ) * 5.0d-1 / dx                                             &
              & - (                                                           &
              &      xyr_VelZNl(i,j,k)                                        &
              &        * (                                                    &
              &            fct1 * ( xyz_VarNl(i,j,k+1) - xyz_VarNl(i,j,k)   ) &
              &          - fct2 * ( xyz_VarNl(i,j,k+2) - xyz_VarNl(i,j,k-1) ) &
              &          )                                                    &
              &    + xyr_VelZNl(i,j,k-1)                                      &
              &        * (                                                    &
              &            fct1 * ( xyz_VarNl(i,j,k)   - xyz_VarNl(i,j,k-1) ) &
              &          - fct2 * ( xyz_VarNl(i,j,k+1) - xyz_VarNl(i,j,k-2) ) &
              &          )                                                    &
              &   ) * 5.0d-1 / dz
          end do
        end do
      end do
      
      xyz_Adv(imin:imin+1,:,:) = 0.0d0
      xyz_Adv(imax-1:imax,:,:) = 0.0d0
      xyz_Adv(:,:,kmin:kmin+1) = 0.0d0
      xyz_Adv(:,:,kmax-1:kmax) = 0.0d0
      
      ! 4 οͳȻ: 2 濴ʬ
      ! 
      do k = kmin + 2, kmax - 2
        do j = 1, ny
          do i = imin + 2, imax - 2
            
            xyz_nDiff(i,j,k) =                            &
              & - (                                       &
              &     + xyz_VarBl(i+2,j,k)                  &
              &     + xyz_VarBl(i-2,j,k)                  &
              &     - xyz_VarBl(i+1,j,k) * 4.0d0          &
              &     - xyz_VarBl(i-1,j,k) * 4.0d0          &
              &     + xyz_VarBl(i  ,j,k) * 6.0d0          &
              &   ) * NuHh / ( dx ** 4.0d0 )              &
              & - (                                       &
              &       xyz_VarBl(i,j,k+2)                  &
              &     + xyz_VarBl(i,j,k-2)                  &
              &     - xyz_VarBl(i,j,k+1) * 4.0d0          &
              &     - xyz_VarBl(i,j,k-1) * 4.0d0          &
              &     + xyz_VarBl(i,j,k  ) * 6.0d0          &
              &   ) * NuVh / ( dz ** 4.0d0 )
          end do
        end do
      end do
      
      xyz_nDiff(imin:imin+1,:,:) = 0.0d0
      xyz_nDiff(imax-1:imax,:,:) = 0.0d0
      xyz_nDiff(:,:,kmin:kmin+1) = 0.0d0
      xyz_nDiff(:,:,kmax-1:kmax) = 0.0d0
      
    end subroutine AdvC4_nDiff_xyz
    
    
    subroutine AdvC4_nDiff_xyzf( xyzf_VarBl, xyzf_VarNl ) 

      implicit none
      
      real(DP), intent(in)  :: xyzf_VarBl(imin:imax,jmin:jmax,kmin:kmax,1:ncmax)
      real(DP), intent(in)  :: xyzf_VarNl(imin:imax,jmin:jmax,kmin:kmax,1:ncmax)
      
      real(DP)              :: fct1, fct2
      integer               :: s, i, j, k
      
      ! ʬѤ뷸ͽ׻
      !
      fct1 = 9.0d0 / 8.0d0
      fct2 = 1.0d0 / 24.0d0
      
      ! ήη׻. ή: 4 濴ʬ
      ! 
      do s = 1, ncmax
        do k = kmin + 2, kmax - 2
          do j = 1, ny
            do i = imin + 2, imax - 2
              
              xyzf_Adv(i,j,k,s) =                                                     &
                & - (                                                                 &
                &      pyz_VelXNl(i,j,k)                                              &
                &        * (                                                          &
                &            fct1 * ( xyzf_VarNl(i+1,j,k,s) - xyzf_VarNl(i,j,k,s)   ) &
                &          - fct2 * ( xyzf_VarNl(i+2,j,k,s) - xyzf_VarNl(i-1,j,k,s) ) &
                &          )                                                          &
                &    + pyz_VelXNl(i-1,j,k)                                            &
                &        * (                                                          &
                &            fct1 * ( xyzf_VarNl(i,j,k,s)   - xyzf_VarNl(i-1,j,k,s) ) &
                &          - fct2 * ( xyzf_VarNl(i+1,j,k,s) - xyzf_VarNl(i-2,j,k,s) ) &
                &          )                                                          &
                &   ) * 5.0d-1 / dx                                                   &
                & - (                                                                 &
                &      xyr_VelZNl(i,j,k)                                              &
                &        * (                                                          &
                &            fct1 * ( xyzf_VarNl(i,j,k+1,s) - xyzf_VarNl(i,j,k,s)   ) &
                &          - fct2 * ( xyzf_VarNl(i,j,k+2,s) - xyzf_VarNl(i,j,k-1,s) ) &
                &          )                                                          &
                &    + xyr_VelZNl(i,j,k-1)                                            &
                &        * (                                                          &
                &            fct1 * ( xyzf_VarNl(i,j,k,s)   - xyzf_VarNl(i,j,k-1,s) ) &
                &          - fct2 * ( xyzf_VarNl(i,j,k+1,s) - xyzf_VarNl(i,j,k-2,s) ) &
                &          )                                                          &
                &   ) * 5.0d-1 / dz
            end do
          end do
        end do
      end do
      
      xyzf_Adv(imin:imin+1,:,:,:) = 0.0d0
      xyzf_Adv(imax-1:imax,:,:,:) = 0.0d0
      xyzf_Adv(:,:,kmin:kmin+1,:) = 0.0d0
      xyzf_Adv(:,:,kmax-1:kmax,:) = 0.0d0
      
      ! ͳȻ: 2 濴ʬ
      ! 
      do s = 1, ncmax
        do k = kmin + 2, kmax - 2
          do j = 1, ny
            do i = imin + 2, imax - 2
              
              xyzf_nDiff(i,j,k,s) =                            &
                & - (                                          &
                &       xyzf_VarBl(i+2,j,k,s)                  &
                &     + xyzf_VarBl(i-2,j,k,s)                  &
                &     - xyzf_VarBl(i+1,j,k,s) * 4.0d0          &
                &     - xyzf_VarBl(i-1,j,k,s) * 4.0d0          &
                &     + xyzf_VarBl(i  ,j,k,s) * 6.0d0          &
                &   ) * NuHh / ( dx ** 4.0d0 )                 &
                & - (                                          &
                &       xyzf_VarBl(i,j,k+2,s)                  &
                &     + xyzf_VarBl(i,j,k-2,s)                  &
                &     - xyzf_VarBl(i,j,k+1,s) * 4.0d0          &
                &     - xyzf_VarBl(i,j,k-1,s) * 4.0d0          &
                &     + xyzf_VarBl(i,j,k  ,s) * 6.0d0          &
                &   ) * NuVh / ( dz ** 4.0d0 )
            end do
          end do
        end do
      end do
      
      xyzf_nDiff(imin:imin+1,:,:,:) = 0.0d0
      xyzf_nDiff(imax-1:imax,:,:,:) = 0.0d0
      xyzf_nDiff(:,:,kmin:kmin+1,:) = 0.0d0
      xyzf_nDiff(:,:,kmax-1:kmax,:) = 0.0d0
      
    end subroutine AdvC4_nDiff_xyzf
  

    subroutine BuoyancyLong_xyr
      
      use composition, only: GasNum,       &! 
        &                    IdxG,         &!
        &                    MolWtWet       ! ʬʬ
      use constants,only:    MolWtDry,     &! ʬʬ
        &                    Grav           ! ϲ®
      
      implicit none
      
      real(DP)              :: xyzf_QMixPerMolWt(imin:imax,jmin:jmax,kmin:kmax, 1:GasNum)
      real(DP)              :: tmp1(imin:imax,jmin:jmax,kmin:kmax)
      real(DP)              :: tmp2(imin:imax,jmin:jmax,kmin:kmax)
      real(DP)              :: tmp3(imin:imax,jmin:jmax,kmin:kmax)
      integer               :: i, j, k, f, n
      
      do f = 1, GasNum
        n = IdxG(f)
        xyzf_QMixPerMolWt(:,:,:,f) = xyzf_QMixNl(:,:,:,n) / MolWtWet(n)
      end do
      
      ! Buoyancy due to temperature disturbunce
      !
      do k = kmin, kmax - 1
        do j = 1, ny
          do i = imin, imax
            
            xyr_BuoyT(i,j,k) =                                  &
              & Grav                                            &
              & * (                                             &
              &     xyz_PTempNl(i,j,k+1) / xyz_PTempBZ(i,j,k+1) &
              &   + xyz_PTempNl(i,j,k)   / xyz_PTempBZ(i,j,k)   &
              &   ) * 5.0d-1
            
          end do
        end do
      end do
      
      xyr_BuoyT(:,:,kmax) = 0.0d0
      
      ! Buoyancy due to molecular weight
      !
      tmp1 = sum(xyzf_QMixPerMolWt, 4) 
      tmp2 = sum(xyzf_QMixNl(:,:,:,1:GasNum), 4)
      
      do k = kmin, kmax - 1
        do j = 1, ny
          do i = imin, imax 
            
            xyr_BuoyM(i,j,k) =                                       &
              & + Grav                                               &
              &   * ( tmp1(i,j,k+1) + tmp1(i,j,k) ) * 5.0d-1         &
              &   / ( 1.0d0 / MolWtDry + xyr_QMixBZPerMolWt(i,j,k) ) &
              & - Grav                                               &
              &   * ( tmp2(i,j,k+1) + tmp2(i,j,k) ) * 5.0d-1         &
              &   / ( 1.0d0 + xyr_QmixBZ(i,j,k) ) 
            
          end do
        end do
      end do
      xyr_BuoyM(:,:,kmax) = 0.0d0
      
      ! Buoyancy due to loading
      !
      tmp3 = sum(xyzf_QMixNl(:,:,:,GasNum+1:ncmax), 4) 
      
      do k = kmin, kmax - 1
        do j = 1, ny
          do i = imin, imax 
            
            xyr_BuoyD(i,j,k) =                                &
              & - Grav                                        &
              &   * ( tmp3(i,j,k+1) + tmp3(i,j,k) ) * 5.0d-1  &
              &   / ( 1.0d0 + xyr_QMixBZ(i,j,k) )
            
          end do
        end do
      end do
      
      xyr_BuoyD(:,:,kmax) = 0.0d0
      
    end subroutine BuoyancyLong_xyr
    
  end subroutine Dynamics2D_Long_forcing


  subroutine Dynamics_Long_integrate(     &
    & xyz_VarBl, xyz_DVarDtNl,            & !(IN)
    & xyzf_VarBl, xyzf_DVarDtNl,          & !(IN)
    & xyz_VarAl,                          & !(OUT)
    & xyzf_VarAl                          & !(OUT)
    )

    implicit none

    real(DP), intent(in)   :: xyz_VarBl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(in)   :: xyz_DVarDtNl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(in)   :: xyzf_VarBl(imin:imax,jmin:jmax,kmin:kmax,1:ncmax)
    real(DP), intent(in)   :: xyzf_DVarDtNl(imin:imax,jmin:jmax,kmin:kmax,1:ncmax)
    real(DP), intent(out)  :: xyz_VarAl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(out)  :: xyzf_VarAl(imin:imax,jmin:jmax,kmin:kmax,1:ncmax)

    !------------------------------------------------------------------
    ! 顼̤ʬ 
    ! Integration
    !
    xyz_VarAl = xyz_VarBl + (2.0d0 * DelTimeLong) * xyz_DVarDtNl

    ! Set Margin
    !
    call SetMargin_xyz(xyz_VarAl)

    !------------------------------------------------------------------
    ! ʬ 
    ! Integration
    !
    xyzf_VarAl = xyzf_VarBl + (2.0d0 * DelTimeLong) * xyzf_DVarDtNl

    call SetMargin_xyzf(xyzf_VarAl)

    ! QMix ˤĤƤ, Ϥäͤ
    ! ᤹뤿ˤ,  setmargin Ƥɬפ. 
    !
    call FillNegativeQMix(xyzf_VarAl)

    ! Τͤ. Set Margin
    ! 
    call SetMargin_xyzf(xyzf_VarAl)

  end subroutine Dynamics_Long_integrate

!!!-----------------------------------------------------------------!!!

  subroutine Dynamics_Short_integrate(  &
        &  pyz_VelXNs,          & ! (in)
        &  xqz_VelYNs,          & ! (in)
        &  xyr_VelZNs,          & ! (in)
        &  xyz_ExnerNs,         & ! (in)
        &  pyz_DVelXDtNl,       & ! (in)
        &  xqz_DVelYDtNl,       & ! (in)
        &  xyr_DVelZDtNl,       & ! (in)
        &  xyz_DExnerDtNl,      & ! (in)
        &  pyz_VelXAs,          & ! (out)
        &  xqz_VelYAs,          & ! (out)
        &  xyr_VelZAs,          & ! (out)
        &  xyz_ExnerAs          & ! (out)
        & )

    implicit none

    real(DP), intent(in)  :: pyz_VelXNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xqz_VelYNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xyr_VelZNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xyz_ExnerNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: pyz_DVelXDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xqz_DVelYDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xyr_DVelZDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xyz_DExnerDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: pyz_VelXAs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xqz_VelYAs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyr_VelZAs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyz_ExnerAs(imin:imax,jmin:jmax,kmin:kmax)

    real(DP) :: pyz_DVelXDtNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xqz_DVelYDtNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyr_DVelZDtNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyz_VelDivNs(imin:imax,jmin:jmax,kmin:kmax)

    real(DP) :: pyz_PGrad(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xqz_PGrad(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyr_PGrad(imin:imax,jmin:jmax,kmin:kmax)

    real(DP) :: pyz_SWF(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xqz_SWF(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyr_SWF(imin:imax,jmin:jmax,kmin:kmax)


    !------------------------------------------------------------     
    ! initialize: Divergence of velocity
    !
    call VelDivC2

    !------------------------------------------------------------
    ! VelX, VelY
    !  ʿ۲ˡǲ. 
    !
    call PGrad_HE

    ! tendency 
    !
    pyz_DVelXDtNs = pyz_PGrad + pyz_SWF
    xqz_DVelYDtNs = xqz_PGrad + xqz_SWF

    ! ͤݴ
    !
    call HistoryAutoPut(TimeN, 'VelXPGrad', pyz_PGrad(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelXSWF',   pyz_SWF(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelYPGrad', xqz_PGrad(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelYSWF',   xqz_SWF(1:nx,1:ny,1:nz))

    ! Time integration
    !
    pyz_VelXAs = pyz_VelXNs + DelTimeShort * (pyz_DVelXDtNl + pyz_DVelXDtNs)
    xqz_VelYAs = xqz_VelYNs + DelTimeShort * (xqz_DVelYDtNl + xqz_DVelYDtNs)

    ! Set Margin
    !
    call SetMargin_pyz( pyz_VelXAs ) ! (inout)
    call SetMargin_xqz( xqz_VelYAs ) ! (inout)
    
    !------------------------------------------------------------
    ! Exner function
    !  ʬ֤ͤȤ. 
    !
    call Exner_HEVI

    !------------------------------------------------------------
    ! VelZ
    !
    call PGrad_VI

    ! tendency
    !
    xyr_DVelZDtNs = xyr_PGrad + xyr_SWF

    ! ͤݴ
    !
    call HistoryAutoPut(TimeN, 'VelZPGrad', xyr_PGrad(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelZSWF',   xyr_SWF(1:nx,1:ny,1:nz))

    ! Time integration
    !
    xyr_VelZAs = xyr_VelZNs + DelTimeShort * (xyr_DVelZDtNl + xyr_DVelZDtNs)

    ! Set Margin
    !
    call SetMargin_xyr( xyr_VelZAs ) ! (inout)

  contains

    subroutine VelDivC2
      
      implicit none
      integer              :: i, j, k
      
      do  k = kmin + 1, kmax 
        do j = jmin + 1, jmax 
          do i = imin + 1, imax 
            xyz_VelDivNs(i,j,k) =        &
              & + (                      &
              &     pyz_VelXNs(i,j,k)      &
              &   - pyz_VelXNs(i-1,j,k)    &
              &   ) / dx                 &
              & + (                      &
              &     xqz_VelYNs(i,j,k)      &
              &   - xqz_VelYNs(i,j-1,k)    &
              &   ) / dy                 &
              & + (                      &
              &     xyr_VelZNs(i,j,k)      &
              &   - xyr_VelZNs(i,j,k-1)    &
              &   ) / dz
          end do
        end do
      end do
      
      xyz_VelDivNs(imin,:,:) = 0.0d0 
      xyz_VelDivNs(:,jmin,:) = 0.0d0  
      xyz_VelDivNs(:,:,kmin) = 0.0d0 
      
    end subroutine VelDivC2


    subroutine PGrad_HE
    
      implicit none
      integer              :: i, j, k
      
      !------------------------------------------------------------------
      ! X 
      
      do k = kmin, kmax
        do j = jmin, jmax
          do i = imin, imax - 1

            ! ȸ
            !            
            pyz_SWF(i,j,k) =                  &
              &   Alpha                       &
              &   * (                         &
              &       xyz_VelDivNs(i+1,j,k)   &
              &     - xyz_VelDivNs(i,j,k)     &
              &     ) / dx            
            
            ! Ϸ
            !
            pyz_PGrad(i,j,k) =                &
              & - CpDry * pyz_VPTempBZ(i,j,k) &
              &   * (                         &
              &       xyz_ExnerNs(i+1,j,k)    &
              &     - xyz_ExnerNs(i,j,k)      &
              &     ) / dx                                
          end do
        end do
      end do
      
      ! 
      !
      pyz_SWF(imax,:,:)   = 0.0d0 
      pyz_PGrad(imax,:,:) = 0.0d0 
      

      !------------------------------------------------------------------
      ! Y 
      
      do k = kmin, kmax
        do j = jmin, jmax - 1
          do i = imin, imax

            ! ȸ
            !            
            xqz_SWF(i,j,k) =                  &
              &   Alpha                       &
              &   * (                         &
              &       xyz_VelDivNs(i,j+1,k)   &
              &     - xyz_VelDivNs(i,j,k)     &
              &     ) / dy
               
            ! Ϸ
            !             
            xqz_PGrad(i,j,k) =                &
              & - CpDry * xqz_VPTempBZ(i,j,k) &
              &   * (                         &
              &       xyz_ExnerNs(i,j+1,k)    &
              &     - xyz_ExnerNs(i,j,k)      &
              &     ) /dy                     
            
          end do
        end do
      end do
      
      ! 
      !
      xqz_SWF(:,jmax,:) = 0.0d0 
      xqz_PGrad(:,jmax,:) = 0.0d0 
      
    end subroutine PGrad_HE


    subroutine PGrad_VI
    
      implicit none
      integer               :: i, j, k

      do k = kmin, kmax - 1
        do j = jmin, jmax
          do i = imin, imax

            ! ȸ
            !            
            xyr_SWF(i,j,k) =                  &
              & + Alpha                       &
              &   * (                         &
              &       xyz_VelDivNs(i,j,k+1)   & 
              &     - xyz_VelDivNs(i,j,k)     & 
              &     ) / dz
            
            ! Ϸ
            !
            xyr_PGrad(i,j,k) =                 &
              & - CpDry * xyr_VPTempBZ(i,j,k)  &
              &   * (                          &
              &       beta                     &
              &       * (                      &
              &           xyz_ExnerAs(i,j,k+1) &
              &         - xyz_ExnerAs(i,j,k)   &
              &         )                      &
              &     + (1.0d0 - beta)           &
              &       * (                      &
              &           xyz_ExnerNs(i,j,k+1) &
              &         - xyz_ExnerNs(i,j,k)   &
              &         )                      &
              &     ) / dz
            
          end do
        end do
      end do
      
      xyr_PGrad(:,:,kmax) = 0.0d0
      xyr_SWF(:,:,kmax)   = 0.0d0
      
    end subroutine PGrad_VI


    subroutine Exner_HEVI
      !
      !ˡѤʡؿη׻. 
      !

      !ۤηػ
      implicit none

      !ѿ
      real(DP)               :: D1(1:nx,1:ny,1:nz)  
      real(DP)               :: D(nx*ny,nz)
      real(DP)               :: E(1:nx,1:ny,0:nz)
      real(DP)               :: F(1:nx,1:ny,1:nz)
      real(DP)               :: F0(1:nx,1:ny,kmin:kmax-1)  
      real(DP)               :: dt ! ûֳʻҴֳ
      integer                :: i, j, k
      
      real(DP)               :: X(M, N)     !/
      real(DP)               :: TX(N, M)    !ž֤
      integer                :: NRHS        
      integer                :: INFO
      integer                :: LDB
      character(1),parameter :: TRANS = 'N'
            
      ! Initialize
      !
      dt = DelTimeShort

      !---------------------------------------------------------------
      !׻Τη

      !  źϰϤ, 1:nx, 1:ny, 0:nz
      !  D(:,:,1)  D(:,:,0) ͤɬפˤʤ뤿. 
      !
      do k = 0, nz
        do j = 1, ny
          do i = 1, nx
            
            E(i,j,k) =                            &
              & - ( 1.0d0 - beta )                &
              &   * (                             &
              &     + xyz_ExnerNs(i,j,k+1)        & !
              &     - xyz_ExnerNs(i,j,k)          & ! xyz => xyr
              &     ) / dz                        &
              & + (                               &
              &   + Alpha                         &
              &     * (                           &
              &       + xyz_VelDivNs(i,j,k+1)     & !
              &       - xyz_VelDivNs(i,j,k)       & ! xyz => xyr
              &       ) / dz                      &
              &   + xyr_DVelZDtNl(i,j,k)          &
              &   ) / xyr_CpVPTempBZ(i,j,k)  
            
          end do
        end do
      end do
      
      ! ʬؿ
      !    F0 źϰϤ, 1:nx, 1:ny, kmin:kmax
      !    F ݤ F0  z ʬ뤿. 
      !
      do k = kmin, kmax-1
        do j = 1, ny
          do i = 1, nx
            
            F0(i,j,k)  =                            &
              & + xyr_DensVPTempBZ(i,j,k)           &
              &   * (                               &
              &     + xyr_VelZNs(i,j,k)             & 
              &     - xyr_CpVPTempBZ(i,j,k)         &
              &       * (1.0d0 - beta)              &
              &       * (                           &
              &           xyz_ExnerNs(i,j,k+1)      & !
              &         - xyz_ExnerNs(i,j,k)        & ! xyz => xyr
              &         ) / dz * dt                 &
              &     + Alpha                         &
              &       * (                           &
              &           xyz_VelDivNs(i,j,k+1)     &
              &         - xyz_VelDivNs(i,j,k)       &
              &         ) / dz * dt                 &
              &     + xyr_DVelZDtNl(i,j,k) * dt     &
              &     )
          end do
        end do
      end do
      
      !׻Τη
      !  źϰϤ, 1:nx, 1:ny, 1:nz
      !
      do k = 1, nz
        do j = 1, ny
          do i = 1, nx
            
            F(i,j,k) = &
              & - beta * xyz_F1BZ(i,j,k) * dt   &
              &   * (                           &
              &       F0(i,j,k)                 &
              &     - F0(i,j,k-1)               &
              &     ) / dz                      &
              & + xyz_DExnerDtNl(i,j,k) * dt 
            
          end do
        end do
      end do
    
      !׻Τη
      !  źϰϤ, 1:nx, 1:ny, 1:nz
      !
      do k = 1, nz 
        do j = 1, ny
          do i = 1, nx
            
            D1(i,j,k) =                                 &
              & + xyz_ExnerNs(i,j,k)                    &
              & - (1.0d0 - beta)                        &
              &   * xyz_F1BZ(i,j,k) * dt                &
              &   * (                                   &
              &       xyr_DensVPTempBZ(i,j,k)           &
              &       * xyr_VelZNs(i,j,k)               &
              &     - xyr_DensVPTempBZ(i,j,k-1)         &
              &       * xyr_VelZNs(i,j,k-1)             &
              &     ) / dz                              &
              & - (xyz_VelSW(i,j,k) ** 2.0d0) * dt      &
              &   / (CpDry * xyz_VPTempBZ(i,j,k))       &
              &   * (                                   &
              &     + (                                 &
              &         pyz_VelXAs(i,j,k)               &
              &       - pyz_VelXAs(i-1,j,k)             &
              &       ) / dx                            &
              &     + (                                 &
              &         xqz_VelYAs(i,j,k)               &
              &       - xqz_VelYAs(i,j-1,k)             &
              &       ) / dy                            &
              &     )                                   &
              & + F(i,j,k)
          
          end do
        end do
      end do
      
      ! ׻Τη
      !
      do j = 1, ny
        do i = 1, nx

          D1(i,j,1) =                                    &
            & + D1(i,j,1)                                &
            & - beta * xyz_F1BZ(i,j,1) * (dt ** 2.0d0)   &
            &   * xyr_CpDensVPTemp2BZ(i,j,0)             &
            &   * E(i,j,0)                               &
            &   / dz
          
          D1(i,j,nz) =                                   &
            & + D1(i,j,nz)                               &
            & + beta * xyz_F1BZ(i,j,nz) * (dt ** 2.0d0)  &
            &   * xyr_CpDensVPTemp2BZ(i,j,nz)            &
            &   * E(i,j,nz)                              &
            &   / dz
        end do
      end do
      
      !-----------------------------------------------------------
      !ϢΩ켡β
      
      !ѿν
      !
      NRHS = M
      INFO = 0
      LDB  = N
      
      ! LAPACK λͤ˹碌ѷ 
      !
      do k = 1, nz
        do j = 1, ny
          do i = 1, nx
            D(i + nx * (j - 1), k) =  D1(i,j,k)
          end do
        end do
      end do
      
      TX = transpose( D )
      
      !η׻. LAPACK . 
      !
      call DGTTRS(TRANS, N, NRHS, C, A, B, AL1, IP, TX, LDB, INFO)
      
      !Υǥå. 
      !
!    if (INFO /= 0) then
!      call MessageNotify("Error", "lapack_linear", "INFO is not 0")
!      stop
!    end if

      !ͤ
      !
      X = transpose( TX )
      
      do k = 1, nz
        do j = 1, ny
          do i = 1, nx
            xyz_ExnerAs(i,j,k) = X(i + nx * (j - 1 ), k)
          end do
        end do
      end do

      xyz_ExnerAs(imin:0,:,:) = 0.0d0
      xyz_ExnerAs(:,jmin:0,:) = 0.0d0
      xyz_ExnerAs(:,:,kmin:0) = 0.0d0
      xyz_ExnerAs(nx+1:imax,:,:) = 0.0d0
      xyz_ExnerAs(:,ny+1:jmax,:) = 0.0d0
      xyz_ExnerAs(:,:,nz+1:kmax) = 0.0d0
      
      ! Τͤ
      !
      call SetMargin_xyz( xyz_ExnerAs ) ! (inout)
      
    end subroutine Exner_HEVI
    
  end subroutine Dynamics_Short_integrate
  
  
!!!--------------------------------------------------------------------!!!

  subroutine Dynamics2D_Short_integrate(  &
        &  pyz_VelXNs,          & ! (in)
        &  xyr_VelZNs,          & ! (in)
        &  xyz_ExnerNs,         & ! (in)
        &  pyz_DVelXDtNl,       & ! (in)
        &  xyr_DVelZDtNl,       & ! (in)
        &  xyz_DExnerDtNl,      & ! (in)
        &  pyz_VelXAs,          & ! (out)
        &  xqz_VelYAs,          & ! (out)
        &  xyr_VelZAs,          & ! (out)
        &  xyz_ExnerAs          & ! (out)
        & )

    implicit none

    real(DP), intent(in)     :: pyz_VelXNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)     :: xyr_VelZNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)     :: xyz_ExnerNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)     :: pyz_DVelXDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)     :: xyr_DVelZDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)     :: xyz_DExnerDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)    :: pyz_VelXAs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)    :: xqz_VelYAs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)    :: xyr_VelZAs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out)    :: xyz_ExnerAs(imin:imax,jmin:jmax,kmin:kmax)

    real(DP) :: pyz_DVelXDtNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyr_DVelZDtNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyz_VelDivNs(imin:imax,jmin:jmax,kmin:kmax)

    real(DP) :: pyz_PGrad(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyr_PGrad(imin:imax,jmin:jmax,kmin:kmax)

    real(DP) :: pyz_SWF(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyr_SWF(imin:imax,jmin:jmax,kmin:kmax)


    !------------------------------------------------------------
    ! initialize: Divergence of velocity
    !
    call VelDivC2

    !------------------------------------------------------------
    ! VelX, VelY
    !  ʿ۲ˡǲ. 
    !
    call PGrad_HE

    ! tendency 
    !
    pyz_DVelXDtNs = pyz_PGrad + pyz_SWF

    ! ͤݴ
    !
    call HistoryAutoPut(TimeN, 'VelXPGrad', pyz_PGrad(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelXSWF',   pyz_SWF(1:nx,1:ny,1:nz))

    ! Time integration
    !
    pyz_VelXAs = pyz_VelXNs + DelTimeShort * (pyz_DVelXDtNl + pyz_DVelXDtNs)

    ! Set Margin
    !
    call SetMargin_pyz( pyz_VelXAs ) ! (inout)

    ! Y ˤͤ
    xqz_VelYAs = 0.0d0

    
    !------------------------------------------------------------
    ! Exner function
    !  ʬ֤ͤȤ. 
    !
    call Exner_HEVI

    !------------------------------------------------------------
    ! VelZ
    !
    call PGrad_VI

    ! tendency
    !
    xyr_DVelZDtNs = xyr_PGrad + xyr_SWF

    ! ͤݴ
    !
    call HistoryAutoPut(TimeN, 'VelZPGrad', xyr_PGrad(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelZSWF',   xyr_SWF(1:nx,1:ny,1:nz))

    ! Time integration
    !
    xyr_VelZAs = xyr_VelZNs + DelTimeShort * (xyr_DVelZDtNl + xyr_DVelZDtNs)

    ! Set Margin
    !
    call SetMargin_xyr( xyr_VelZAs ) ! (inout)

  contains

    subroutine VelDivC2
      
      implicit none
      integer              :: i, j, k
      
      do  k = kmin + 1, kmax 
        do j = 1, ny
          do i = imin + 1, imax 
            xyz_VelDivNs(i,j,k) =        &
              & + (                      &
              &     pyz_VelXNs(i,j,k)      &
              &   - pyz_VelXNs(i-1,j,k)    &
              &   ) / dx                 &
              & + (                      &
              &     xyr_VelZNs(i,j,k)      &
              &   - xyr_VelZNs(i,j,k-1)    &
              &   ) / dz
          end do
        end do
      end do
      
      xyz_VelDivNs(imin,:,:) = 0.0d0 
      xyz_VelDivNs(:,:,kmin) = 0.0d0 
      
    end subroutine VelDivC2


    subroutine PGrad_HE
      
      implicit none
      integer              :: i, j, k
      
      !------------------------------------------------------------------
      ! X 
      
      do k = kmin, kmax
        do j = 1, ny          
          do i = imin, imax - 1

            ! ȸ
            !            
            pyz_SWF(i,j,k) =                  &
              &   Alpha                       &
              &   * (                         &
              &       xyz_VelDivNs(i+1,j,k)   &
              &     - xyz_VelDivNs(i,j,k)     &
              &     ) / dx            
            
            ! Ϸ
            !
            pyz_PGrad(i,j,k) =                &
              & - CpDry * pyz_VPTempBZ(i,j,k) &
              &   * (                         &
              &       xyz_ExnerNs(i+1,j,k)    &
              &     - xyz_ExnerNs(i,j,k)      &
              &     ) / dx                                
          end do
        end do
      end do
      
      ! 
      !
      pyz_SWF(imax,:,:)   = 0.0d0 
      pyz_PGrad(imax,:,:) = 0.0d0 
      
    end subroutine PGrad_HE


    subroutine PGrad_VI
    
      implicit none
      integer               :: i, j, k

      do k = kmin, kmax - 1
        do j = 1, ny          
          do i = imin, imax

            ! ȸ
            !            
            xyr_SWF(i,j,k) =                  &
              & + Alpha                       &
              &   * (                         &
              &       xyz_VelDivNs(i,j,k+1)   & 
              &     - xyz_VelDivNs(i,j,k)     & 
              &     ) / dz
            
            ! Ϸ
            !
            xyr_PGrad(i,j,k) =                 &
              & - CpDry * xyr_VPTempBZ(i,j,k)  &
              &   * (                          &
              &       beta                     &
              &       * (                      &
              &           xyz_ExnerAs(i,j,k+1) &
              &         - xyz_ExnerAs(i,j,k)   &
              &         )                      &
              &     + (1.0d0 - beta)           &
              &       * (                      &
              &           xyz_ExnerNs(i,j,k+1) &
              &         - xyz_ExnerNs(i,j,k)   &
              &         )                      &
              &     ) / dz
            
          end do
        end do
      end do
      
      xyr_PGrad(:,:,kmax) = 0.0d0
      xyr_SWF(:,:,kmax)   = 0.0d0
      
    end subroutine PGrad_VI


    subroutine Exner_HEVI
      !
      !ˡѤʡؿη׻. 
      !

      !ۤηػ
      implicit none

      !ѿ
      real(DP)               :: D1(1:nx,1:ny,1:nz)  
      real(DP)               :: D(nx*ny,nz)
      real(DP)               :: E(1:nx,1:ny,0:nz)
      real(DP)               :: F(1:nx,1:ny,1:nz)
      real(DP)               :: F0(1:nx,1:ny,kmin:kmax-1)  
      real(DP)               :: dt ! ûֳʻҴֳ
      integer                :: i, j, k
      
      real(DP)               :: X(M, N)     !/
      real(DP)               :: TX(N, M)    !ž֤
      integer                :: NRHS        
      integer                :: INFO
      integer                :: LDB
      character(1),parameter :: TRANS = 'N'
      
      
      ! Initialize
      !
      dt = DelTimeShort

      !---------------------------------------------------------------
      !׻Τη

      !  źϰϤ, 1:nx, 1:ny, 0:nz
      !  D(:,:,1)  D(:,:,0) ͤɬפˤʤ뤿. 
      !
      do k = 0, nz
        do j = 1, ny
          do i = 1, nx
            
            E(i,j,k) =                            &
              & - ( 1.0d0 - beta )                &
              &   * (                             &
              &     + xyz_ExnerNs(i,j,k+1)        & !
              &     - xyz_ExnerNs(i,j,k)          & ! xyz => xyr
              &     ) / dz                        &
              & + (                               &
              &   + Alpha                         &
              &     * (                           &
              &       + xyz_VelDivNs(i,j,k+1)     & !
              &       - xyz_VelDivNs(i,j,k)       & ! xyz => xyr
              &       ) / dz                      &
              &   + xyr_DVelZDtNl(i,j,k)          &
              &   ) / xyr_CpVPTempBZ(i,j,k)  
            
          end do
        end do
      end do
      
      ! ʬؿ
      !    F0 źϰϤ, 1:nx, 1:ny, kmin:kmax
      !    F ݤ F0  z ʬ뤿. 
      !
      do k = kmin, kmax-1
        do j = 1, ny
          do i = 1, nx
            
            F0(i,j,k)  =                            &
              & + xyr_DensVPTempBZ(i,j,k)           &
              &   * (                               &
              &     + xyr_VelZNs(i,j,k)             & 
              &     - xyr_CpVPTempBZ(i,j,k)         &
              &       * (1.0d0 - beta)              &
              &       * (                           &
              &           xyz_ExnerNs(i,j,k+1)      & !
              &         - xyz_ExnerNs(i,j,k)        & ! xyz => xyr
              &         ) / dz * dt                 &
              &     + Alpha                         &
              &       * (                           &
              &           xyz_VelDivNs(i,j,k+1)     &
              &         - xyz_VelDivNs(i,j,k)       &
              &         ) / dz * dt                 &
              &     + xyr_DVelZDtNl(i,j,k) * dt     &
              &     )
          end do
        end do
      end do
      
      !׻Τη
      !  źϰϤ, 1:nx, 1:ny, 1:nz
      !
      do k = 1, nz
        do j = 1, ny
          do i = 1, nx
            
            F(i,j,k) = &
              & - beta * xyz_F1BZ(i,j,k) * dt   &
              &   * (                           &
              &       F0(i,j,k)                 &
              &     - F0(i,j,k-1)               &
              &     ) / dz                      &
              & + xyz_DExnerDtNl(i,j,k) * dt 
            
          end do
        end do
      end do
    
      !׻Τη
      !  źϰϤ, 1:nx, 1:ny, 1:nz
      !
      do k = 1, nz 
        do j = 1, ny
          do i = 1, nx
            
            D1(i,j,k) =                                 &
              & + xyz_ExnerNs(i,j,k)                    &
              & - (1.0d0 - beta)                        &
              &   * xyz_F1BZ(i,j,k) * dt                &
              &   * (                                   &
              &       xyr_DensVPTempBZ(i,j,k)           &
              &       * xyr_VelZNs(i,j,k)               &
              &     - xyr_DensVPTempBZ(i,j,k-1)         &
              &       * xyr_VelZNs(i,j,k-1)             &
              &     ) / dz                              &
              & - (xyz_VelSW(i,j,k) ** 2.0d0) * dt      &
              &   / (CpDry * xyz_VPTempBZ(i,j,k))       &
              &   * (                                   &
              &     + (                                 &
              &         pyz_VelXAs(i,j,k)               &
              &       - pyz_VelXAs(i-1,j,k)             &
              &       ) / dx                            &
              &     )                                   &
              & + F(i,j,k)
          
          end do
        end do
      end do
      
      ! ׻Τη
      !
      do j = 1, ny
        do i = 1, nx

          D1(i,j,1) =                                    &
            & + D1(i,j,1)                                &
            & - beta * xyz_F1BZ(i,j,1) * (dt ** 2.0d0)   &
            &   * xyr_CpDensVPTemp2BZ(i,j,0)             &
            &   * E(i,j,0)                               &
            &   / dz
          
          D1(i,j,nz) =                                   &
            & + D1(i,j,nz)                               &
            & + beta * xyz_F1BZ(i,j,nz) * (dt ** 2.0d0)  &
            &   * xyr_CpDensVPTemp2BZ(i,j,nz)            &
            &   * E(i,j,nz)                              &
            &   / dz
        end do
      end do
      
      !-----------------------------------------------------------
      !ϢΩ켡β
      
      !ѿν
      !
      NRHS = M
      INFO = 0
      LDB  = N
      
      ! LAPACK λͤ˹碌ѷ 
      !
      do k = 1, nz
        do j = 1, ny
          do i = 1, nx
            D(i + nx * (j - 1), k) =  D1(i,j,k)
          end do
        end do
      end do
      
      TX = transpose( D )
      
      !η׻. LAPACK . 
      !
      call DGTTRS(TRANS, N, NRHS, C, A, B, AL1, IP, TX, LDB, INFO)
      
      !Υǥå. 
      !
!    if (INFO /= 0) then
!      call MessageNotify("Error", "lapack_linear", "INFO is not 0")
!      stop
!    end if

      !ͤ
      !
      X = transpose( TX )
      
      do k = 1, nz
        do j = 1, ny
          do i = 1, nx
            xyz_ExnerAs(i,j,k) = X(i + nx * (j - 1 ), k)
          end do
        end do
      end do
      xyz_ExnerAs(imin:0,:,:) = 0.0d0
      xyz_ExnerAs(:,:,kmin:0) = 0.0d0
      xyz_ExnerAs(nx+1:imax,:,:) = 0.0d0
      xyz_ExnerAs(:,:,nz+1:kmax) = 0.0d0
      
      ! Τͤ
      !
      call SetMargin_xyz( xyz_ExnerAs ) ! (inout)
      
    end subroutine Exner_HEVI
    
  end subroutine Dynamics2D_Short_integrate

  
!!!--------------------------------------------------------------------!!!
  subroutine Dynamics_VI_init()
    !
    !ʡؿ򱢲ˡǲ򤯺ݤɬפȤʤ, Ǥ, 
    !LU ʬԤ. 
    !

    !ۤηػ
    implicit none

    real(DP)  :: dt      ! ûֳʻ
    integer   :: INFO  !Υǥå
    integer   :: i, j, k

    !----------------------------------------------------------------
    ! 

    ! ѿ̾ĹΤ, ֤̾
    !
    dt = DelTimeShort

    ! γդ
    !
    allocate( A(1:nz) )
    allocate( B(2:nz) )
    allocate( C(1:nz-1) )
    allocate( xyz_F1BZ(1:nx,1:ny,1:nz) )
    allocate( xyr_CpDensVPTemp2BZ(1:nx,1:ny,kmin:kmax) )
    allocate( xyr_DensVPTempBZ(1:nx,1:ny,kmin:kmax) )
    allocate( xyr_CpVPTempBZ(1:nx,1:ny,kmin:kmax) )

    !----------------------------------------------------------------
    ! 󤪤Ӷ̤Ѥͤ
    !   A, B, C , ܾ (BZ) ̤ X ˰ͤʤΤ. 
    !   nx, ny ͤɽ뤳ȤȤ. 
    !
    do k = 1, nz
      do j = 1, ny
        do i = 1, nx
          xyz_F1BZ(i,j,k) =                                                    &
            &  ( xyz_VelSW(i,j,k) ** 2.0d0 )                                   &
            &  / ( CpDry * xyz_DensBZ(i,j,k) * (xyz_VPTempBZ(i,j,k) ** 2.0d0) )
        end do
      end do
    end do

    do k = kmin, kmax - 1
      do j = 1, ny        
        do i = 1, nx
          xyr_CpDensVPTemp2BZ(i,j,k)=                    &
            &  CpDry                                     &
            &  * (                                       &
            &    + xyz_DensBZ(i,j,k+1)                   &
            &      * ( xyz_VPTempBZ(i,j,k+1) ** 2.0d0 )  &
            &    + xyz_DensBZ(i,j,k)                     &
            &      * ( xyz_VPTempBZ(i,j,k) ** 2.0d0 )    &
            &    ) * 5.0d-1
        end do
      end do
    end do
    xyr_CpDensVPTemp2BZ(:,:,kmax) = 0.0d0  !
    
    do k = kmin, kmax-1
      do j = 1, ny
        do i = 1, nx
          xyr_DensVPTempBZ(i,j,k) =                             &
            & + (                                               &
            &   + xyz_DensBZ(i,j,k+1) * xyz_VPTempBZ(i,j,k+1)   &
            &   + xyz_DensBZ(i,j,k)   * xyz_VPTempBZ(i,j,k)     &
            &   ) * 5.0d-1    
        end do
      end do
    end do
    xyr_DensVPTempBZ(:,:,kmax) = 0.0d0  !

    do k = kmin, kmax-1
      do j = 1, ny
        do i = 1, nx
          xyr_CpVPTempBZ(i,j,k) =          &
            &   CpDry                      &
            &   * (                        &
            &     + xyz_VPTempBZ(i,j,k+1)  &
            &     + xyz_VPTempBZ(i,j,k)    &
            &     ) * 5.0d-1
        end do
      end do
    end do
    xyr_CpVPTempBZ(:,:,kmax) = 0.0d0
          
    do k = 2, nz-1
      A(k) =                                        &
        & + 1.0d0                                   &
        & + ( beta ** 2.0d0 )                       &
        &    * xyz_F1BZ(nx,ny,k) * ( dt * dt )      &
        &    * (                                    &
        &         xyr_CpDensVPTemp2BZ(nx,ny,k)      &
        &       + xyr_CpDensVPTemp2BZ(nx,ny,k-1)    &
        &       )                                   &
        &    / ( dz * dz )
    end do

    A(1) =                                   &
      & + 1.0d0                              &
      & + ( beta ** 2.0d0 )                  &
      &   * xyz_F1BZ(nx,ny,1) * ( dt * dt )  &
      &   * xyr_CpDensVPTemp2BZ(nx,ny,1)     &
      &   / ( dz * dz ) 

    A(nz) =                                  &
      & + 1.0d0                              &
      & + ( beta ** 2.0d0 )                  &
      &   * xyz_F1BZ(nx,ny,nz) * ( dt * dt ) &
      &   * xyr_CpDensVPTemp2BZ(nx,ny,nz-1)  &
      &   / ( dz * dz )  

    do k = 2, nz
      B(k) =                                     &
        & - ( beta ** 2.0d0 )                    &
        &   * xyz_F1BZ(nx,ny,k-1) * ( dt * dt )  &
        &   * xyr_CpDensVPTemp2BZ(nx,ny,k-1)     &
        &   / ( dz * dz )
    end do
    
    do k = 1, nz-1
      C(k) =                                     &
        & - ( beta ** 2.0d0 )                    &
        &   * xyz_F1BZ(nx,ny,k+1) * (dt * dt )   &
        &   * xyr_CpDensVPTemp2BZ(nx,ny,k)       &
        &   / ( dz * dz )
    end do

    !----------------------------------------------------------------
    !  LU ʬ
    !
    !礭ݴ
    N    = nz                   !/μ, ˡ
    M    = nx * ny              !ȿ
    NUD  = 1                    !ξ廰ʬ
    NLD  = 1                    !βʬ
    NAL  = NLD                  !LU ʬη L ˡ
    NA   = NUD + NLD + 1
    INFO = 0

    ! γ
    !
    allocate( AL1(N), IP(N) )

    ! η׻. LAPACK . 
    !
    call DGTTRF(N, C, A, B, AL1, IP, INFO)
    
    ! Υǥå. 
    !
    if (INFO /= 0) then
      call MessageNotify("Error", "lapack_linear", "INFO is not 0")
      stop
    end if
    
  end subroutine Dynamics_VI_init
  


  subroutine Dynamics_Tendency_Output

    implicit none
    
    integer :: f

    call HistoryAutoAddVariable(  &
      & varname='PTempAdv', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Advection term of potential temperature',  &
      & units='K.s-1',    &
      & xtype='float')
    
    call HistoryAutoAddVariable(  &
      & varname='PTempNDiff',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Numerical diffusion term of potential temperature',&
      & units='K.s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='ExnerAdv', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Advection term of exner function',  &
      & units='s-1',    &
      & xtype='float')
    
    call HistoryAutoAddVariable(  &
      & varname='ExnerNDiff',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Numerical diffusion term of exner function',&
      & units='s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='CDensAdv', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Advection term of cloud density',  &
      & units='kg.m-3.s-1',    &
      & xtype='float')
    
    call HistoryAutoAddVariable(  &
      & varname='CDensNDiff',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Numerical diffusion term of cloud density',&
      & units='kg.m-3.s-1',    &
      & xtype='float')

    do f = 1, ncmax
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(f))//'_Adv', &
        & dims=(/'x','y','z','t'/),     &
        & longname='Advection term of '          &
        &           //trim(SpcWetSymbol(f))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='float')
      
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(f))//'_NDiff', & 
        & dims=(/'x','y','z','t'/),     &
        & longname='Diffusion term of '          &
        &           //trim(SpcWetSymbol(f))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='float')

    end do

    call HistoryAutoAddVariable(  &
      & varname='VelXAdv', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Advection term of velocity (x)',  &
      & units='m.s-2',    &
      & xtype='float')
    
    call HistoryAutoAddVariable(  &
      & varname='VelXNDiff',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Numerical diffusion term of velocity (x)',&
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelXPGrad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Pressure gradient term of velocity (x)',  &
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelXSWF', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Filter for acoustic mode (x)',  &
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelYAdv', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Advection term of velocity (y)',  &
      & units='m.s-2',    &
      & xtype='float')
    
    call HistoryAutoAddVariable(  &
      & varname='VelYNDiff',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Numerical diffusion term of velocity (y)',&
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelYPGrad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Pressure gradient term of velocity (y)',  &
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelYSWF', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Filter for acoustic mode (y)',  &
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelZAdv', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Advection term of velocity (z)',  &
      & units='m.s-2',    &
      & xtype='float')
    
    call HistoryAutoAddVariable(  &
      & varname='VelZNDiff',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Numerical diffusion term of Velocity (z)',&
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelZBuoyT',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Buoyancy (Temperature)',&
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelZBuoyM',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Buoyancy (MolWt)',&
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelZBuoyD',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Buoyancy (Drag)',&
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelZPGrad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Pressure gradient term of velocity (z)',  &
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelZSWF', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Filter for acoustic mode (z)',  &
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='KmAdv', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Advection of Km',  &
      & units='s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='KmNDiff', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Diffusion term of Km',  &
      & units='s-1',    &
      & xtype='float')

  end subroutine Dynamics_Tendency_Output


  subroutine CHK_Val(xyz_Var1, xyz_Var2, info)

    real(DP), intent(in)      :: xyz_Var1(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)      :: xyz_Var2(imin:imax,jmin:jmax,kmin:kmax)
    character(15), intent(in) :: info

    integer  :: min1(3), min2(3), max1(3), max2(3)
    real(DP) :: tmp1(nx,ny,nz), tmp2(nx,ny,nz)

    real(DP), parameter :: EPS = 1.0d-12

    tmp1 = xyz_Var1(1:nx,1:ny,1:nz) - xyz_Var2(1:nx,1:ny,1:nz)
    tmp2 = (xyz_Var1(1:nx,1:ny,1:nz) - xyz_Var2(1:nx,1:ny,1:nz)) / (xyz_Var2(1:nx,1:ny,1:nz) + 1.0d-60)
    min1 = minloc(tmp1); min2 = minloc(tmp2)
    max1 = maxloc(tmp1); max2 = maxloc(tmp2)

    if (     abs(minval( tmp1 )) > EPS &
      & .OR. abs(maxval( tmp1 )) > EPS &
      & .OR. abs(minval( tmp2 )) > EPS &
      & .OR. abs(maxval( tmp2 )) > EPS ) then 

      write(*,*) "***", info
      write(*,*) minval( tmp1 ), maxval( tmp1 ), minval( tmp2 ), maxval( tmp2 )
      write(*,*) min1, tmp1(min1(1),min1(2),min1(3)), xyz_Var1(min1(1),min1(2),min1(3)), xyz_Var2(min1(1),min1(2),min1(3))
      write(*,*) max1, tmp1(max1(1),max1(2),max1(3)), xyz_Var1(max1(1),max1(2),max1(3)), xyz_Var2(max1(1),max1(2),max1(3))
      write(*,*) min2, tmp2(min2(1),min2(2),min2(3)), xyz_Var1(min2(1),min2(2),min2(3)), xyz_Var2(min2(1),min2(2),min2(3))
      write(*,*) max2, tmp2(max2(1),max2(2),max2(3)), xyz_Var1(max2(1),max2(2),max2(3)), xyz_Var2(max2(1),max2(2),max2(3))
    end if

  end subroutine CHK_Val

  subroutine CHK2_Val(xyz_Var1, xyz_Var2, info)

    real(DP), intent(in)      :: xyz_Var1(nx,ny,nz)
    real(DP), intent(in)      :: xyz_Var2(nx,ny,nz)
    character(15), intent(in) :: info

    real(DP), parameter :: EPS = 1.0d-12

    integer  :: min1(3), min2(3), max1(3), max2(3)
    real(DP) :: tmp1(nx,ny,nz), tmp2(nx,ny,nz)

    tmp1 = xyz_Var1(1:nx,1:ny,1:nz) - xyz_Var2(1:nx,1:ny,1:nz)
    tmp2 = (xyz_Var1(1:nx,1:ny,1:nz) - xyz_Var2(1:nx,1:ny,1:nz)) / (xyz_Var2(1:nx,1:ny,1:nz) + 1.0d-60)
    min1 = minloc(tmp1); min2 = minloc(tmp2)
    max1 = maxloc(tmp1); max2 = maxloc(tmp2)

    if (     abs(minval( tmp1 )) > EPS &
      & .OR. abs(maxval( tmp1 )) > EPS &
      & .OR. abs(minval( tmp2 )) > EPS &
      & .OR. abs(maxval( tmp2 )) > EPS ) then     

      write(*,*) "***", info
      write(*,*) minval( tmp1 ), maxval( tmp1 ), minval( tmp2 ), maxval( tmp2 )
      write(*,*) min1, tmp1(min1(1),min1(2),min1(3)), xyz_Var1(min1(1),min1(2),min1(3)), xyz_Var2(min1(1),min1(2),min1(3))
      write(*,*) max1, tmp1(max1(1),max1(2),max1(3)), xyz_Var1(max1(1),max1(2),max1(3)), xyz_Var2(max1(1),max1(2),max1(3))
      write(*,*) min2, tmp2(min2(1),min2(2),min2(3)), xyz_Var1(min2(1),min2(2),min2(3)), xyz_Var2(min2(1),min2(2),min2(3))
      write(*,*) max2, tmp2(max2(1),max2(2),max2(3)), xyz_Var1(max2(1),max2(2),max2(3)), xyz_Var2(max2(1),max2(2),max2(3))
    end if

  end subroutine CHK2_Val

  
end module DynamicsHEVI

