module gms_math_times
  use datatype
  use mem_manager
  implicit none
  integer :: ix, iy, iz

  interface operator(*)
  module procedure times_x_x, times_x_y, times_x_z, times_x_xy, times_x_xz, times_x_yz, times_x_xyz
  module procedure times_y_x, times_y_y, times_y_z, times_y_xy, times_y_xz, times_y_yz, times_y_xyz
  module procedure times_z_x, times_z_y, times_z_z, times_z_xy, times_z_xz, times_z_yz, times_z_xyz
  module procedure times_xy_x, times_xy_y, times_xy_z, times_xy_xy, times_xy_xz, times_xy_yz, times_xy_xyz
  module procedure times_xz_x, times_xz_y, times_xz_z, times_xz_xy, times_xz_xz, times_xz_yz, times_xz_xyz
  module procedure times_yz_x, times_yz_y, times_yz_z, times_yz_xy, times_yz_xz, times_yz_yz, times_yz_xyz
  module procedure times_xyz_x, times_xyz_y, times_xyz_z, times_xyz_xy, times_xyz_xz, times_xyz_yz, times_xyz_xyz
  module procedure times_real_x, times_real_y, times_real_z, times_real_xy, times_real_xz, times_real_yz, times_real_xyz
  module procedure times_x_real, times_y_real, times_z_real, times_xy_real, times_xz_real, times_yz_real, times_xyz_real
  end interface
contains
  function times_x_x(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_x)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"

    call get_new_id_x(new_id)
    output%id = new_id 

        do ix = lb_axis1, ub_axis1

        work_x(ix, 1, 1, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      * work_x(ix, 1, 1, input2%id)
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = -1
  end function times_x_x

  function times_x_y(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      * work_y(1, iy, 1, input2%id)
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = -1
  end function times_x_y

  function times_x_z(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      * work_z(1, 1, iz, input2%id)
        end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = input2%grid(3)
  end function times_x_z

  function times_x_xy(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      * work_xy(ix, iy, 1, input2%id)
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = -1
  end function times_x_xy

  function times_x_xz(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      * work_xz(ix, 1, iz, input2%id)
        end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = input2%grid(3)
  end function times_x_xz

  function times_x_yz(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      * work_yz(1, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input2%grid(3)
  end function times_x_yz

  function times_x_xyz(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      * work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input2%grid(3)
  end function times_x_xyz

  function times_x_real(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_x)             :: output 

    integer :: new_id

    call get_new_id_x(new_id)
    output%id = new_id 

        do ix = lb_axis1, ub_axis1

        work_x(ix, 1, 1, new_id) & 
                      = work_x(ix, 1, 1, input1%id) *input2
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = -1
  end function times_x_real

  function times_y_x(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      * work_x(ix, 1, 1, input2%id)
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function times_y_x

  function times_y_y(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_y)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"

    call get_new_id_y(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2

        work_y(1, iy, 1, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      * work_y(1, iy, 1, input2%id)
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function times_y_y

  function times_y_z(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      * work_z(1, 1, iz, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function times_y_z

  function times_y_xy(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      * work_xy(ix, iy, 1, input2%id)
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function times_y_xy

  function times_y_xz(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      * work_xz(ix, 1, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function times_y_xz

  function times_y_yz(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      * work_yz(1, iy, iz, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function times_y_yz

  function times_y_xyz(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      * work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function times_y_xyz

  function times_y_real(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_y)             :: output 

    integer :: new_id

    call get_new_id_y(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2

        work_y(1, iy, 1, new_id) & 
                      = work_y(1, iy, 1, input1%id) *input2
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function times_y_real

  function times_z_x(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      * work_x(ix, 1, 1, input2%id)
        end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function times_z_x

  function times_z_y(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      * work_y(1, iy, 1, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_z_y

  function times_z_z(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_z)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_z(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3

        work_z(1, 1, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      * work_z(1, 1, iz, input2%id)
        end do

    output%grid(1) = -1
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function times_z_z

  function times_z_xy(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      * work_xy(ix, iy, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_z_xy

  function times_z_xz(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      * work_xz(ix, 1, iz, input2%id)
        end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function times_z_xz

  function times_z_yz(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      * work_yz(1, iy, iz, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_z_yz

  function times_z_xyz(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      * work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_z_xyz

  function times_z_real(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_z)             :: output 

    integer :: new_id

    call get_new_id_z(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3

        work_z(1, 1, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) *input2
        end do

    output%grid(1) = -1
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function times_z_real

  function times_xy_x(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      * work_x(ix, 1, 1, input2%id)
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function times_xy_x

  function times_xy_y(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      * work_y(1, iy, 1, input2%id)
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function times_xy_y

  function times_xy_z(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      * work_z(1, 1, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function times_xy_z

  function times_xy_xy(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      * work_xy(ix, iy, 1, input2%id)
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function times_xy_xy

  function times_xy_xz(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      * work_xz(ix, 1, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function times_xy_xz

  function times_xy_yz(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      * work_yz(1, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function times_xy_yz

  function times_xy_xyz(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      * work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function times_xy_xyz

  function times_xy_real(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) *input2
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function times_xy_real

  function times_xz_x(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      * work_x(ix, 1, 1, input2%id)
        end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function times_xz_x

  function times_xz_y(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      * work_y(1, iy, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_xz_y

  function times_xz_z(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      * work_z(1, 1, iz, input2%id)
        end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function times_xz_z

  function times_xz_xy(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      * work_xy(ix, iy, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_xz_xy

  function times_xz_xz(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      * work_xz(ix, 1, iz, input2%id)
        end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function times_xz_xz

  function times_xz_yz(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      * work_yz(1, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_xz_yz

  function times_xz_xyz(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      * work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_xz_xyz

  function times_xz_real(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) *input2
        end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function times_xz_real

  function times_yz_x(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      * work_x(ix, 1, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_yz_x

  function times_yz_y(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      * work_y(1, iy, 1, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_yz_y

  function times_yz_z(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      * work_z(1, 1, iz, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_yz_z

  function times_yz_xy(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      * work_xy(ix, iy, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_yz_xy

  function times_yz_xz(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      * work_xz(ix, 1, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_yz_xz

  function times_yz_yz(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      * work_yz(1, iy, iz, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_yz_yz

  function times_yz_xyz(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      * work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_yz_xyz

  function times_yz_real(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) *input2
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_yz_real

  function times_xyz_x(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      * work_x(ix, 1, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_xyz_x

  function times_xyz_y(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      * work_y(1, iy, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_xyz_y

  function times_xyz_z(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      * work_z(1, 1, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_xyz_z

  function times_xyz_xy(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      * work_xy(ix, iy, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_xyz_xy

  function times_xyz_xz(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      * work_xz(ix, 1, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_xyz_xz

  function times_xyz_yz(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      * work_yz(1, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_xyz_yz

  function times_xyz_xyz(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(*)grid violation"
    if ( input1%grid(2) /= input2%grid(2) ) stop "(*)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(*)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      * work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_xyz_xyz

  function times_xyz_real(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) *input2
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function times_xyz_real

  function times_real_x(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_x)             :: output 

    integer :: new_id

    call get_new_id_x(new_id)
    output%id = new_id 

        do ix = lb_axis1, ub_axis1

        work_x(ix, 1, 1, new_id) & 
                      = input1 * work_x(ix, 1, 1, input2%id)
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = -1
    output%grid(3) = -1
  end function times_real_x

  function times_real_y(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_y)             :: output 

    integer :: new_id

    call get_new_id_y(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2

        work_y(1, iy, 1, new_id) & 
                      = input1 * work_y(1, iy, 1, input2%id)
      end do

    output%grid(1) = -1
    output%grid(2) = input2%grid(2)
    output%grid(3) = -1
  end function times_real_y

  function times_real_z(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_z)             :: output 

    integer :: new_id

    call get_new_id_z(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3

        work_z(1, 1, iz, new_id) & 
                      = input1 * work_z(1, 1, iz, input2%id)
        end do

    output%grid(1) = -1
    output%grid(2) = -1
    output%grid(3) = input2%grid(3)
  end function times_real_z

  function times_real_xy(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = input1 * work_xy(ix, iy, 1, input2%id)
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = -1
  end function times_real_xy

  function times_real_xz(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = input1 * work_xz(ix, 1, iz, input2%id)
        end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = -1
    output%grid(3) = input2%grid(3)
  end function times_real_xz

  function times_real_yz(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = input1 * work_yz(1, iy, iz, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input2%grid(2)
    output%grid(3) = input2%grid(3)
  end function times_real_yz

  function times_real_xyz(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = input1 * work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input2%grid(3)
  end function times_real_xyz

end module gms_math_times
