! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine ANVarClose(var, err)
    use an_types, only: AN_VARIABLE
    use an_file, only: ANFileClose, ANFileSync
    type(AN_VARIABLE), intent(inout):: var
    logical, intent(out), optional:: err
continue
    if (var%fileid <= 0) return
    call ANFileSync(var%fileid)
    if (.not. associated(var%allcount)) return
    deallocate(var%allcount, var%start, var%count, var%stride, var%dimids)
    call ANFileClose(var%fileid, err)
    var%fileid = 0
    var%varid = 0
    var%dimid = 0
end subroutine
