program gt3test
    use gt3read
    use gt3conv_tools
    use gtool
    use gtool_history

    implicit none
    type(VSTRING):: argument
    type(GT3_FILE):: file
    type(GT3_HEADER):: header

    integer:: i,idim, ia
    integer, pointer:: dimsizes_table(:)
    character(len=3), pointer:: dimname_table(:)
    character(len=9), pointer:: longname_table(:)
    character(len=12), pointer:: unit_table(:)
    real, pointer:: buffer(:, :, :)
    logical:: fail
    character(len = 78):: input_filename
    character(len = 78):: filename = "gtool.nc"
    character(len = 78):: user = "momoko"
    real:: dt = 1.0

    ! ɤ߹(ǽΰե̾)
    do, i = 1, GtArgCount()
        call GtArgGet(i, argument)
	input_filename = argument
    enddo

    ! gtool3 ե header ɤ: Dimtable .
    call Open(file, input_filename)
    do
	call GetHeader(file, header, fail)
	if (fail) exit
        do, ia=1,3
             call StoreDimension(header, ia)
        end do
        ! إåɤϿƤʤäϿȤ
        ! (ǤϤʤäƤĤ)ޤ
        ! äƤʤ
        goto 999
    enddo
    999 continue
    call Close(file)
    ! Close ʤ rewind ɤ󤸤ʤ?
    
    ! ǡκ
    do, idim = 1, size(dims_table)
	dims_table(idim)%name = Dimname3to4(dims_table(idim)%item, dims_table(1: idim-1)%name)
    enddo
    
    do, idim = 1, size(dims_table)
        call ReadAxisFile(dims_table(idim))
    enddo

    ! gtool4 եؤν
    ! ⤦äȥޡȤˤǤ󤫤ͤ.
    ! ΤˤĹǤ....
    allocate(dimsizes_table(size(dims_table)+1))
    allocate(dimname_table(size(dims_table)+1))
    allocate(longname_table(size(dims_table)+1))
    allocate(unit_table(size(dims_table)+1))

    do, idim = 1,size(dims_table)
        dimsizes_table(idim) = dims_table(idim)%dim
    enddo
    dimsizes_table(size(dims_table)+1) = 0

    do, idim = 1,size(dims_table)
        dimname_table(idim) = dims_table(idim)%name
    enddo
    dimname_table(size(dims_table)+1) = "t  "

    do, idim = 1,size(dims_table)
        longname_table(idim) = dims_table(idim)%long_name
    enddo
    longname_table(size(dims_table)+1) = "time     "

    do, idim = 1,size(dims_table)
        unit_table(idim) = dims_table(idim)%unit
    enddo
    unit_table(size(dims_table)+1) = "s          "

    call HistoryCreate(file=filename, title="ebm", &
            & source="ebm-trnsp 1.0", institution=user, &
            & dims=dimname_table, &
            & dimsizes=dimsizes_table, &
            & longnames=longname_table, &
            & units=unit_table, &
            & origin=0.0, interval=real(dt))

    call HistoryAddVariable(varname="temperature", &
            & dims=dimname_table, &
            & longname="temperature", units="K")

    do, idim = 1,size(dims_table)
        call HistoryPut(dimname_table(idim), dims_table(idim)%values)
    end do

    ! 2 ܤΥեɤ߹. ٤ϥǡɤǽ.
    call Open(file, input_filename)
    do
	call GetUnit(file, header, buffer, fail)
	if (fail) exit

        call HistoryPut("temperature", buffer)

	deallocate(buffer)
    enddo

    call HistoryClose
    call Close(file)
    print *, trim(input_filename), " closed"

end program
