subroutine ANVarInquireL(var, growable)  
    use an_types, only: an_variable, an_variable_entry
    use an_vartable, only: vtable_lookup
    use netcdf_f77, only: nf_noerr, nf_inq_unlimdim, nf_inq_vardimid
    type(an_variable), intent(in):: var
    ! ϐ\
    logical, intent(out):: growable
    type(an_variable_entry), pointer:: ent
    integer:: stat, i, idim_growable

    growable = .false.
    stat = vtable_lookup(var, ent)
    if (stat /= nf_noerr) return
    stat = nf_inq_unlimdim(ent%fileid, idim_growable)
    if (stat /= nf_noerr) return

    if (ent%varid > 0) then
        if (.not. associated(ent%dimids)) return
        do, i = 1, size(ent%dimids)
            if (ent%dimids(i) == idim_growable) growable = .true.
        enddo
    else
        growable = (ent%dimid == idim_growable)
    endif
end subroutine