! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine ANVarPutAttrReal(var, name, value, err)
    use an_types, only: AN_VARIABLE, an_variable_entry
    use an_file, only: ANFileDefineMode
    use an_vartable, only: vtable_lookup
    use netcdf_f77, only: NF_PUT_ATT_REAL, NF_NOERR, NF_DEL_ATT, &
        NF_ENOTINDEFINE, NF_FLOAT, NF_GLOBAL
    use dc_url, only: GT_PLUS
    use dc_error
    implicit none
    type(AN_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    real, intent(in):: value(:)
    logical, intent(out), optional:: err
    type(an_variable_entry), pointer:: ent
    integer:: stat
continue
    stat = vtable_lookup(var, ent)
    if (stat /= NF_NOERR) goto 999
    if (size(value) == 0) then
        if (name(1:1) == GT_PLUS) then
            stat = nf_del_att(ent%fileid, NF_GLOBAL, name=name(2:))
        else
            stat = nf_del_att(ent%fileid, ent%varid, name=name)
        endif
        goto 999
    endif
    stat = ANFileDefineMode(ent%fileid)
    if (stat /= NF_NOERR) goto 999
    if (name(1:1) == GT_PLUS) then
        stat = nf_put_att_real(ent%fileid, NF_GLOBAL, name=name(2:), &
            xtype=NF_FLOAT, len=size(value), rvals=value)
    else
        stat = nf_put_att_real(ent%fileid, ent%varid, name=name, &
            xtype=NF_FLOAT, len=size(value), rvals=value)
    endif
999 continue
    call StoreError(stat, 'ANVarPutAttrReal', err)
end subroutine

subroutine ANVarPutAttrDouble(var, name, value, err)
    use an_types, only: AN_VARIABLE, an_variable_entry
    use an_vartable, only: vtable_lookup
    use an_file, only: ANFileDefineMode
    use netcdf_f77, only: NF_PUT_ATT_DOUBLE, NF_NOERR, NF_DEL_ATT, &
        NF_ENOTINDEFINE, NF_DOUBLE, NF_GLOBAL
    use dc_url, only: GT_PLUS
    use dc_error
    implicit none
    type(AN_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    double precision, intent(in):: value(:)
    logical, intent(out), optional:: err
    type(an_variable_entry), pointer:: ent
    integer:: stat
continue
    stat = vtable_lookup(var, ent)
    if (stat /= 0) goto 999
    if (size(value) == 0) then
        if (name(1:1) == GT_PLUS) then
            stat = nf_del_att(ent%fileid, NF_GLOBAL, name=name(2:))
        else
            stat = nf_del_att(ent%fileid, ent%varid, name=name)
        endif
        goto 999
    endif
    stat = ANFileDefineMode(ent%fileid)
    if (stat /= NF_NOERR) goto 999
    if (name(1:1) == GT_PLUS) then
        stat = nf_put_att_double(ent%fileid, NF_GLOBAL, name=name(2:), &
            xtype=NF_DOUBLE, len=size(value), dvals=value)
    else
        stat = nf_put_att_double(ent%fileid, ent%varid, name=name, &
            xtype=NF_DOUBLE, len=size(value), dvals=value)
    endif
999 continue
    call StoreError(stat, 'ANVarPutAttrDouble', err)
end subroutine
