! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine ANVarSync(var, stat)
    use an_types, only: AN_VARIABLE, an_variable_entry
    use an_file, only: ANFileSync
    use an_vartable, only: vtable_lookup
    use netcdf_f77, only: nf_noerr
    implicit none
    type(AN_VARIABLE), intent(in), optional:: var
    integer, intent(out), optional:: stat
    type(an_variable_entry), pointer:: ent
    integer:: mystat
    if (.not. present(var)) then
        call ANFileSync(stat=stat)
        return
    endif
    mystat = vtable_lookup(var, ent)
    if (mystat /= NF_NOERR) then
        if (present(stat)) stat = mystat
    else
        call ANFileSync(ent%fileid, stat=stat)
    endif
end subroutine
