! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

module gt_map

! GTOOL ϐ\
!
! gtool ϐƂ͎̂͒PȂnhƑCe[^łA
! nh͂̃}bv\̃L[łB
! [UnhRs[邩Ȃ̂ŁÃxɂ
! QƃJEg͍ȂƂɂB

    use dc_types, only: string
    use gt_vartable

    implicit none

    ! \
    type GT_DIMMAP
        ! ȂΎ̕ϐ̎ԍ, ϐQƎ͔񐳒l
        integer:: dimno
        ! ϐ url
        character(len=string):: url
        ! --- ̂ gtool [ŮiqԍΉ ---
        !    [U݂ 1..allcount ̂
        !    (1..allcount) * step + offset ɎʑB
        !    ̒l̕ύX̍ۂ͎̕ϐ̋eY͈͂
        !    \mFKvB
        ! start lɑ΂ItZbg
        integer:: offset
        ! 1  -1 ̒lƂ邱Ƃ҂B
        integer:: step
        ! |̊iqԍ: start + count * stride <= allcount
        integer:: allcount
        ! ---- Ce[^{ ---
        ! o͔͈͂ (start:start+count*stride:stride) łB
        ! Ce[^ start l
        integer:: start
        ! Ce[^ count l
        integer:: count
        ! Ce[^ stride l
        integer:: stride
    end type

    type MAP_TABLE_ENTRY
        integer:: vid
        integer:: ndims
        type(GT_DIMMAP), pointer:: map(:)
    end type

    type(MAP_TABLE_ENTRY), save, target, allocatable:: maptab(:)
    integer, parameter:: maptab_init_size = 16

    public:: MapTabAdd, MapTabDelete, MapTabLookup
    public:: var_class, map_create, map_to_internal_specs, dimrange
    private:: maptab, maptab_init_size

    interface dimrange
        module procedure dimrange_dimno
    end interface

contains

    subroutine dimrange_dimno(var, dimno, dimlo, dimhi)
        use gtdata_types, only: gt_variable
        use gtdata_generic, only: open, close
        use gtdata_internal, only: dimrange
        type(gt_variable), intent(in):: var
        integer, intent(in):: dimno
        integer, intent(out):: dimlo, dimhi
        type(gt_variable):: dimvar
        integer:: vid
        call open(dimvar, var, dimno, count_compact=.true.)
        call maptablookup(dimvar, vid=vid)
        call dimrange(vid, dimlo, dimhi)
        call close(dimvar)
    end subroutine

    subroutine map_dup(var, source_var)
        use gtdata_types, only: gt_variable
        use gt_vartable, only: VarTableAdd, VarTableLookup
        use dc_trace, only: message
        type(gt_variable), intent(out):: var
        type(gt_variable), intent(in):: source_var
        integer:: vid, mid1, mid2, vid2, nd, class, cid
        call MapTabLookup(source_var, vid=vid)
        if (vid < 1) then
            var = gt_variable(-1)
            return
        endif
        call VartableLookup(vid, class=class, cid=cid)
        call VarTableAdd(vid2, class, cid)
        call MapTabAdd(var%mapid, vid2)
        mid1 = source_var%mapid
        mid2 = var%mapid
        maptab(mid2)%ndims = maptab(mid1)%ndims
        if (associated(maptab(mid1)%map)) then
            nd = size(maptab(mid1)%map)
            allocate(maptab(mid2)%map(nd))
            maptab(mid2)%map(1:nd) = maptab(mid1)%map(1:nd)
        else
            nullify(maptab(mid2)%map)
        endif
        call message('map_dup mapid(%d from %d) vid(%d from %d)', &
            & i=(/mid2, mid1, maptab(mid2)%vid, maptab(mid1)%vid/))
    end subroutine

    subroutine map_create(var, class, cid, ndims, allcount)
        use gtdata_types, only: gt_variable
        use gt_vartable, only: VarTableAdd
        type(gt_variable), intent(out):: var
        integer, intent(in):: class, cid, ndims, allcount(:)
        type(gt_dimmap), pointer:: map(:)
        integer:: vid, i
        call VarTableAdd(vid, class, cid)
        call MapTabAdd(var%mapid, vid)
        call map_allocate(map, ndims)
        maptab(var%mapid)%ndims = ndims
        maptab(var%mapid)%map => map
        do, i = 1, ndims
            map(i)%dimno = i
            map(i)%allcount = allcount(i)
            map(i)%count = allcount(i)
            map(i)%offset = 0
            map(i)%start = 1
            map(i)%step = 1
            map(i)%stride = 1
        enddo
    end subroutine

    subroutine MapTabAdd(mapid, vid)
        integer, intent(out):: mapid
        integer, intent(in):: vid
        type(MAP_TABLE_ENTRY), allocatable:: tmp_maptab(:)
        integer:: i, n
        ! KvȂ珉m
        if (.not. allocated(maptab)) then
            allocate(maptab(maptab_init_size))
            maptab(:)%vid = 0
            do, n = 1, maptab_init_size
                nullify(maptab(n)%map)
            enddo
        endif
        ! 󂫒n΂Ɋ蓖
        do, i = 1, size(maptab)
            if (maptab(i)%vid == 0) then
                mapid = i
                maptab(mapid)%vid = vid
                return
            endif
        enddo
        ! 󂫒n͂Ȃ̂{m
        n = size(maptab)
        allocate(tmp_maptab(n))
        tmp_maptab(:) = maptab(:)
        deallocate(maptab)
        allocate(maptab(n * 2))
        ! mۂƂ̓NA
        maptab(1:n) = tmp_maptab(1:n)
        do, i = n + 1, (2 * size(tmp_maptab))
            maptab(i)%vid = 0
            nullify(maptab(i)%map)
        enddo
        deallocate(tmp_maptab)
        mapid = n + 1
        maptab(mapid)%vid = vid
    end subroutine

    subroutine MapTabDelete(var, err)
        use dc_error, only: nf_enotvar, storeerror, dc_noerr
        use gtdata_types, only: gt_variable
        use dc_trace, only: message
        implicit none
        type(gt_variable), intent(in):: var
        logical, intent(out), optional:: err
        integer:: mapid
        mapid = var%mapid
        if (.not. allocated(maptab)) goto 999
        if (mapid <= 0 .or. mapid > size(maptab)) goto 999
        if (maptab(mapid)%vid == 0) goto 999
        maptab(mapid)%vid = 0
        if (associated(maptab(mapid)%map)) deallocate(maptab(mapid)%map)
        call storeerror(dc_noerr, 'maptabdelete', err)
        call message('gt_map table %d deleted', i=(/mapid/))
        return
    999 continue
        call storeerror(nf_enotvar, 'maptabdelete', err)
    end subroutine

    ! t@Cԍ̕ϐ\̒gԂ
    subroutine MapTabLookup(var, vid, map, ndims_ptr)
        use gtdata_types, only: gt_variable
        type(gt_variable), intent(in):: var
        integer, intent(out), optional:: vid
        type(gt_dimmap), pointer, optional:: map(:)
        integer, pointer, optional:: ndims_ptr
        if (.not. allocated(maptab)) goto 999
        if (var%mapid <= 0 .or. var%mapid > size(maptab)) goto 999
        if (maptab(var%mapid)%vid <= 0) goto 999
        if (present(vid)) vid = maptab(var%mapid)%vid
        if (present(map)) map => maptab(var%mapid)%map
        if (present(ndims_ptr)) ndims_ptr => maptab(var%mapid)%ndims
        return
    999 continue
        if (present(vid)) vid = 0
        if (present(map)) nullify(map)
        if (present(ndims_ptr)) nullify(ndims_ptr)
    end subroutine

    subroutine var_class(var, class, cid)
        use gtdata_types, only: gt_variable
        use gt_vartable, only: vartablelookup
        type(gt_variable), intent(in):: var
        integer, intent(out), optional:: class, cid
        integer:: vid
        call maptablookup(var, vid)
        call vartablelookup(vid, class=class, cid=cid)
    end subroutine

    subroutine map_set_rank(var, rank, stat)
        use gtdata_types, only: gt_variable
        use gt_vartable, only: vartablelookup
        use dc_error, only: nf_enotvar, gt_enomoredims, dc_noerr
        type(gt_variable), intent(in):: var
        integer, intent(in):: rank
        integer, intent(out):: stat
        type(gt_dimmap), pointer:: tmpmap(:)
        integer, pointer:: ndims_ptr
        integer:: vid, nd
        call maptablookup(var, vid, tmpmap, ndims_ptr)
        if (vid <= 0) then
            stat = nf_enotvar
            return
        endif
        if (.not. associated(tmpmap)) then
            if (rank == 0) then
                stat = dc_noerr
            else
                stat = gt_enomoredims
            endif
        endif
        stat = dc_noerr
        do, nd = size(tmpmap), 1, -1
            if (count(tmpmap(:)%count > 1) <= rank) exit
            tmpmap(nd)%count = 1
        enddo
    end subroutine

    subroutine map_to_internal_specs(var, specs, ndims)
        use gtdata_types, only: gt_variable
        use gtdata_internal, only: num_dimensions => ndims
        type(gt_variable), intent(in):: var
        integer, pointer:: specs(:, :)
        integer, intent(out), optional:: ndims
        type(gt_dimmap), pointer:: tmpmap(:)
        type(gt_dimmap), pointer:: it
        integer:: vid, i, j, imap, internal_ndims
        integer, pointer:: external_ndims 
        !-- continue
        call maptablookup(var, vid, tmpmap, external_ndims)
        internal_ndims = num_dimensions(vid)
        if (present(ndims)) ndims = internal_ndims
        allocate(specs(max(1, internal_ndims), 4))
        specs(:, 1) = 1
        specs(:, 2) = 1
        specs(:, 3) = 1
        specs(:, 4) = 0
        imap = 1
        do, i = 1, size(maptab(var%mapid)%map)
            it => maptab(var%mapid)%map(i)
            j = it%dimno
            if (j > 0 .and. j <= internal_ndims) then
                specs(j, 1) = it%start + it%offset
                specs(j, 2) = it%count
                if (i > external_ndims) specs(j, 2) = 1
                specs(j, 3) = it%stride * it%step
                specs(j, 4) = imap
            endif
            imap = imap * it%count
        enddo
    end subroutine

    subroutine map_allocate(map, ndims)
        type(GT_DIMMAP), pointer:: map(:)
        integer, intent(in):: ndims
        if (ndims <= 0) then
            nullify(map)
            return
        endif
        allocate(map(ndims))
        map(:)%dimno = -1
        map(:)%url = ' '
        map(:)%allcount = 0
        map(:)%offset = 0
        map(:)%step = 1
        map(:)%start = 1
        map(:)%count = 0
        map(:)%stride = 1
    end subroutine

    subroutine map_apply(var, map)
        use gtdata_types, only: gt_variable
        type(GT_VARIABLE), intent(inout):: var
        type(GT_DIMMAP), pointer:: map(:)
        type(GT_DIMMAP), pointer:: tmpmap(:), varmap
        integer:: i, nd
        nd = size(map)
        allocate(tmpmap(nd))
        do, i = 1, nd
            tmpmap(i)%allcount = map(i)%allcount
            tmpmap(i)%count = map(i)%count
            if (map(i)%dimno > 0) then
                varmap => maptab(var%mapid)%map(map(i)%dimno)
                tmpmap(i)%url = varmap%url
                tmpmap(i)%dimno = varmap%dimno
                tmpmap(i)%offset = varmap%offset + map(i)%offset
                tmpmap(i)%step = varmap%step * map(i)%step
            else
                tmpmap(i)%url = map(i)%url
                tmpmap(i)%dimno = 0
                tmpmap(i)%offset = map(i)%offset
                tmpmap(i)%step = map(i)%step
            endif
        enddo
        deallocate(map)
        map => tmpmap
    end subroutine

    subroutine map_resize(map, ndims)
        type(GT_DIMMAP), pointer:: map(:)
        integer, intent(in):: ndims
        type(GT_DIMMAP), pointer:: tmpmap(:)
        integer:: n
        if (associated(map)) then
            tmpmap => map
            call map_allocate(map, ndims)
            n = min(size(tmpmap), ndims)
            map(1:n) = tmpmap(1:n)
            deallocate(tmpmap)
            n = n + 1
        else
            call map_allocate(map, ndims)
            n = 1
        endif
    end subroutine

    subroutine gtvar_dump(var)
        use gtdata_types, only: gt_variable
        use gt_vartable, only: vartable_dump
        use dc_trace, only: debug, message
        type(gt_variable), intent(in):: var
        integer:: idim, imap
        if (.not. debug()) return
        imap = var%mapid
        if (imap >= 1 .and. imap <= size(maptab)) then
            if (associated(maptab(imap)%map)) then
                call message('[gt_variable %d: ndims=%d, map.size=%d]', &
                    & i=(/imap, maptab(imap)%ndims, size(maptab(imap)%map)/))
                do, idim = 1, size(maptab(imap)%map)
                    call message('[dim%d dimno=%d ofs=%d step=%d' &
                        &// ' all=%d start=%d count=%d stride=%d url=%c]', &
                        & c1=trim(maptab(imap)%map(idim)%url), &
                        & i=(/idim, maptab(imap)%map(idim)%dimno, &
                        & maptab(imap)%map(idim)%offset, &
                        & maptab(imap)%map(idim)%step, &
                        & maptab(imap)%map(idim)%allcount, &
                        & maptab(imap)%map(idim)%start, &
                        & maptab(imap)%map(idim)%count, &
                        & maptab(imap)%map(idim)%stride/))
                enddo
            else
                call message('[gt_variable %d: ndims=%d, map=null]', &
                    & i=(/imap, maptab(imap)%ndims/))
            endif
            call vartable_dump(maptab(imap)%vid)
        else
            call message('[gt_variable %d: invalid id]', i=(/imap/))
        endif
    end subroutine

    integer function dimord_skip_compact(dimord, map) result(result)
        use dc_trace, only: message
        integer, intent(in):: dimord
        type(gt_dimmap), intent(in):: map(:)
        integer:: nd, id
        result = -1
        nd = 0
        do, id = 1, size(map)
            if (map(id)%count < 2) cycle
            nd = nd + 1
            if (nd < dimord) cycle
            result = id
            call message('compact dim skip: %d <= %d', i=(/result, dimord/))
            exit
        enddo
    end function

end module
