! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.
! gtattr - ݒc[

program gtattr
    use gtool
    implicit none
    type(VSTRING):: argument
    type(VSTRING):: optname, optvalue
    type(GT_VARIABLE):: var
    logical:: var_opened = .FALSE.
    integer:: i
    character(len = 20):: attr_type
continue
    attr_type = "character"
    do, i = 1, GtArgCount()
        call GtArgGet(i, argument)
        if (GtOptionForm(argument, optname, optvalue)) then
            if (optname == "-type") then
                attr_type = optvalue
            else if (optname == "-delete") then
                if (var_opened) then
                    call del_attr(var, vchar(optvalue, len(optvalue)))
                else
                    print *, "option -delete before varname ignored"
                endif
            else if (var_opened .and. vindex(optname, "-") /= 1) then
                call put_attr(var, vchar(optname, len(optname)), &
                    & vchar(optvalue, len(optvalue)), xtype=attr_type)
            else
                call put_line("option " // optvalue // " ignored")
            endif
        else if (.not. var_opened) then
            call Open(var, argument, writable=.TRUE.)
            var_opened = .TRUE.
        else
            call put_line("unknown argument " // argument // " ignored")
        endif
    enddo
    if (var_opened) then
        call Close(var)
    else
        write(*, *) 'usage: gtattr var [-type=type] ', &
            & '[-delete=attr] [attrname=value] ...'
    endif
end program
