! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.
! gtlist - ġ

program gtlist
    use gtool
    use dc_trace, only: setdebug
    implicit none
    character(string):: filename, varname, attrname, argument
    integer:: i
    integer:: showcount = 0
    logical:: url_mode = .FALSE.
    character:: format = "1"
continue
    do, i = 1, GtArgCount()
        call GtArgGet(i, argument)
        if (argument == "-url") then
            url_mode = .TRUE.
        else if (argument == "-debug") then
            call setdebug
        else if (argument(1:1) == "-" .and. len_trim(argument) == 2) then
            format = argument(2: )
        else
            showcount = showcount + 1
            call UrlSplit(argument, file=filename, var=varname)
            if (varname == '') then
                call list_variables
            else
                varname = argument
                call list_attributes
            endif
        endif
    enddo
    if (showcount == 0) then
        write(*, *) 'usage: gtlist [-url] [filename|varname] ...'
    endif
contains

    subroutine list_variables
        type(GT_VARIABLE):: var
        character(len = token):: xtype
        character(len = string):: cbuffer
        character(len = string):: fpart, vpart
        logical:: end
        cbuffer = argument
        call GTVarSearch(cbuffer)
        do
            call GTVarSearch(cbuffer, end)
            if (end) exit
            varname = trim(cbuffer)
            call UrlSplit(varname, file=fpart, var=vpart)
            if (url_mode) then
                vpart = UrlMerge(fpart, vpart)
            endif
            select case(format)
            case('l', 'L')
                call Open(var, varname)
                call Inquire(var=var, xtype=xtype)
                call put_line(trim(xtype) // trim(vpart))
                call Close(var)
            case('m')
                call Open(var, varname)
                call Inquire(var=var, xtype=xtype)
                call put_line(trim(xtype) // ', ' // trim(vpart))
                call Close(var)
            case default
                call put_line(trim(vpart))
            end select
        enddo
    end subroutine

    subroutine list_attributes
        use dc_types, only: string, token
        character(len = string):: attrbasename
        type(GT_VARIABLE):: var
        character(len = token):: xtype
        logical:: end
        call Open(var, varname)
        call attr_rewind(var)
        do
            call attr_next(var, attrbasename, end)
            if (end) exit
            if (url_mode) then
                call inquire(var, url=attrname)
                attrname = trim(attrname) // ':' // attrbasename
            else
                attrname = attrbasename
            endif
            select case(format)
            case('l', 'L')
                call inquire(var, trim(attrname), xtype=xtype)
                call put_line(xtype // attrname)
            case('m')
                call inquire(var, trim(attrname), xtype=xtype)
                call put_line(trim(xtype) // ", " // trim(attrname))
            case default
                call put_line(trim(attrname))
            end select
        enddo
        call Close(var)
    end subroutine

end program
