! t@CTW[
module findfile

    use gt3read
    use dc_types, only: string
    use dc_trace, only: message

implicit none

    character(len = string):: apath(4)
    ! ݒ肪΂炪D悷
    data apath(1)/ "%GTAXDIR%"/
    ! UNIX ̕WfBNg
    data apath(2)/ "/var/spool/gt3-dcl5/"/
    ! Windows ̕WfBNg
    data apath(3)/ "c:/dennou/gt3/"/
    ! JgfBNg
    data apath(4)/ "./" /

    ! XgƎ\ŋLAGTOOL3 瓾铯
    type axis_t
        ! ̗vf
        character(len = 16):: item
        ! ̊JniqԍAIiqԍ
        integer:: start, end
    end type

contains

    ! { sysdep ɂׂ
    subroutine GtoolEnvGet(name, value)
        character(len = *), intent(in):: name
        character(len = *), intent(out):: value
    continue
        CALL OSGENV(name, value)
    end subroutine

    subroutine make_axis_path(item, class, path)
        use dc_string, only: replace
    implicit none
        character(len = *), intent(in):: item
        character(len = *), intent(in):: class
        character(len = *), intent(out):: path
        integer:: i
        logical:: exist
        character(len = string):: buf
    continue
        if (apath(1)(1:1) == '%') then
            buf = ""
            call GtoolEnvGet('GTAXDIR', buf)
            if (buf == "") then
                apath(1) = "./"
            else
                apath(1) = replace(apath(1), '%GTAXDIR%', trim(buf) // "/")
            endif
        endif
        do, i = 1, size(apath)
            path = trim(apath(i)) // 'GTAX' // trim(class) // '.' // &
                & trim(item)
            inquire(file=path, exist=exist)
            if (exist) return
        enddo
        path = ""        
    end subroutine

    subroutine load_axis(axis, class, header, value, iostat, fullrange)
        type(axis_t), intent(in):: axis
        character(len = *), intent(in):: class
        type(gt3_header), intent(out):: header
        real, pointer:: value(:), buf3(:, :, :)
        integer, intent(out):: iostat
        real, intent(out), optional:: fullrange
        type(gt3_file):: file
        character(len = string):: path
        integer:: siz
    continue
        call make_axis_path(axis%item, class, path)
        if (path == "") then
            iostat = 1
	    print *, "axis file GTAX"//class//"."//trim(axis%item)//" not found"
	    nullify(value)
            return
        endif
        call open(file, path, iostat)
        if (iostat /= 0) goto 999
        call getunit(file, header, buf3, iostat)
        if (iostat /= 0) goto 999
        call close(file, iostat)
        if (iostat /= 0) goto 999
        siz = axis%end - axis%start + 1
        allocate(value(siz), stat=iostat)
        if (iostat /= 0) goto 999
        value = buf3(axis%start:axis%end, 1, 1)
        if (present(fullrange)) then
            fullrange = maxval(buf3) - minval(buf3)
        endif
        deallocate(buf3)
	call message("axis file %c used", c1=trim(path))
	return
    999 continue
	call message("axis file %c caused error %d", c1=trim(path), i=(/iostat/))
        nullify(value)
    end subroutine

end module
