! GTFigSave - }ϐƂĕۑ

subroutine GTFigSave(fig, name, name_result)
    use gtgraph_generic, only: Save, GTGraphSaveName
    use gtgraph_types, only: GT_FIGURE
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Create, Close, put_attr, add_member
    use dc_trace, only: beginsub, endsub
    use dc_string, only: VSTRING, vchar, len, ASSIGNMENT(=)
    use dc_types, only: STRING
    implicit none
    type(GT_FIGURE), intent(inout):: fig
    type(VSTRING), intent(in), optional:: name
    type(VSTRING), intent(out), optional:: name_result
    type(VSTRING):: childname
    type(GT_VARIABLE):: var
    character(LEN = STRING):: strbuf, vname, figtitle
    integer:: i
continue
    if (present(name)) then
        vname = name
    else
        call GTGraphSaveName(result=vname)
    endif
    call beginsub('gtfigsave', 'name=%c', c1=vname)
    figtitle = fig%title
    call Create(var, trim(vname), xtype="int", overwrite=.TRUE., &
        & long_name=trim(figtitle))
    call Put_Attr(var, "gt_structure_class", "figure")

    ! }̃oɂȂĂ̂̏o
    if (associated(fig%contours)) then
        do, i = 1, size(fig%contours)
            call Save(fig%contours(i), resultname=childname)
            strbuf = childname
            call add_member(var, strbuf)
        enddo
    endif

    if (associated(fig%vectors)) then
        do, i = 1, size(fig%vectors)
            call Save(fig%vectors(i), resultname=childname)
            strbuf = childname
            call add_member(var, strbuf)
        enddo
    endif

    call Put_Attr(var, "gt_graph_aspect_ratio", (/fig%aspect/))

    call Close(var)
    print *, "figure ", trim(figtitle), " stored at ", trim(vname), "."
    if (present(name_result)) name_result = vname
    call endsub('gtfigsave', 'name=%c', c1=trim(vname))
end subroutine

