! gtavg.f90 - ϑ
! Copyright (C) by GFD-Dennou Club, 2001.  All rights reserved.

module gtavg_tools
    use gtool
    implicit none
contains

    subroutine help
        use sysdep, only: abortprogram
        print *, "usage:"
        print *, " gtavg [out=<output>] dim=<dimension name> <variable>"
        print *, ""
        call abortprogram("gtavg")
    end subroutine

    subroutine avg_single(input_name, output_name, avg_dim, err)
        character(*), intent(in):: input_name
        character(*), intent(in):: output_name
        character(*), intent(in):: avg_dim
        logical, intent(out):: err
        type(gt_variable):: src, mold, dest
        integer:: idim_mold, siz, stat
        integer, allocatable:: cnt(:)
        double precision, allocatable:: dsum(:), dbuf(:)
        double precision:: undef = -999.0d0
    continue
        err = .true.
        call open(src, input_name)
        idim_mold = dimname_to_dimord(src, avg_dim)
        if (idim_mold < 0) then
            call close(src)
            return
        endif
        call slice(src, idim_mold, start=1, count=1, stride=1)
        call open(mold, src, 0)
        call del_dim(mold, idim_mold, err=err)
        if (err) return
        call create(dest, url=output_name, copyfrom=mold, &
            & copyvalue=.false., overwrite=.true., err=err)
        call close(mold)
        if (err) return

        call inquire(src, size=siz)
        allocate(dbuf(siz), dsum(siz), cnt(siz))
        cnt(1:siz) = 0
        dsum(1:siz) = 0.0d0

        do
            call get(src, dbuf(1:siz), siz)
            where (dbuf(1:siz) /= undef)
                dsum(1:siz) = dsum(1:siz) + dbuf(1:siz)
                cnt(1:siz) = cnt(1:siz) + 1
            end where
            call slice_next(src, stat=stat)
            if (stat /= 0) exit
        enddo

        where (cnt(1:siz) > 0)
            dsum(1:siz) = dsum(1:siz) / cnt(1:siz)
        elsewhere
            dsum(1:siz) = undef
        end where
        call put(dest, dsum(1:siz), siz)

        call close(src)
        call close(dest)
        err = .false.
    end subroutine

    subroutine avg_expand(input_name, output_name, avg_dim, err)
        character(*), intent(in):: input_name
        character(*), intent(in):: output_name
        character(*), intent(in):: avg_dim
        logical, intent(out):: err
        type(gt_variable):: src, dest
        integer:: idim_avg, idim, ndim, siz, stat
        integer:: cnt
        double precision, allocatable:: dbuf(:)
        double precision:: undef = -999.0d0
        double precision:: dsum
    continue
        err = .true.
        call open(src, input_name)
        idim_avg = dimname_to_dimord(src, avg_dim)
        if (idim_avg < 0) then
            call close(src)
            return
        endif
        call create(dest, url=output_name, copyfrom=src, &
            & copyvalue=.false., overwrite=.true., err=err)
        if (err) return
        call inquire(src, alldims=ndim)

        do, idim = 1, ndim
            if (idim == idim_avg) cycle
            call slice(src, idim, start=1, count=1, stride=1)
            call slice(dest, idim, start=1, count=1, stride=1)
        enddo

        call inquire(src, size=siz)
        allocate(dbuf(siz))

        do
            call get(src, dbuf(1:siz), siz)
            cnt = count(dbuf(1:siz) /= undef)
            if (cnt > 0) then
                dsum = sum(dbuf(1:siz), mask=(dbuf(1:siz) /= undef))
                where (dbuf(1:siz) /= undef)
                    dbuf(1:siz) = dsum / cnt
                end where
            endif
            call put(dest, dbuf(1:siz), siz)
            call slice_next(src, stat=stat)
            if (stat /= 0) exit
            call slice_next(dest, stat=stat)
            if (stat /= 0) exit
        enddo

        call close(src)
        call close(dest)
        err = .false.
    end subroutine

    subroutine avg_multi(argind_ini, output)
        integer, intent(in):: argind_ini
        character(*), intent(in):: output
    continue
        print "('sorry, avg_multi(',i4,', 'a, &
            & ') will be implemented later')", &
            & argind_ini, trim(output)
    end subroutine

end module

program gtavg
    use gtavg_tools
    use dc_trace, only: setdebug
    implicit none
    character(string):: output = "gtool.nc@default"
    character(string):: avg_dim = ""
    character(string):: arg, optname, optvalue
    integer:: argind, argc
    logical:: err
    logical:: expand
continue
    argc = gtargcount()
    argind = 0
    loop_option: do, while (argind < argc)
        argind = argind + 1
        call gtargget(argind, arg)
        if (arg == '--') exit loop_option
        if (.not. gtoptionform(arg, optname, optvalue)) then
           argind = argind - 1
           exit loop_option
        endif
        call toupper(optname)
        select case(optname)
        case('-DEBUG')
            call setdebug
        case('DIM', 'DIMENSION', 'AVGDIM', 'AVG_DIM')
            avg_dim = optvalue
        case('OUT', 'OUTPUT')
            output = optvalue
        case('HELP')
            call help
        case('-EXPAND')
            expand = .true.
        case default
            print *, 'unknown option <', trim(optname), '>'
            call help
        end select
    enddo loop_option
    if (avg_dim /= "" .and. argind < argc) then
        loop_single: do, while (argind < argc)
            argind = argind + 1
            call gtargget(argind, arg)
            if (expand) then
                call avg_expand(arg, output, avg_dim, err)
            else
                call avg_single(arg, output, avg_dim, err)
            endif
            if (err) exit
        enddo loop_single
    else if (argind < argc - 1) then
        call avg_multi(argind, output)
    else
        print *, 'dim= missing, or specified variables too few'
        call help
    endif
end program
