! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GTAxisLoadByName(Axis, varname)
    use gtgraph_types, only: GT_AXIS
    use gtgraph_generic, only: Load
    use gtdata_generic, only: Open, Close
    use gtdata_types, only: GT_VARIABLE
    implicit none
    type(GT_AXIS), intent(out):: axis
    character(*), intent(in):: varname
    type(GT_VARIABLE):: tmpvar
    call Open(tmpvar, varname)
    call Load(axis, tmpvar)
    call Close(tmpvar)
end subroutine

subroutine GTAxisLoad(Axis, var)
    use gtgraph_types, only: GT_Axis
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: get_attr, Open, attr_true, Close
    use gtgraph_generic, only: GOpen => Open
    use dc_types, only: STRING
    use dc_error
    implicit none
    type(GT_Axis), intent(out):: Axis
    type(GT_VARIABLE), intent(in):: var
    type(GT_VARIABLE):: datavar
    character(STRING):: varname, positive
continue
    call get_attr(var, "gt_structure_link_data", varname)
    if (varname == "") then
        call StoreError(GT_EBADLINK, "GTContLoad(data variable)")
        return
    endif
    call Open(datavar, varname)
    call GOpen(axis, datavar, 0)
    call Close(datavar)
    axis%vertical = attr_true(var, "gt_graph_axis_vertical", default=.false.)
    call get_attr(var, "positive", positive)
    axis%negative = (positive == "down")
end subroutine

