!= GTHST_NMLINFO ѿν
!= Constructor of "GTHST_NMLINFO"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: hstnmlinfocreate.f90,v 1.1 2009-05-11 15:15:15 morikawa Exp $
! Tag Name::  $Name: gtool5-20090729 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
  subroutine HstNmlInfoCreate( gthstnml, &
    & interval_value, &
    & interval_unit, &
    & precision, &
    & time_average, average, &
    & fileprefix, &
    & origin_value, origin_unit, &
    & terminus_value, terminus_unit, &
    & slice_start, slice_end, slice_stride, &
    & space_average, &
    & newfile_intvalue, newfile_intunit, &
    & err )
    !
    ! GTHST_NMLINFO ѿνԤޤ. 
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä 
    ! GTHST_NMLINFO ѿꤷƤ. 
    !
    ! *interval_value*, 
    ! *interval_unit*, 
    ! *precision*, 
    ! *time_average* ( *average*) ʤɤѿ
    ! ϥǥեͤȤꤵޤ. 
    ! *fileprefix* ϳѿνϥե̾ƬȤ
    ! Ѥޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml* ˽ꤵƤ, 
    ! ץϥ顼ȯޤ. 
    !
    ! Constructor of "GTHST_NMLINFO". 
    ! Initialize *gthstnml* by this subroutine, 
    ! before other procedures are used, 
    !
    ! *interval_value*, 
    ! *interval_unit*, 
    ! *precision*, 
    ! *time_average* (now-defunct *average*), etc. 
    ! are set as default values. 
    ! *fileprefix* is used as prefixes of output filenames of 
    ! each variable. 
    !
    ! Note that if *gthstnml* is already initialized 
    ! by this procedure, error is occurred. 
    !
    use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
    use gtool_history_nmlinfo_internal, only: version
    use gtool_history, only: GT_HISTORY
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true, present_select
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD, USR_ERRNO
    use dc_date_types, only: DC_DIFFTIME
    use dc_date, only: DCDiffTimeCreate
    use netcdf_f77, only: NF_MAX_DIMS
    implicit none
    type(GTHST_NMLINFO), intent(inout):: gthstnml
    real, intent(in), optional:: interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! ͤͿ, Ϥ޻ߤޤ. 
                              ! 
                              ! Numerical value for interval of history data output. 
                              ! Negative values suppresses output.
    character(*), intent(in), optional:: interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(*), intent(in), optional:: precision
                              ! ҥȥǡ. 
                              ! Precision of history data
    logical, intent(in), optional:: time_average
                              ! ϥǡλʿѲե饰. 
                              ! Flag for time average of output data.
    logical, intent(in), optional:: average
                              ! time_average ε. 
                              ! Old version of "time_average"
    character(*), intent(in), optional:: fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames
    real, intent(in), optional:: origin_value
                              ! ϳϻ. 
                              ! Start time of output. 
    character(*), intent(in), optional:: origin_unit
                              ! ϳϻñ. 
                              ! Unit of start time of output. 
    real, intent(in), optional:: terminus_value
                              ! Ͻλ. 
                              ! End time of output. 
    character(*), intent(in), optional:: terminus_unit
                              ! Ͻλñ. 
                              ! Unit of end time of output. 
    integer, intent(in), optional:: slice_start(:)
                              ! γ. 
                              ! Start points of spaces. 
    integer, intent(in), optional:: slice_end(:)
                              ! νλ. 
                              ! End points of spaces. 
    integer, intent(in), optional:: slice_stride(:)
                              ! ι. 
                              ! Strides of spaces. 
    logical, intent(in), optional:: space_average(:)
                              ! ʿѲΥե饰. 
                              ! Flag of average. 
    integer, intent(in), optional:: newfile_intvalue
                              ! եʬֳִ. 
                              ! Interval of time of separation of a file. 
    character(*), intent(in), optional:: newfile_intunit
                              ! եʬֳִ֤ñ. 
                              ! Unit of interval of time of separation of a file. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(DC_DIFFTIME):: interval_time
    integer:: stat, ary_size
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoCreate'
  continue
    call BeginSub( subname, &
      & fmt = '@interval_value=%r @interval_unit=%c @precision=%c @time_average=%y @fileprefix=%c', &
      & r  = (/ present_select(.true., -1.0, interval_value) /), &
      & c1 = trim( present_select(.true., '<no>', interval_unit) ), &
      & c2 = trim( present_select(.true., '<no>', precision) ), &
      & l  = (/ present_and_true(time_average) /), &
      & c3 = trim( present_select(.true., '<no>', fileprefix) ), &
      & version = version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( gthstnml % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  
    !  Allocate
    !-----------------------------------------------------------------
    allocate( gthstnml % gthstnml_list )
    nullify( gthstnml % gthstnml_list % next )

    !-----------------------------------------------------------------
    !  ǥեͤ
    !  Configure default values
    !-----------------------------------------------------------------
    gthstnml % gthstnml_list % name = ''
    gthstnml % gthstnml_list % file = ''

    allocate( gthstnml % gthstnml_list % interval_value )
    allocate( gthstnml % gthstnml_list % interval_unit  )
    allocate( gthstnml % gthstnml_list % precision      )
    allocate( gthstnml % gthstnml_list % time_average   )
    allocate( gthstnml % gthstnml_list % fileprefix     )

    allocate( gthstnml % gthstnml_list % origin_value                  )
    allocate( gthstnml % gthstnml_list % origin_unit                   )
    allocate( gthstnml % gthstnml_list % terminus_value                )
    allocate( gthstnml % gthstnml_list % terminus_unit                 )
    allocate( gthstnml % gthstnml_list % slice_start   (1:NF_MAX_DIMS) )
    allocate( gthstnml % gthstnml_list % slice_end     (1:NF_MAX_DIMS) )
    allocate( gthstnml % gthstnml_list % slice_stride  (1:NF_MAX_DIMS) )
    allocate( gthstnml % gthstnml_list % space_average (1:NF_MAX_DIMS) )
    allocate( gthstnml % gthstnml_list % newfile_intvalue              )
    allocate( gthstnml % gthstnml_list % newfile_intunit               )


    gthstnml % gthstnml_list % interval_value = -1.0
    gthstnml % gthstnml_list % interval_unit  = 'sec'
    gthstnml % gthstnml_list % precision      = 'float'
    gthstnml % gthstnml_list % time_average   = .false.
    gthstnml % gthstnml_list % fileprefix     = ''

    gthstnml % gthstnml_list % origin_value     = -1.0 
    gthstnml % gthstnml_list % origin_unit      = 'sec'
    gthstnml % gthstnml_list % terminus_value   = -1.0 
    gthstnml % gthstnml_list % terminus_unit    = 'sec'
    gthstnml % gthstnml_list % slice_start      =  1
    gthstnml % gthstnml_list % slice_end        = -1
    gthstnml % gthstnml_list % slice_stride     =  1
    gthstnml % gthstnml_list % space_average    = .false.
    gthstnml % gthstnml_list % newfile_intvalue = -1
    gthstnml % gthstnml_list % newfile_intunit  = 'sec'

    if ( present(interval_value) ) gthstnml % gthstnml_list % interval_value = interval_value
    if ( present(interval_unit)  ) gthstnml % gthstnml_list % interval_unit  = interval_unit 
    if ( present(precision)      ) gthstnml % gthstnml_list % precision      = precision     

    if ( present(average)        ) gthstnml % gthstnml_list % time_average        = average       
    if ( present(time_average)   ) gthstnml % gthstnml_list % time_average        = time_average       
    if ( present(fileprefix)     ) gthstnml % gthstnml_list % fileprefix     = fileprefix    

    if ( present(origin_value    ) ) gthstnml % gthstnml_list % origin_value     = origin_value    
    if ( present(origin_unit     ) ) gthstnml % gthstnml_list % origin_unit      = origin_unit     
    if ( present(terminus_value  ) ) gthstnml % gthstnml_list % terminus_value   = terminus_value  
    if ( present(terminus_unit   ) ) gthstnml % gthstnml_list % terminus_unit    = terminus_unit   
    if ( present(slice_start     ) ) then
      ary_size = size(slice_start)
      gthstnml % gthstnml_list % slice_start(1:ary_size)  = slice_start     
    end if
    if ( present(slice_end      ) ) then
      ary_size = size(slice_end)
      gthstnml % gthstnml_list % slice_end(1:ary_size)    = slice_end     
    end if
    if ( present(slice_stride   ) ) then
      ary_size = size(slice_stride)
      gthstnml % gthstnml_list % slice_stride(1:ary_size) = slice_stride     
    end if
    if ( present(space_average   ) ) then
      ary_size = size(space_average)
      gthstnml % gthstnml_list % space_average(1:ary_size) = space_average
    end if
    if ( present(newfile_intvalue) ) gthstnml % gthstnml_list % newfile_intvalue = newfile_intvalue
    if ( present(newfile_intunit ) ) gthstnml % gthstnml_list % newfile_intunit  = newfile_intunit 

    !-----------------------------------------------------------------
    !  ֤ñ̤Υå
    !  Check unit of time
    !-----------------------------------------------------------------
    call DCDiffTimeCreate( &
      & diff = interval_time, &                                    ! (out)
      & value = &
      &   real( gthstnml % gthstnml_list % interval_value, DP ), & ! (in)
      & unit = gthstnml % gthstnml_list % interval_unit, &         ! (in)
      & err = err )                                                ! (out)
    if ( present_and_true( err ) ) then
      stat = USR_ERRNO
      goto 999
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    gthstnml % initialized = .true.
    gthstnml % define_mode = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoCreate
