!= HstNmlInfoOutputStep ̵
!= Invalidate "HstNmlInfoOutputStep"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: hstnmlinfooutputstepdisable.f90,v 1.1 2009-05-11 15:15:14 morikawa Exp $
! Tag Name::  $Name: gtool5-20101006 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
  subroutine HstNmlInfoOutputStepDisable( gthstnml, &
    & name, err )
    !
    ! Υ֥롼Ѥ, *name* ˴ؤ, 
    ! ʹߤ HstNmlInfoOutputStep  .false. ֤褦ˤʤޤ. 
    !
    ! ǡϴֳ֤Ϥν꤫ѹ, 
    ! ǡϤ뤿Ӥ˻Ū˻ꤹѤ뤳Ȥ
    ! ꤷƤޤ. 
    !
    ! HstNmlInfoEndDefine ⡼ɤϥ⡼ɤ
    ! ܹԤ˸ƤӽФƤ. 
    ! HstNmlInfoEndDefine ƤˤΥ֥롼Ѥ, 
    ! ץϥ顼ȯޤ. 
    !
    ! *name* ˴ؤ󤬸ʤ, 
    ! ץϥ顼ȯޤ. 
    ! *name* ʸξˤ, 
    ! ץϥ顼ȯޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤˤ, ץϥ顼ȯޤ. 
    !
    ! After this subroutine is used, 
    ! "HstNmlInfoOutputStep" returns .false. already 
    ! corresponding to the *name*. 
    !
    ! This subroutine expected to use when 
    ! interval of data output is changed from initialization of output, 
    ! and time is specified explicitly whenever data is output. 
    !
    ! Use after state is changed from define mode to
    ! output mode by "HstNmlInfoEndDefine". 
    ! If this subroutine is used before 
    ! "HstNmlInfoEndDefine" is used, error is occurred. 
    !
    ! When data correspond to *name* is not found, error is occurred.
    ! When *name* is blank, error is occurred too.
    !
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use gtool_history_nmlinfo_types, only: GTHST_NMLINFO, GTHST_NMLINFO_ENTRY
    use gtool_history_nmlinfo_internal, only: ListSearch
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, DC_ENOENTRY, HST_EBADNAME, HST_EINDEFINE
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
    character(*), intent(in):: name
                              ! ѿ̾. 
                              ! Ƭζ̵뤵ޤ. 
                              ! 
                              ! Variable identifier. 
                              ! Blanks at the head of the name are ignored. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoOutputStepDisable'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    if ( trim( name ) == '' ) then
      stat = HST_EBADNAME
      cause_c = ''
      goto 999
    end if

    if ( gthstnml % define_mode ) then
      stat = HST_EINDEFINE
      cause_c = 'OutputStepDisable'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *gthstnml* ⤫, *name* ˴ؤ history õ.
    !  Search "history" correspond to *name* in *gthstnml*
    !-----------------------------------------------------------------
    hptr => gthstnml % gthstnml_list
    call ListSearch( gthstnml_list = hptr, & ! (inout)
      &              name = name )           ! (in)

    if ( .not. associated( hptr ) ) then
      stat = DC_ENOENTRY
      cause_c = adjustl( name )
      goto 999
    end if

    hptr % output_step_disable = .true.

    nullify( hptr )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoOutputStepDisable
