########################################################################
# FTTJ:  An FFT library
# Copyright (C) 2008 Keiichi Ishioka <ishioka@gfd-dennou.org>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301 USA.
########################################################################
# fft 16 in-place forward
.text
.globl _fjcif4_
_fjcif4_:
       movl	4(%esp), %eax

       movaps 16(%eax), %xmm0
       movaps 80(%eax), %xmm2       
       movaps 144(%eax), %xmm1
       movaps 208(%eax), %xmm3

       movaps %xmm0,%xmm7
       subpd %xmm1,%xmm0
       addpd %xmm7,%xmm1

       movaps %xmm2,%xmm7
       subpd %xmm3,%xmm2
       addpd %xmm7,%xmm3

       movaps %xmm1,%xmm7
       subpd %xmm3,%xmm1
       addpd %xmm7,%xmm3

       movaps %xmm3,16(%eax)
       
#-------------

       movaps 48(%eax), %xmm5
       movaps 112(%eax), %xmm6       
       movaps 176(%eax), %xmm3
       movaps 240(%eax), %xmm4

       movaps %xmm5,%xmm7
       subpd %xmm3,%xmm5
       addpd %xmm7,%xmm3

       movaps %xmm6,%xmm7
       subpd %xmm4,%xmm6
       addpd %xmm7,%xmm4

       movaps %xmm3,%xmm7
       subpd %xmm4,%xmm3
       addpd %xmm7,%xmm4

       movaps %xmm1,48(%eax)
       movaps %xmm3,176(%eax)       
       movaps %xmm4,144(%eax)              

#-------------

       movaps .C1,%xmm1
       movaps .C3,%xmm3       

       movaps %xmm0,%xmm7
       subpd %xmm6,%xmm0
       addpd %xmm7,%xmm6

       movaps %xmm5,%xmm7
       subpd %xmm2,%xmm5
       addpd %xmm7,%xmm2

       movaps %xmm1,%xmm7
       movaps %xmm3,%xmm4
       
       mulpd %xmm5,%xmm7
       mulpd %xmm0,%xmm4       
       subpd %xmm7,%xmm4
       
       mulpd %xmm1,%xmm0
       mulpd %xmm3,%xmm5
       addpd %xmm5,%xmm0
       
       movaps %xmm1,%xmm7
       
       mulpd %xmm6,%xmm7
       mulpd %xmm3,%xmm6
       
       mulpd %xmm2,%xmm3
       subpd %xmm3,%xmm7

       mulpd %xmm1,%xmm2
       addpd %xmm2,%xmm6

       movaps %xmm0,112(%eax)       
       movaps %xmm4,80(%eax)
       
       movaps %xmm6,240(%eax)              
       movaps %xmm7,208(%eax)
       
#-----------------------------------

       movaps (%eax), %xmm0
       movaps 128(%eax), %xmm3
       movaps 64(%eax), %xmm2
       movaps 192(%eax), %xmm1
       
       movaps %xmm0,%xmm7
       subpd %xmm3,%xmm0       
       addpd %xmm7,%xmm3

       movaps %xmm2,%xmm7
       subpd %xmm1,%xmm2
       addpd %xmm7,%xmm1
       
       movaps %xmm3,%xmm7
       subpd %xmm1,%xmm3
       addpd %xmm7,%xmm1
       
       movaps %xmm1,(%eax)
       
#-----------------------------------

       movaps 32(%eax), %xmm5
       movaps 96(%eax), %xmm6       
       movaps 160(%eax), %xmm4
       movaps 224(%eax), %xmm1

       movaps %xmm5,%xmm7
       subpd %xmm4,%xmm5
       addpd %xmm7,%xmm4
       
       movaps %xmm6,%xmm7
       subpd %xmm1,%xmm6
       addpd %xmm7,%xmm1
       
       movaps %xmm4,%xmm7
       subpd %xmm1,%xmm4
       addpd %xmm7,%xmm1
       
       movaps %xmm5,%xmm7
       subpd %xmm6,%xmm5
       addpd %xmm7,%xmm6
       
       movaps %xmm1,128(%eax)
       
#-----------------------------------

       movaps .C2,%xmm1
       mulpd %xmm1,%xmm5
       mulpd %xmm1,%xmm6       
       movaps %xmm0,%xmm7
       subpd %xmm5,%xmm0
       addpd %xmm7,%xmm5

       movaps %xmm2,%xmm7
       subpd %xmm6,%xmm2
       addpd %xmm7,%xmm6
       
       movaps %xmm0,64(%eax)
       movaps %xmm2,192(%eax)
       
#-----------------------------------

       movaps 48(%eax), %xmm2
       movaps 176(%eax), %xmm7       
       
       mulpd %xmm1,%xmm2
       mulpd %xmm1,%xmm7
       
       movaps .CI,%xmm1

       movaps %xmm2,%xmm0
       subpd %xmm7,%xmm2
       addpd %xmm0,%xmm7

       xorpd %xmm1,%xmm4
       shufpd $0x1,%xmm4,%xmm4       
       
       xorpd %xmm1,%xmm7
       shufpd $0x1,%xmm7,%xmm7       

       movaps %xmm3,%xmm0
       subpd %xmm2,%xmm3
       addpd %xmm0,%xmm2

       movaps %xmm7,%xmm0
       subpd %xmm4,%xmm7
       addpd %xmm0,%xmm4
       
       movaps %xmm2,%xmm0
       subpd %xmm4,%xmm2
       addpd %xmm0,%xmm4

       movaps %xmm3,%xmm0
       subpd %xmm7,%xmm3
       addpd %xmm0,%xmm7
       
       movaps %xmm4,32(%eax)              
       movaps %xmm7,96(%eax)
       movaps %xmm3,160(%eax)
       movaps %xmm2,224(%eax)       
       
#-----------------------------------       
       
       movaps 16(%eax), %xmm2
       movaps 112(%eax), %xmm4
       movaps 144(%eax), %xmm7       
       movaps 240(%eax), %xmm3
       
       movaps %xmm5,%xmm0
       subpd %xmm4,%xmm5
       addpd %xmm0,%xmm4
       
       movaps %xmm3,%xmm0
       subpd %xmm6,%xmm3
       addpd %xmm0,%xmm6
       xorpd %xmm1,%xmm3
       shufpd $0x1,%xmm3,%xmm3
       xorpd %xmm1,%xmm6
       shufpd $0x1,%xmm6,%xmm6       

       movaps %xmm4,%xmm0
       subpd %xmm6,%xmm4
       addpd %xmm0,%xmm6
       
       movaps %xmm5,%xmm0
       subpd %xmm3,%xmm5
       addpd %xmm0,%xmm3

       movaps %xmm6,16(%eax)              
       movaps %xmm3,112(%eax)
       movaps %xmm5,144(%eax)
       movaps %xmm4,240(%eax)       
       
#-----------------------------------

       movaps (%eax), %xmm3
       movaps 64(%eax), %xmm4
       movaps 128(%eax), %xmm5
       movaps 192(%eax), %xmm6

       movaps %xmm3,%xmm0
       subpd %xmm5,%xmm3
       addpd %xmm0,%xmm5

       movaps %xmm2,%xmm0
       subpd %xmm7,%xmm2
       addpd %xmm0,%xmm7

       xorpd %xmm1,%xmm2
       shufpd $0x1,%xmm2,%xmm2       

       movaps %xmm5,%xmm0
       subpd %xmm7,%xmm5
       addpd %xmm0,%xmm7
       
       movaps %xmm3,%xmm0
       subpd %xmm2,%xmm3
       addpd %xmm0,%xmm2

       movaps %xmm7,(%eax)
       movaps %xmm2,64(%eax)
       movaps %xmm5,128(%eax)       
       movaps %xmm3,192(%eax)
       
#-----------------------------------       
       
       movaps 80(%eax), %xmm3
       movaps 208(%eax), %xmm5
       
       movaps %xmm4,%xmm0
       subpd %xmm3,%xmm4
       addpd %xmm0,%xmm3

       movaps %xmm5,%xmm0
       subpd %xmm6,%xmm5
       addpd %xmm0,%xmm6

       xorpd %xmm1,%xmm5
       shufpd $0x1,%xmm5,%xmm5       
       xorpd %xmm1,%xmm6
       shufpd $0x1,%xmm6,%xmm6       
       
       movaps %xmm3,%xmm0
       subpd %xmm5,%xmm3
       addpd %xmm0,%xmm5
       
       movaps %xmm4,%xmm0
       subpd %xmm6,%xmm4
       addpd %xmm0,%xmm6

       movaps %xmm5,48(%eax)
       movaps %xmm6,80(%eax)
       movaps %xmm4,176(%eax)
       movaps %xmm3,208(%eax)              

       ret

.align 4
.CI:
      .long 0x0, 0x80000000, 0x0, 0x0
.align 4
.C1:
      .long 0xcf328d46,0x3fed906b,0xcf328d46,0x3fed906b
.align 4
.C2:
      .long 0x667f3bcd, 0x3fe6a09e,0x667f3bcd, 0x3fe6a09e
.align 4
.C3:
      .long 0xa6aea963,0x3fd87de2,0xa6aea963,0x3fd87de2
