########################################################################
# ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING
# Copyright (C) 1998--2011 Keiichi Ishioka <ishioka@gfd-dennou.org>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301 USA.
########################################################################
.text
.globl _ljngzs_
_ljngzs_:
       vzeroall 
       vbroadcastsd  (%rcx), %ymm4 # R  ymm4 4ս
       movl (%rdi), %ecx  # : JH  rcx 	

       shlq $3,%rcx # JH*8  rcx 
       movq $0,%rdi
       subq %rcx,%rdi
       movq %rdi,%rax

       movq  8(%rsp), %r10  # : QB Υ١ɥ쥹       
       movq 16(%rsp), %r11  # : W1 Υ١ɥ쥹
       movq 24(%rsp), %rcx  # : W2 Υ١ɥ쥹                     
       
      # Y : r8, QA: r9, QB: r10, W1R: r11, W2R: rcx

       subq %rdi,%r8	
       subq %rdi,%r9
       subq %rdi,%r10
       subq %rdi,%r11
       subq %rdi,%rcx

.align 4
L0:
       vmulpd (%r8,%rdi),%ymm4,%ymm5 # Y*R		
       vmovapd (%r9,%rdi), %ymm6 # QA
       vmulpd %ymm6,%ymm5,%ymm5 # R*Y*QA	
       vaddpd (%r10,%rdi), %ymm5,%ymm5 # 줿 QB  ymm5 
       vmulpd (%r11,%rdi),%ymm6,%ymm7 # W1*QA  ymm7 
       vmulpd (%rcx,%rdi),%ymm6,%ymm9 # W2*QA  ymm9 
       vaddpd %ymm7,%ymm0,%ymm0
       vaddpd %ymm9,%ymm2,%ymm2
       vmovaps %ymm5,(%r10,%rdi) # 줿 QB 򥹥ȥ	
       addq $32,%rdi
       jnz L0

       addq %rax,%r8		
       vmovapd (%r8),%ymm5 # Y Ƭö ymm5 
       vmovapd %ymm0,(%r8) # ymm0  Y Ƭ
       fldl (%r8)
       faddl 8(%r8)
       faddl 16(%r8)
       faddl 24(%r8)			
       fstpl (%rsi) # S1 ¤ (%rsi) 

       vmovapd %ymm2,(%r8) # ymm2  Y Ƭ
       fldl (%r8)
       faddl 8(%r8)
       faddl 16(%r8)
       faddl 24(%r8)			
       fstpl (%rdx) # S2 ¤ (%rdx) 

       vmovapd %ymm5,(%r8) # Y Ƭ
       
       ret
       
