require "numru/gphys"
require "numru/dcl"

module NumRu

   # add methods to GPhys
   class GPhys
      def first2D
	 raise "rank less than 2" if rank < 2
	 self[true,true,*([0]*(rank-2))]
      end
      def first1D
	 raise "rank less than 1" if rank < 1
	 self[true,*([0]*(rank-1))]
      end
   end

   module GGraph

      module_function

      def axes(xax, yax, itr=1, viewport=[0.2,0.8,0.2,0.8])
	 xai = _get_axinfo(xax)
	 yai = _get_axinfo(yax)
	 xv = xai['val']
	 yv = yai['val']
	 DCL.grstrn(itr)
	 DCL.grsvpt(*viewport)
	 DCL.usspnt([xv.min,xv.max],[yv.min,yv.max])
	 DCL.uspfit
	 DCL.grstrf
	 DCL.ussttl(xai['title'],xai['units'], yai['title'],yai['units'])
	 DCL.usdaxs
      end

      def _get_axinfo(vary)
	 raise ArgumentError,"not a VArray" if !vary.is_a?(VArray)
	 raise "Not 1D" if vary.rank!=1
	 {  'val'=>vary.val , 
	    'title'=>(vary.attr['long_name'] || vary.name) ,
	    'units'=>(vary.attr['units'] || '')
	 }
      end
   end

end
