require 'easy_vtk'

dim = 10

x = Vtk::FloatArray.new
y = Vtk::FloatArray.new
z = Vtk::FloatArray.new
x.SetNumberOfValues( dim )
y.SetNumberOfValues( dim )
z.SetNumberOfValues( dim )
dx = 1.0/dim
for i in 0...dim
  x.SetValue( i, i*dx )
  y.SetValue( i, i*dx )
  z.SetValue( i, i*dx )
end

data = Vtk::FloatArray.new
data.SetNumberOfValues( dim*dim*dim )
for k in 0...dim
  for j in 0...dim
    for i in 0...dim
      val = 2.0*(i.to_f/(dim-1)-0.5)**2 + 1.0*(j.to_f/(dim-1)-0.5)**2 + 0.5*(k.to_f/(dim-1)-0.5)**2
      data.SetValue( k*dim*dim+j*dim+i, val )
    end
  end
end


EasyVtk::init
EasyVtk::set_axes( x, y, z )
EasyVtk::set_data( data )
EasyVtk::plane( [0.5, 0.5, 0.5], [0, 0, 1] )
EasyVtk::plane( [0.5, 0.5, 0.5], [0, 1, 0] )
EasyVtk::plane( [0.5, 0.5, 0.5], [1, 0, 0], 'axes'=>true )
EasyVtk::colorbar( 'orientation' => 'horizontal',
                   'height' => 0.17,
                   'width' => 0.5,
                   'position' => [ 0.25, 0.05 ]
                  )
EasyVtk::gui_start
