require "numru/gphys"

module NumRu
  module GAnalysis

    module_function

    def covariance(gphys0, gphys1, *dims)
      unless GPhys===gphys0 && GPhys===gphys1
        raise "gphys0 and gphys1 must be GPhys"
      end
      unless gphys0.shape == gphys1.shape
        raise "gphys0 and gphys1 must have the same shape"
      end
      units = gphys0.units*gphys1.units
      if dims.length == 0
        dims = Array.new
        gphys0.rank.times{|i| dims.push i }
      else
        dims = dims.map{|dim| gphys0.dim_index(dim) }
      end
      ndiv = 1
      gphys0.shape.each_with_index{|s,i|
        ndiv *= s if dims.include?(i)
      }
      val0 = gphys0.val
      val1 = gphys1.val
      val0 -= val0.accum(*dims).div!(ndiv)
      val1 -= val1.accum(*dims).div!(ndiv)
      nary = val0.mul_add(val1,*dims)
      if Float === nary
        nary /= (ndiv-1)
        return UNumeric.new(nary, units)
      else
        nary.div!(ndiv-1)
        vary = VArray.new(nary,
                          {"long_name"=>"covariance","units"=>units.to_s},
                          "covariance")
        new_grid = gphys0.grid.delete_axes(dims, "covariance").copy
        return GPhys.new(new_grid,vary)
      end
    end

    def corelation(gphys0, gphys1, *dims)
      covariance = gphys0.covariance(gphys1,*dims)
      return covariance/(gphys0.stddev(*dims)*gphys1.stddev(*dims))
    end

  end

  class GPhys
    def covariance(other, *dims)
      GAnalysis.covariance(self, other, *dims)
    end

    def corelation(other, *dims)
      GAnalysis.corelation(self, other, *dims)
    end
  end
end

