
// -*- mode: c++; c-basic-offset:4 -*-

// This file is part of libdap, A C++ implementation of the OPeNDAP Data
// Access Protocol.

// Copyright (c) 2002,2003,2005 OPeNDAP, Inc.
// Author: James Gallagher <jgallagher@opendap.org>
//         Reza Nekovei <reza@intcomm.net>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// You can contact OPeNDAP, Inc. at PO Box 112, Saunderstown, RI. 02874-0112.

// DODS C++ header file for netcdf surrogate library. 
// 
// ReZa 10/6/94

#ifndef _dnetcdf_h
#define _dnetcdf_h 1

#include  <netcdf.h>		// netcdf interface

#include  <string>

#include "lnetcdf.h"		// local netcdf interface
#include "Connect.h"
#include "NCConnect.h"
#include "Connections.h"	// Connections class interface

extern Connections<NCConnect *>  *conns;

extern "C" void NCadvise(int err, char *fmt,...); // netcdf error handling

extern "C" char *cdf_routine_name;
extern int rcode;		// return code

/* 
 * $Log: Dnetcdf.h,v $
 * Revision 1.7  2005/03/04 18:10:49  jimg
 * At this point valgrind runs the Unidata tests for both local and remote access
 * and shows no errors or leaks. There are 8 bytes still reachable from an
 * exception, but that's it.
 *
 * Revision 1.6  2005/03/02 17:51:50  jimg
 * Considerable reduction in memory leaks and fixed all errant memory
 * accesses found with nc_test. OPeNDAP error codes and Error object
 * message strings are now reported using the nc_strerrror() function!
 *
 * Revision 1.5  2004/02/19 19:42:55  jimg
 * Merged with release-3-4-2FCS and resolved conflicts.
 *
 * Revision 1.3.4.1  2004/02/13 19:18:50  jimg
 * I added a declaration of nc_delete as extern "C". This was in response
 * to a bug report on dods@unidata.ucar.edu.
 *
 * Revision 1.4  2003/12/08 18:06:37  edavis
 * Merge release-3-4 into trunk
 *
 * Revision 1.3  2002/05/03 00:01:52  jimg
 * Merged with release-3-2-7.
 *
 * Revision 1.2.4.1  2001/12/26 10:07:20  rmorris
 * Minor win32 fix - seems like a VC++ variation on name mangling
 * as opposed to unix, but can't be sure.
 *
 * Revision 1.2  2000/10/06 01:22:02  jimg
 * Moved the CVS Log entries to the ends of files.
 * Modified the read() methods to match the new definition in the dap library.
 * Added exception handlers in various places to catch exceptions thrown
 * by the dap library.
 *
 * Revision 1.1  1999/07/28 00:22:41  jimg
 * Added
 *
 * Revision 1.10  1999/05/07 23:45:31  jimg
 * String --> string fixes
 *
 * Revision 1.9  1998/02/05 20:14:44  jimg
 * DODS now compiles with gcc 2.8.x
 *
 * Revision 1.8  1996/09/17 00:26:09  jimg
 * Merged changes from a side branch which contained various changes from
 * Reza and Charles.
 * Removed ncdump and netexec since ncdump is now in its own directory and
 * netexec is no longer used.
 *
 * Revision 1.7.2.2  1996/07/10 21:43:47  jimg
 * Changes for version 2.06. These fixed lingering problems from the migration
 * from version 1.x to version 2.x.
 * Removed some (but not all) warning generated with gcc's -Wall option.
 *
 * Revision 1.7.2.1  1996/06/25 22:04:10  jimg
 * Version 2.0 from Reza.
 *
 * Revision 1.6  1995/03/21  20:58:14  jimg
 * Resolved conflicts between my (jhrg) files and those checked in by Reza.
 *
 * Revision 1.5  1995/03/16  16:56:22  reza
 * Updated for the new DAP. All the read_val mfunc. and their memory management
 * are now moved to their parent class.
 * Data transfers are now in binary while DAS and DDS are still sent in ASCII.
 *
 * Revision 1.4  1995/01/31  20:21:30  reza
 * Modified for new type subclassed DAP implementation.
 *
 * Revision 1.3  1994/12/08  19:04:51  reza
 * Added support for local netCDF file access through the original netCDF code.
 *
 * Revision 1.2  1994/11/23  21:06:07  reza
 * First working version.
 *
 * Revision 1.1  1994/11/03  04:37:55  reza
 * Preliminary version of netCDF -> DODS library.
 * 
 */

#endif /* _dnetcdf_h */
