
#ifndef _LNETCDF_
#define _LNETCDF_

#if defined(__cplusplus)
extern "C" {
#endif

EXTERNL const char *
lnc_inq_libvers(void);

EXTERNL const char *
lnc_strerror(int ncerr);

/* #ifdef _CRAYMPP */

EXTERNL int
lnc__create_mp(const char *path, int cmode, size_t initialsz, int basepe,
	 size_t *chunksizehintp, int *ncidp);

/* #endif _CRAYMPP */

EXTERNL int
lnc_delete(const char * path);

EXTERNL int
lnc_delete_mp(const char * path, int basepe);

EXTERNL int
lnc_set_base_pe(int ncid, int pe);

EXTERNL int
lnc_inq_base_pe(int ncid, int *pe);

EXTERNL int
lnc__create_mp(const char *path, int cmode, size_t initialsz, int basepe,
	 size_t *chunksizehintp, int *ncidp);

EXTERNL int
lnc__open_mp(const char * urlpath, int ioflags, int basepe,
	    size_t *chunksizehintp, int *ncid_ptr);

/* #endif _CRAYMPP */

EXTERNL int
lnc_delete(const char * path);

EXTERNL int
lnc__create(const char *path, int cmode, size_t initialsz,
	 size_t *chunksizehintp, int *ncidp);

EXTERNL int
lnc_create(const char *path, int cmode, int *ncidp);

EXTERNL int
lnc__open(const char *path, int mode, 
	size_t *chunksizehintp, int *ncidp);

EXTERNL int
lnc_open(const char *path, int mode, int *ncidp);

EXTERNL int
lnc_set_fill(int ncid, int fillmode, int *old_modep);

EXTERNL int
lnc_redef(int ncid);

EXTERNL int
lnc__enddef(int ncid, size_t h_minfree, size_t v_align,
	size_t v_minfree, size_t r_align);

EXTERNL int
lnc_enddef(int ncid);

EXTERNL int
lnc_sync(int ncid);

EXTERNL int
lnc_abort(int ncid);

EXTERNL int
lnc_close(int ncid);

EXTERNL int
lnc_inq(int ncid, int *ndimsp, int *nvarsp, int *nattsp, int *unlimdimidp);

EXTERNL int 
lnc_inq_ndims(int ncid, int *ndimsp);

EXTERNL int 
lnc_inq_nvars(int ncid, int *nvarsp);

EXTERNL int 
lnc_inq_natts(int ncid, int *nattsp);

EXTERNL int 
lnc_inq_unlimdim(int ncid, int *unlimdimidp);

/* Begin _dim */

EXTERNL int
lnc_def_dim(int ncid, const char *name, size_t len, int *idp);

EXTERNL int
lnc_inq_dimid(int ncid, const char *name, int *idp);

EXTERNL int
lnc_inq_dim(int ncid, int dimid, char *name, size_t *lenp);

EXTERNL int 
lnc_inq_dimname(int ncid, int dimid, char *name);

EXTERNL int 
lnc_inq_dimlen(int ncid, int dimid, size_t *lenp);

EXTERNL int
lnc_rename_dim(int ncid, int dimid, const char *name);

/* End _dim */
/* Begin _att */

EXTERNL int
lnc_inq_att(int ncid, int varid, const char *name,
	 nc_type *xtypep, size_t *lenp);

EXTERNL int 
lnc_inq_attid(int ncid, int varid, const char *name, int *idp);

EXTERNL int 
lnc_inq_atttype(int ncid, int varid, const char *name, nc_type *xtypep);

EXTERNL int 
lnc_inq_attlen(int ncid, int varid, const char *name, size_t *lenp);

EXTERNL int
lnc_inq_attname(int ncid, int varid, int attnum, char *name);

EXTERNL int
lnc_copy_att(int ncid_in, int varid_in, const char *name, int ncid_out, int varid_out);

EXTERNL int
lnc_rename_att(int ncid, int varid, const char *name, const char *newname);

EXTERNL int
lnc_del_att(int ncid, int varid, const char *name);

/* End _att */
/* Begin {put,get}_att */

EXTERNL int
lnc_put_att_text(int ncid, int varid, const char *name,
	size_t len, const char *op);

EXTERNL int
lnc_get_att_text(int ncid, int varid, const char *name, char *ip);

EXTERNL int
lnc_put_att_uchar(int ncid, int varid, const char *name, nc_type xtype,
	size_t len, const unsigned char *op);

EXTERNL int
lnc_get_att_uchar(int ncid, int varid, const char *name, unsigned char *ip);

EXTERNL int
lnc_put_att_schar(int ncid, int varid, const char *name, nc_type xtype,
	size_t len, const signed char *op);

EXTERNL int
lnc_get_att_schar(int ncid, int varid, const char *name, signed char *ip);

EXTERNL int
lnc_put_att_short(int ncid, int varid, const char *name, nc_type xtype,
	size_t len, const short *op);

EXTERNL int
lnc_get_att_short(int ncid, int varid, const char *name, short *ip);

EXTERNL int
lnc_put_att_int(int ncid, int varid, const char *name, nc_type xtype,
	size_t len, const int *op);

EXTERNL int
lnc_get_att_int(int ncid, int varid, const char *name, int *ip);

EXTERNL int
lnc_put_att_long(int ncid, int varid, const char *name, nc_type xtype,
	size_t len, const long *op);

EXTERNL int
lnc_get_att_long(int ncid, int varid, const char *name, long *ip);

EXTERNL int
lnc_put_att_float(int ncid, int varid, const char *name, nc_type xtype,
	size_t len, const float *op);

EXTERNL int
lnc_get_att_float(int ncid, int varid, const char *name, float *ip);

EXTERNL int
lnc_put_att_double(int ncid, int varid, const char *name, nc_type xtype,
	size_t len, const double *op);

EXTERNL int
lnc_get_att_double(int ncid, int varid, const char *name, double *ip);

/* End {put,get}_att */
/* Begin _var */

EXTERNL int
lnc_def_var(int ncid, const char *name,
	 nc_type xtype, int ndims, const int *dimidsp, int *varidp);

EXTERNL int
lnc_inq_var(int ncid, int varid, char *name,
	 nc_type *xtypep, int *ndimsp, int *dimidsp, int *nattsp);

EXTERNL int
lnc_inq_varid(int ncid, const char *name, int *varidp);

EXTERNL int 
lnc_inq_varname(int ncid, int varid, char *name);

EXTERNL int 
lnc_inq_vartype(int ncid, int varid, nc_type *xtypep);

EXTERNL int 
lnc_inq_varndims(int ncid, int varid, int *ndimsp);

EXTERNL int 
lnc_inq_vardimid(int ncid, int varid, int *dimidsp);

EXTERNL int 
lnc_inq_varnatts(int ncid, int varid, int *nattsp);

EXTERNL int
lnc_rename_var(int ncid, int varid, const char *name);

EXTERNL int
lnc_copy_var(int ncid_in, int varid, int ncid_out);
#ifndef ncvarcpy
/* support the old name for now */
#define ncvarcpy(ncid_in, varid, ncid_out) ncvarcopy((ncid_in), (varid), (ncid_out))
#endif

/* End _var */
/* Begin {put,get}_var1 */

EXTERNL int
lnc_put_var1_text(int ncid, int varid, const size_t *indexp, const char *op);

EXTERNL int
lnc_get_var1_text(int ncid, int varid, const size_t *indexp, char *ip);

EXTERNL int
lnc_put_var1_uchar(int ncid, int varid, const size_t *indexp,
	const unsigned char *op);

EXTERNL int
lnc_get_var1_uchar(int ncid, int varid, const size_t *indexp,
	unsigned char *ip);

EXTERNL int
lnc_put_var1_schar(int ncid, int varid, const size_t *indexp,
	const signed char *op);

EXTERNL int
lnc_get_var1_schar(int ncid, int varid, const size_t *indexp,
	signed char *ip);

EXTERNL int
lnc_put_var1_short(int ncid, int varid, const size_t *indexp,
	const short *op);

EXTERNL int
lnc_get_var1_short(int ncid, int varid, const size_t *indexp,
	short *ip);

EXTERNL int
lnc_put_var1_int(int ncid, int varid, const size_t *indexp, const int *op);

EXTERNL int
lnc_get_var1_int(int ncid, int varid, const size_t *indexp, int *ip);

EXTERNL int
lnc_put_var1_long(int ncid, int varid, const size_t *indexp, const long *op);

EXTERNL int
lnc_get_var1_long(int ncid, int varid, const size_t *indexp, long *ip);

EXTERNL int
lnc_put_var1_float(int ncid, int varid, const size_t *indexp, const float *op);

EXTERNL int
lnc_get_var1_float(int ncid, int varid, const size_t *indexp, float *ip);

EXTERNL int
lnc_put_var1_double(int ncid, int varid, const size_t *indexp, const double *op);

EXTERNL int
lnc_get_var1_double(int ncid, int varid, const size_t *indexp, double *ip);

/* End {put,get}_var1 */
/* Begin {put,get}_vara */

EXTERNL int
lnc_put_vara_text(int ncid, int varid,
	const size_t *startp, const size_t *countp, const char *op);

EXTERNL int
lnc_get_vara_text(int ncid, int varid,
	const size_t *startp, const size_t *countp, char *ip);

EXTERNL int
lnc_put_vara_uchar(int ncid, int varid,
	const size_t *startp, const size_t *countp, const unsigned char *op);

EXTERNL int
lnc_get_vara_uchar(int ncid, int varid,
	const size_t *startp, const size_t *countp, unsigned char *ip);

EXTERNL int
lnc_put_vara_schar(int ncid, int varid,
	const size_t *startp, const size_t *countp, const signed char *op);

EXTERNL int
lnc_get_vara_schar(int ncid, int varid,
	const size_t *startp, const size_t *countp, signed char *ip);

EXTERNL int
lnc_put_vara_short(int ncid, int varid,
	const size_t *startp, const size_t *countp, const short *op);

EXTERNL int
lnc_get_vara_short(int ncid, int varid,
	const size_t *startp, const size_t *countp, short *ip);

EXTERNL int
lnc_put_vara_int(int ncid, int varid,
	const size_t *startp, const size_t *countp, const int *op);

EXTERNL int
lnc_get_vara_int(int ncid, int varid,
	const size_t *startp, const size_t *countp, int *ip);

EXTERNL int
lnc_put_vara_long(int ncid, int varid,
	const size_t *startp, const size_t *countp, const long *op);

EXTERNL int
lnc_get_vara_long(int ncid, int varid,
	const size_t *startp, const size_t *countp, long *ip);

EXTERNL int
lnc_put_vara_float(int ncid, int varid,
	const size_t *startp, const size_t *countp, const float *op);

EXTERNL int
lnc_get_vara_float(int ncid, int varid,
	const size_t *startp, const size_t *countp, float *ip);

EXTERNL int
lnc_put_vara_double(int ncid, int varid,
	const size_t *startp, const size_t *countp, const double *op);

EXTERNL int
lnc_get_vara_double(int ncid, int varid,
	const size_t *startp, const size_t *countp, double *ip);

/* End {put,get}_vara */
/* Begin {put,get}_vars */

EXTERNL int
lnc_put_vars_text(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const char *op);

EXTERNL int
lnc_get_vars_text(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	char *ip);

EXTERNL int
lnc_put_vars_uchar(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const unsigned char *op);

EXTERNL int
lnc_get_vars_uchar(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	unsigned char *ip);

EXTERNL int
lnc_put_vars_schar(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const signed char *op);

EXTERNL int
lnc_get_vars_schar(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	signed char *ip);

EXTERNL int
lnc_put_vars_short(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const short *op);

EXTERNL int
lnc_get_vars_short(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	short *ip);

EXTERNL int
lnc_put_vars_int(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const int *op);

EXTERNL int
lnc_get_vars_int(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	int *ip);

EXTERNL int
lnc_put_vars_long(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const long *op);

EXTERNL int
lnc_get_vars_long(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	long *ip);

EXTERNL int
lnc_put_vars_float(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const float *op);

EXTERNL int
lnc_get_vars_float(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	float *ip);

EXTERNL int
lnc_put_vars_double(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const double *op);

EXTERNL int
lnc_get_vars_double(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	double *ip);

/* End {put,get}_vars */
/* Begin {put,get}_varm */

EXTERNL int
lnc_put_varm_text(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	const char *op);

EXTERNL int
lnc_get_varm_text(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	char *ip);

EXTERNL int
lnc_put_varm_uchar(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	const unsigned char *op);

EXTERNL int
lnc_get_varm_uchar(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	unsigned char *ip);

EXTERNL int
lnc_put_varm_schar(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	const signed char *op);

EXTERNL int
lnc_get_varm_schar(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	signed char *ip);

EXTERNL int
lnc_put_varm_short(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	const short *op);

EXTERNL int
lnc_get_varm_short(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	short *ip);

EXTERNL int
lnc_put_varm_int(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	const int *op);

EXTERNL int
lnc_get_varm_int(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	int *ip);

EXTERNL int
lnc_put_varm_long(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	const long *op);

EXTERNL int
lnc_get_varm_long(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	long *ip);

EXTERNL int
lnc_put_varm_float(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	const float *op);

EXTERNL int
lnc_get_varm_float(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	float *ip);

EXTERNL int
lnc_put_varm_double(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t *imapp, 
	const double *op);

EXTERNL int
lnc_get_varm_double(int ncid, int varid,
	const size_t *startp, const size_t *countp, const ptrdiff_t *stridep,
	const ptrdiff_t * imap, 
	double *ip);

/* End {put,get}_varm */
/* Begin {put,get}_var */

EXTERNL int
lnc_put_var_text(int ncid, int varid, const char *op);

EXTERNL int
lnc_get_var_text(int ncid, int varid, char *ip);

EXTERNL int
lnc_put_var_uchar(int ncid, int varid, const unsigned char *op);

EXTERNL int
lnc_get_var_uchar(int ncid, int varid, unsigned char *ip);

EXTERNL int
lnc_put_var_schar(int ncid, int varid, const signed char *op);

EXTERNL int
lnc_get_var_schar(int ncid, int varid, signed char *ip);

EXTERNL int
lnc_put_var_short(int ncid, int varid, const short *op);

EXTERNL int
lnc_get_var_short(int ncid, int varid, short *ip);

EXTERNL int
lnc_put_var_int(int ncid, int varid, const int *op);

EXTERNL int
lnc_get_var_int(int ncid, int varid, int *ip);

EXTERNL int
lnc_put_var_long(int ncid, int varid, const long *op);

EXTERNL int
lnc_get_var_long(int ncid, int varid, long *ip);

EXTERNL int
lnc_put_var_float(int ncid, int varid, const float *op);

EXTERNL int
lnc_get_var_float(int ncid, int varid, float *ip);

EXTERNL int
lnc_put_var_double(int ncid, int varid, const double *op);

EXTERNL int
lnc_get_var_double(int ncid, int varid, double *ip);

/* End {put,get}_var */

/* Begin v2.4 backward compatiblity */
/*
 * defining NO_NETCDF_2 to the preprocessor
 * turns off backward compatiblity declarations.
 */
#ifndef NO_NETCDF_2


EXTERNL void
lnc_advise(const char *cdf_routine_name, int err, const char *fmt,...);

/*
 * C data type corresponding to a netCDF NC_LONG argument,
 * a signed 32 bit object.
 * 
 * This is the only thing in this file which architecture dependent.
 */

EXTERNL int
lnctypelen(nc_type datatype);

EXTERNL int
lnccreate(const char* path, int cmode);

EXTERNL int
lncopen(const char* path, int mode);

EXTERNL int
lncsetfill(int ncid, int fillmode);

EXTERNL int
lncredef(int ncid);

EXTERNL int
lncendef(int ncid);

EXTERNL int
lncsync(int ncid);

EXTERNL int
lncabort(int ncid);

EXTERNL int
lncclose(int ncid);

EXTERNL int
lncinquire(int ncid, int *ndimsp, int *nvarsp, int *nattsp, int *unlimdimp);

EXTERNL int
lncdimdef(int ncid, const char *name, long len);

EXTERNL int
lncdimid(int ncid, const char *name);

EXTERNL int
lncdiminq(int ncid, int dimid, char *name, long *lenp);

EXTERNL int
lncdimrename(int ncid, int dimid, const char *name);

EXTERNL int
lncattput(int ncid, int varid, const char *name, nc_type xtype,
	int len, const void *op);

EXTERNL int
lncattinq(int ncid, int varid, const char *name, nc_type *xtypep, int *lenp);

EXTERNL int
lncattget(int ncid, int varid, const char *name, void *ip);

EXTERNL int
lncattcopy(int ncid_in, int varid_in, const char *name, int ncid_out,
	int varid_out);

EXTERNL int
lncattname(int ncid, int varid, int attnum, char *name);

EXTERNL int
lncattrename(int ncid, int varid, const char *name, const char *newname);

EXTERNL int
lncattdel(int ncid, int varid, const char *name);

EXTERNL int
lncvardef(int ncid, const char *name, nc_type xtype,
	int ndims, const int *dimidsp);

EXTERNL int
lncvarid(int ncid, const char *name);

EXTERNL int
lncvarinq(int ncid, int varid, char *name, nc_type *xtypep,
	int *ndimsp, int *dimidsp, int *nattsp);

EXTERNL int
lncvarput1(int ncid, int varid, const long *indexp, const void *op);

EXTERNL int
lncvarget1(int ncid, int varid, const long *indexp, void *ip);

EXTERNL int
lncvarput(int ncid, int varid, const long *startp, const long *countp,
	const void *op);

EXTERNL int
lncvarget(int ncid, int varid, const long *startp, const long *countp, 
	void *ip);

EXTERNL int
lncvarputs(int ncid, int varid, const long *startp, const long *countp,
	const long *stridep, const void *op);

EXTERNL int
lncvargets(int ncid, int varid, const long *startp, const long *countp,
	const long *stridep, void *ip);

EXTERNL int
lncvarputg(int ncid, int varid, const long *startp, const long *countp,
	const long *stridep, const long *imapp, const void *op);

EXTERNL int
lncvargetg(int ncid, int varid, const long *startp, const long *countp,
	const long *stridep, const long *imapp, void *ip);

EXTERNL int
lncvarrename(int ncid, int varid, const char *name);

EXTERNL int
lncrecinq(int ncid, int *nrecvarsp, int *recvaridsp, long *recsizesp);

EXTERNL int
lncrecget(int ncid, long recnum, void **datap);

EXTERNL int
lncrecput(int ncid, long recnum, void *const *datap);

EXTERNL int
lnc_put_att(int cdfid, int varid, const char *name, nc_type type,
        size_t nelems, const void *value);

EXTERNL int
lnc_get_att(int cdfid, int varid, const char *name, void *values);

EXTERNL int
lncvarcopy(int incdf, int varid, int outcdf);

extern int
lnc_put_att(int ncid, int varid, const char *name, nc_type datatype,
        size_t len, const void *value);

extern int
lnc_get_att(int ncid, int varid, const char *name, void *value);

extern int
lnc_put_var1(int ncid, int varid, const size_t *index, const void *value);

extern int
lnc_get_var1(int ncid, int varid, const size_t *index, void *value);

extern int
lnc_put_vara(int ncid, int varid,
         const size_t *start, const size_t *count, const void *value);

extern int
lnc_get_vara(int ncid, int varid,
         const size_t *start, const size_t *count, void *value);

extern int
lnc_put_vars(int ncid, int varid,
         const size_t *start, const size_t *count, const ptrdiff_t *stride,
         const void * value);

extern int
lnc_get_vars(int ncid, int varid,
         const size_t *start, const size_t *count, const ptrdiff_t *stride,
         void * value);

extern int
lnc_put_varm(int ncid, int varid,
         const size_t *start, const size_t *count, const ptrdiff_t *stride,
         const ptrdiff_t * map, const void *value);

extern int
lnc_get_varm(int ncid, int varid,
         const size_t *start, const size_t *count, const ptrdiff_t *stride,
         const ptrdiff_t * map, void *value);

extern int
lnc_inq_rec(int ncid, size_t *nrecvars, int *recvarids, size_t *recsizes);

extern int
lnc_get_rec(int ncid, size_t recnum, void **datap);

extern int
lnc_put_rec(int ncid, size_t recnum, void *const *datap);

/* End v2.4 backward compatiblity */
#endif /*!NO_NETCDF_2*/

#if defined(__cplusplus)
}
#endif

#endif /* _NETCDF_ */
