#!/usr/bin/env ruby
require("gsl")
include Math

# Function to be expanded
G = Function.new { |x| exp(-x*x) }
#G = Function.new { |x| sin(-x*x) }

# Sampling points
XMIN = 0.0
XMAX = 3.0
SIZE = 20

x = Vector.linspace(XMIN, XMAX, SIZE)
sample = G.eval(x)

# Discrete Hankel transform with the Bessel function J0
dht = Dht.new(SIZE, 0, XMAX)
g = dht.apply(sample)

num = dht.num
den = dht.den
coef = dht.coef

# Reconstruction
y = Vector[SIZE]
for n in 0...SIZE do
  val = 0.0
  for m in 0...SIZE do
    a = Sf::bessel_J0(dht.sample(n, m))
    val += (2.0/XMAX/XMAX)*a/den[m]*g[m]
#    val += (2.0/XMAX/XMAX)*num[n][m]/den[m]*g[m]
#    val += coef[n][m]*g[m]
  end
  y[n] = val
end

x0 = Vector.linspace(XMIN, XMAX, 100)
y0 = G.eval(x0)

graph([x0, y0], [x, sample], [x, y], "-T X -C -g 3 -X t -Y 'f(t)' --toggle-rotate-y-label -L 'Red: f(t), Green: sample, Blue: DHT of size #{SIZE}'")

