#!/usr/bin/env ruby
# Analysis of the solar activity of 11-years cycle
# from the number of sunspots.
# This example is taken from the MATLAB user's manual Chap 13.

require("gsl")

year, sunspot = Vector.filescan("sunspot.dat")
N = year.size

sunspot.fft!

power = sunspot[1..(N-2)].to_complex2.abs2
freq = Vector.linspace(1, N/2, power.size)/N
period = 1.0/freq
graph(period, power, "-C -g 3 -x 0 40 -X 'Period [year]'")
