#!/usr/bin/env ruby
require("gsl")

N = 2048
SAMPLING = 1000   # 1 kHz
TMAX = 1.0/SAMPLING*N
FREQ1 = 50
FREQ2 = 120
t = Vector.linspace(0, TMAX, N)
x = Sf::sin(2*M_PI*FREQ1*t) + Sf::sin(2*M_PI*FREQ2*t)
y = x.fft

y2 = y.subvector(1, N-2).to_complex2
mag = y2.abs
phase = y2.arg
f = Vector.linspace(0, SAMPLING/2, mag.size)
graph(f, mag, "-C -g 3 -x 0 200 -X 'Frequency [Hz]'")
