#!/usr/bin/env ruby
require("gsl")
include MultiFit

N = 100

y0 = 1.0
A = 2.0
x0 = 3.0
w = 0.5

r = Rng.new()
x = Vector.linspace(0.01, 10, N)
sig = 1
y =  y0 + A*Sf::exp(-pow_2(Sf::log(x/x0)/w)) + 0.1*Ran::gaussian(r, sig, N)

coef, err, chi2, dof = MultiFit::FdfSolver.fit(x, y, "lognormal", [0, 3, 2, 1])
y0 = coef[0]
amp = coef[1]
x0 = coef[2]
w = coef[3]

p coef
p err

graph(x, y, y0+amp*Sf::exp(-pow_2(Sf::log(x/x0)/w)))

