/*
 * $Id: p_header,v 1.4 2000/11/27 01:57:01 keiko Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return doublereal */
/* fnclib */
extern doublereal rd2r_(real *);
extern doublereal rr2d_(real *);
extern doublereal rexp_(real *, integer *, integer *);
extern doublereal rfpi_(void);
extern doublereal rmod_(real *, real *);
/* gnmlib */
extern doublereal rgnlt_(real *);
extern doublereal rgnle_(real *);
extern doublereal rgngt_(real *);
extern doublereal rgnge_(real *);
/* rfalib */
extern doublereal rmax_(real *, integer *, integer *);
extern doublereal rmin_(real *, integer *, integer *);
extern doublereal rsum_(real *, integer *, integer *);
extern doublereal rave_(real *, integer *, integer *);
extern doublereal rvar_(real *, integer *, integer *);
extern doublereal rstd_(real *, integer *, integer *);
extern doublereal rrms_(real *, integer *, integer *);
extern doublereal ramp_(real *, integer *, integer *);
/* rfblib */
extern doublereal rprd_(real *, real *, integer *, integer *, integer *);
extern doublereal rcov_(real *, real *, integer *, integer *, integer *);
extern doublereal rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_gropn(obj, iws)
    VALUE obj, iws;
{
    integer i_iws;

    if ((TYPE(iws) != T_BIGNUM) || (TYPE(iws) != T_FIXNUM)) {
      iws = rb_funcall(iws, rb_intern("to_i"), 0);
    }

    i_iws = NUM2INT(iws);


    gropn_(&i_iws);

    return Qnil;

}

static VALUE
dcl_grfrm(obj)
    VALUE obj;
{
    grfrm_();

    return Qnil;

}

static VALUE
dcl_grfig(obj)
    VALUE obj;
{
    grfig_();

    return Qnil;

}

static VALUE
dcl_grcls(obj)
    VALUE obj;
{
    grcls_();

    return Qnil;

}

static VALUE
dcl_grinit(obj)
    VALUE obj;
{
    grinit_();

    return Qnil;

}

static VALUE
dcl_grsvpt(obj, vxmin, vxmax, vymin, vymax)
    VALUE obj, vxmin, vxmax, vymin, vymax;
{
    real i_vxmin;
    real i_vxmax;
    real i_vymin;
    real i_vymax;

    if (TYPE(vxmin) != T_FLOAT) {
      vxmin = rb_funcall(vxmin, rb_intern("to_f"), 0);
    }
    if (TYPE(vxmax) != T_FLOAT) {
      vxmax = rb_funcall(vxmax, rb_intern("to_f"), 0);
    }
    if (TYPE(vymin) != T_FLOAT) {
      vymin = rb_funcall(vymin, rb_intern("to_f"), 0);
    }
    if (TYPE(vymax) != T_FLOAT) {
      vymax = rb_funcall(vymax, rb_intern("to_f"), 0);
    }

    i_vxmin = (real)NUM2DBL(vxmin);
    i_vxmax = (real)NUM2DBL(vxmax);
    i_vymin = (real)NUM2DBL(vymin);
    i_vymax = (real)NUM2DBL(vymax);


    grsvpt_(&i_vxmin, &i_vxmax, &i_vymin, &i_vymax);

    return Qnil;

}

static VALUE
dcl_grswnd(obj, uxmin, uxmax, uymin, uymax)
    VALUE obj, uxmin, uxmax, uymin, uymax;
{
    real i_uxmin;
    real i_uxmax;
    real i_uymin;
    real i_uymax;

    if (TYPE(uxmin) != T_FLOAT) {
      uxmin = rb_funcall(uxmin, rb_intern("to_f"), 0);
    }
    if (TYPE(uxmax) != T_FLOAT) {
      uxmax = rb_funcall(uxmax, rb_intern("to_f"), 0);
    }
    if (TYPE(uymin) != T_FLOAT) {
      uymin = rb_funcall(uymin, rb_intern("to_f"), 0);
    }
    if (TYPE(uymax) != T_FLOAT) {
      uymax = rb_funcall(uymax, rb_intern("to_f"), 0);
    }

    i_uxmin = (real)NUM2DBL(uxmin);
    i_uxmax = (real)NUM2DBL(uxmax);
    i_uymin = (real)NUM2DBL(uymin);
    i_uymax = (real)NUM2DBL(uymax);


    grswnd_(&i_uxmin, &i_uxmax, &i_uymin, &i_uymax);

    return Qnil;

}

static VALUE
dcl_grssim(obj, simfac, vxoff, vyoff)
    VALUE obj, simfac, vxoff, vyoff;
{
    real i_simfac;
    real i_vxoff;
    real i_vyoff;

    if (TYPE(simfac) != T_FLOAT) {
      simfac = rb_funcall(simfac, rb_intern("to_f"), 0);
    }
    if (TYPE(vxoff) != T_FLOAT) {
      vxoff = rb_funcall(vxoff, rb_intern("to_f"), 0);
    }
    if (TYPE(vyoff) != T_FLOAT) {
      vyoff = rb_funcall(vyoff, rb_intern("to_f"), 0);
    }

    i_simfac = (real)NUM2DBL(simfac);
    i_vxoff = (real)NUM2DBL(vxoff);
    i_vyoff = (real)NUM2DBL(vyoff);


    grssim_(&i_simfac, &i_vxoff, &i_vyoff);

    return Qnil;

}

static VALUE
dcl_grsmpl(obj, plx, ply, plrot)
    VALUE obj, plx, ply, plrot;
{
    real i_plx;
    real i_ply;
    real i_plrot;

    if (TYPE(plx) != T_FLOAT) {
      plx = rb_funcall(plx, rb_intern("to_f"), 0);
    }
    if (TYPE(ply) != T_FLOAT) {
      ply = rb_funcall(ply, rb_intern("to_f"), 0);
    }
    if (TYPE(plrot) != T_FLOAT) {
      plrot = rb_funcall(plrot, rb_intern("to_f"), 0);
    }

    i_plx = (real)NUM2DBL(plx);
    i_ply = (real)NUM2DBL(ply);
    i_plrot = (real)NUM2DBL(plrot);


    grsmpl_(&i_plx, &i_ply, &i_plrot);

    return Qnil;

}

static VALUE
dcl_grstxy(obj, txmin, txmax, tymin, tymax)
    VALUE obj, txmin, txmax, tymin, tymax;
{
    real i_txmin;
    real i_txmax;
    real i_tymin;
    real i_tymax;

    if (TYPE(txmin) != T_FLOAT) {
      txmin = rb_funcall(txmin, rb_intern("to_f"), 0);
    }
    if (TYPE(txmax) != T_FLOAT) {
      txmax = rb_funcall(txmax, rb_intern("to_f"), 0);
    }
    if (TYPE(tymin) != T_FLOAT) {
      tymin = rb_funcall(tymin, rb_intern("to_f"), 0);
    }
    if (TYPE(tymax) != T_FLOAT) {
      tymax = rb_funcall(tymax, rb_intern("to_f"), 0);
    }

    i_txmin = (real)NUM2DBL(txmin);
    i_txmax = (real)NUM2DBL(txmax);
    i_tymin = (real)NUM2DBL(tymin);
    i_tymax = (real)NUM2DBL(tymax);


    grstxy_(&i_txmin, &i_txmax, &i_tymin, &i_tymax);

    return Qnil;

}

static VALUE
dcl_grstrn(obj, itr)
    VALUE obj, itr;
{
    integer i_itr;

    if ((TYPE(itr) != T_BIGNUM) || (TYPE(itr) != T_FIXNUM)) {
      itr = rb_funcall(itr, rb_intern("to_i"), 0);
    }

    i_itr = NUM2INT(itr);


    grstrn_(&i_itr);

    return Qnil;

}

static VALUE
dcl_grstrf(obj)
    VALUE obj;
{
    grstrf_();

    return Qnil;

}

#if DCLVER >= 530

static VALUE
dcl_grscwd(obj, cxmin, cxmax, cymin, cymax)
    VALUE obj, cxmin, cxmax, cymin, cymax;
{
    real i_cxmin;
    real i_cxmax;
    real i_cymin;
    real i_cymax;

    if (TYPE(cxmin) != T_FLOAT) {
      cxmin = rb_funcall(cxmin, rb_intern("to_f"), 0);
    }
    if (TYPE(cxmax) != T_FLOAT) {
      cxmax = rb_funcall(cxmax, rb_intern("to_f"), 0);
    }
    if (TYPE(cymin) != T_FLOAT) {
      cymin = rb_funcall(cymin, rb_intern("to_f"), 0);
    }
    if (TYPE(cymax) != T_FLOAT) {
      cymax = rb_funcall(cymax, rb_intern("to_f"), 0);
    }

    i_cxmin = (real)NUM2DBL(cxmin);
    i_cxmax = (real)NUM2DBL(cxmax);
    i_cymin = (real)NUM2DBL(cymin);
    i_cymax = (real)NUM2DBL(cymax);


    grscwd_(&i_cxmin, &i_cxmax, &i_cymin, &i_cymax);

    return Qnil;

}

#endif
void
init_grph2_grpack(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "gropn", dcl_gropn, 1);
    rb_define_module_function(mDCL, "grfrm", dcl_grfrm, 0);
    rb_define_module_function(mDCL, "grfig", dcl_grfig, 0);
    rb_define_module_function(mDCL, "grcls", dcl_grcls, 0);
    rb_define_module_function(mDCL, "grinit", dcl_grinit, 0);
    rb_define_module_function(mDCL, "grsvpt", dcl_grsvpt, 4);
    rb_define_module_function(mDCL, "grswnd", dcl_grswnd, 4);
    rb_define_module_function(mDCL, "grssim", dcl_grssim, 3);
    rb_define_module_function(mDCL, "grsmpl", dcl_grsmpl, 3);
    rb_define_module_function(mDCL, "grstxy", dcl_grstxy, 4);
    rb_define_module_function(mDCL, "grstrn", dcl_grstrn, 1);
    rb_define_module_function(mDCL, "grstrf", dcl_grstrf, 0);
#if DCLVER >= 530
    rb_define_module_function(mDCL, "grscwd", dcl_grscwd, 4);
#endif
}
