#
# uspk07.rb
#
# $Id: uspk07.rb,v 1.1 2000/11/22 14:36:03 keiko Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


n = 200
m = 10
x = NArray.sfloat(n)
y = NArray.sfloat(n)
a = NArray.sfloat(m)

#-----------------------------------------------------------------------
dt = 1.0/(n-1)
for j in 0..m-1
  jj = j*2+1
  a[j] = (-1.0)**(j+1) *2.0/(jj*PI)
end

x = x.indgen * dt
for i in 0..n-1
  t = dt*i*2*PI
  yy = 0.0
  for j in 0..m-1
    jj = j*2+1
    yd = a[j]*cos(jj*t)
    yy = yy + yd
  end
  y[i] = yy*2.0
end

#-----------------------------------------------------------------------
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

#      --- X AXIS ---
DCL::uzrset('UYUSER', 0.0)
DCL::uscset('CXSIDE', 'U')

#      --- Y AXIS ---
DCL::uziset('IROTLYL', 1)
DCL::uziset('ICENTYL', 0)
DCL::uscset('CYSIDE', 'L')

#      --- etc. ---
DCL::uziset('INNER', -1)
DCL::uscset('CBLKT', '[]')

DCL::ussttl('TIME', 'SEC', 'VOLTAGE', 'mV')
DCL::usgrph(x, y)

DCL::grcls

